/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.awt.Color;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.WithAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WayPoint
extends WithAttributes
implements Comparable<WayPoint> {
    public final LatLon latlon;
    public final EastNorth eastNorth;
    public double time;
    public Color customColoring;
    public boolean drawLine;
    public int dir;
    public static final SimpleDateFormat GPXTIMEFMT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    public static final SimpleDateFormat GPXTIMEFMT2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public WayPoint(LatLon latLon) {
        this.latlon = latLon;
        this.eastNorth = Main.proj.latlon2eastNorth(latLon);
    }

    public String toString() {
        return "WayPoint (" + (this.attr.containsKey("name") ? this.attr.get("name") + ", " : "") + this.latlon.toString() + ", " + this.attr + ")";
    }

    public void setTime() {
        if (!this.attr.containsKey("time")) {
            return;
        }
        Date date = GPXTIMEFMT.parse(this.attr.get("time").toString(), new ParsePosition(0));
        if (date == null) {
            date = GPXTIMEFMT2.parse(this.attr.get("time").toString(), new ParsePosition(0));
        }
        if (date != null) {
            this.time = (double)date.getTime() / 1000.0;
        }
    }

    public void setGarminCommentTime(String string) {
        if (this.time != 0.0) {
            return;
        }
        if (!this.attr.containsKey(string)) {
            return;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yy HH:mm:ss");
        Date date = simpleDateFormat.parse(this.attr.get(string).toString(), new ParsePosition(0));
        if (date != null) {
            this.time = (double)date.getTime() / 1000.0;
        }
    }

    @Override
    public int compareTo(WayPoint wayPoint) {
        return Double.compare(this.time, wayPoint.time);
    }
}

