/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeVisitor
implements Visitor {
    public Map<OsmPrimitive, OsmPrimitive> conflicts = new HashMap<OsmPrimitive, OsmPrimitive>();
    private final DataSet ds;
    private final DataSet mergeds;
    private final HashMap<Long, Node> nodeshash = new HashMap();
    private final HashMap<Long, Way> wayshash = new HashMap();
    private final HashMap<Long, Relation> relshash = new HashMap();
    private final Map<OsmPrimitive, OsmPrimitive> merged = new HashMap<OsmPrimitive, OsmPrimitive>();

    public MergeVisitor(DataSet dataSet, DataSet dataSet2) {
        this.ds = dataSet;
        this.mergeds = dataSet2;
        for (Node osmPrimitive : dataSet.nodes) {
            if (osmPrimitive.id == 0L) continue;
            this.nodeshash.put(osmPrimitive.id, osmPrimitive);
        }
        for (Way way : dataSet.ways) {
            if (way.id == 0L) continue;
            this.wayshash.put(way.id, way);
        }
        for (Relation relation : dataSet.relations) {
            if (relation.id == 0L) continue;
            this.relshash.put(relation.id, relation);
        }
    }

    private <P extends OsmPrimitive> void genMerge(P p, Collection<P> collection, Collection<P> collection2, HashMap<Long, P> hashMap) {
        if (this.mergeAfterId(collection, hashMap, p)) {
            return;
        }
        for (OsmPrimitive osmPrimitive : collection) {
            if (!MergeVisitor.match(osmPrimitive, p) || collection2.contains(osmPrimitive)) continue;
            this.merged.put(p, osmPrimitive);
            this.mergeCommon(osmPrimitive, p);
            return;
        }
        collection.add(p);
    }

    @Override
    public void visit(Node node) {
        this.genMerge(node, this.ds.nodes, this.mergeds.nodes, this.nodeshash);
    }

    @Override
    public void visit(Way way) {
        this.fixWay(way);
        this.genMerge(way, this.ds.ways, this.mergeds.ways, this.wayshash);
    }

    @Override
    public void visit(Relation relation) {
        this.fixRelation(relation);
        this.genMerge(relation, this.ds.relations, this.mergeds.relations, this.relshash);
    }

    public void fixReferences() {
        for (Way osmPrimitive : this.ds.ways) {
            this.fixWay(osmPrimitive);
        }
        for (Relation relation : this.ds.relations) {
            this.fixRelation(relation);
        }
        for (OsmPrimitive osmPrimitive : this.conflicts.values()) {
            if (osmPrimitive instanceof Way) {
                this.fixWay((Way)osmPrimitive);
                continue;
            }
            if (!(osmPrimitive instanceof Relation)) continue;
            this.fixRelation((Relation)osmPrimitive);
        }
    }

    private void fixWay(Way way) {
        boolean bl = false;
        LinkedList<Node> linkedList = new LinkedList<Node>();
        for (Node node : way.nodes) {
            Node node2 = (Node)this.merged.get(node);
            linkedList.add(node2 == null ? node : node2);
            if (node2 == null) continue;
            bl = true;
        }
        if (bl) {
            way.nodes.clear();
            way.nodes.addAll(linkedList);
        }
    }

    private void fixRelation(Relation relation) {
        boolean bl = false;
        LinkedList<RelationMember> linkedList = new LinkedList<RelationMember>();
        for (RelationMember relationMember : relation.members) {
            OsmPrimitive osmPrimitive = this.merged.get(relationMember.member);
            if (osmPrimitive == null) {
                linkedList.add(relationMember);
                continue;
            }
            RelationMember relationMember2 = new RelationMember(relationMember);
            relationMember2.member = osmPrimitive;
            linkedList.add(relationMember2);
            bl = true;
        }
        if (bl) {
            relation.members.clear();
            relation.members.addAll(linkedList);
        }
    }

    private static <P extends OsmPrimitive> boolean match(P p, P p2) {
        if (!(p.id != 0L && p2.id != 0L || p.incomplete || p2.incomplete)) {
            return MergeVisitor.realMatch(p, p2);
        }
        return p.id == p2.id;
    }

    private static boolean realMatch(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
        if (osmPrimitive instanceof Node && osmPrimitive2 instanceof Node) {
            return MergeVisitor.realMatch((Node)osmPrimitive, (Node)osmPrimitive2);
        }
        if (osmPrimitive instanceof Way && osmPrimitive2 instanceof Way) {
            return MergeVisitor.realMatch((Way)osmPrimitive, (Way)osmPrimitive2);
        }
        if (osmPrimitive instanceof Relation && osmPrimitive2 instanceof Relation) {
            return MergeVisitor.realMatch((Relation)osmPrimitive, (Relation)osmPrimitive2);
        }
        throw new RuntimeException("arguments have unknown type");
    }

    private static boolean realMatch(Node node, Node node2) {
        return node.coor.equalsEpsilon(node2.coor);
    }

    private static boolean realMatch(Way way, Way way2) {
        if (way.nodes.size() != way2.nodes.size()) {
            return false;
        }
        Iterator<Node> iterator = way.nodes.iterator();
        for (Node node : way2.nodes) {
            if (MergeVisitor.match(node, (OsmPrimitive)iterator.next())) continue;
            return false;
        }
        return true;
    }

    private static boolean realMatch(Relation relation, Relation relation2) {
        if (relation.members.size() != relation2.members.size()) {
            return false;
        }
        for (RelationMember relationMember : relation.members) {
            if (relation2.members.contains(relationMember)) continue;
            return false;
        }
        return true;
    }

    private void mergeCommon(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
        if (osmPrimitive2.deleted) {
            osmPrimitive.delete(true);
        }
        if (osmPrimitive.id == 0L || !osmPrimitive.modified || osmPrimitive2.modified) {
            if (osmPrimitive.id == 0L && osmPrimitive2.id != 0L) {
                osmPrimitive.id = osmPrimitive2.id;
                osmPrimitive.modified = osmPrimitive2.modified;
            } else if (osmPrimitive.id != 0L && osmPrimitive2.id != 0L && osmPrimitive2.modified) {
                osmPrimitive.modified = true;
            }
        }
        if (osmPrimitive2.keys == null) {
            return;
        }
        if (osmPrimitive.keySet().containsAll(osmPrimitive2.keys.keySet())) {
            return;
        }
        if (osmPrimitive.keys == null) {
            osmPrimitive.keys = osmPrimitive2.keys;
        } else {
            osmPrimitive.keys.putAll(osmPrimitive2.keys);
        }
        osmPrimitive.modified = true;
    }

    private <P extends OsmPrimitive> boolean mergeAfterId(Collection<P> collection, HashMap<Long, P> hashMap, P p) {
        Object object;
        if (hashMap.containsKey(p.id) && ((OsmPrimitive)(object = (OsmPrimitive)hashMap.get(p.id))).realEqual(p, true)) {
            this.merged.put(p, (OsmPrimitive)object);
            return true;
        }
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive.realEqual(p, false)) {
                this.merged.put(p, osmPrimitive);
                return true;
            }
            if (osmPrimitive.realEqual(p, true)) {
                Date date = osmPrimitive.getTimestamp();
                Date date2 = p.getTimestamp();
                this.merged.put(p, osmPrimitive);
                if (date.before(date2)) {
                    osmPrimitive.modified = p.modified;
                    osmPrimitive.setTimestamp(p.getTimestamp());
                }
                return true;
            }
            if (osmPrimitive.id != p.id || osmPrimitive.id == 0L) continue;
            Date date = osmPrimitive.getTimestamp();
            Date date3 = p.getTimestamp();
            if (osmPrimitive.incomplete || p.incomplete) {
                if (osmPrimitive.incomplete) {
                    osmPrimitive.cloneFrom(p);
                }
            } else if (osmPrimitive.modified && p.modified) {
                this.conflicts.put(osmPrimitive, p);
            } else if (!osmPrimitive.modified && !p.modified) {
                if (date.before(date3)) {
                    osmPrimitive.cloneFrom(p);
                }
            } else if (p.modified) {
                if (date.after(date3)) {
                    this.conflicts.put(osmPrimitive, p);
                } else {
                    osmPrimitive.cloneFrom(p);
                }
            } else if (osmPrimitive.modified && date.before(date3)) {
                this.conflicts.put(osmPrimitive, p);
            }
            this.merged.put(p, osmPrimitive);
            return true;
        }
        return false;
    }
}

