/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.tools.Base64;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class OsmConnection {
    protected boolean cancel = false;
    protected HttpURLConnection activeConnection;
    private static OsmAuth authentication = new OsmAuth();

    protected final void initAuthentication() {
        OsmConnection.authentication.authCancelled = false;
        OsmConnection.authentication.passwordtried = false;
    }

    protected final boolean isAuthCancelled() {
        return OsmConnection.authentication.authCancelled;
    }

    public void cancel() {
        Main.pleaseWaitDlg.currentAction.setText(I18n.tr("Aborting..."));
        this.cancel = true;
        if (this.activeConnection != null) {
            this.activeConnection.setConnectTimeout(100);
            this.activeConnection.setReadTimeout(100);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.activeConnection.disconnect();
        }
    }

    protected void addAuth(HttpURLConnection httpURLConnection) throws CharacterCodingException {
        CharsetEncoder charsetEncoder = Charset.forName("UTF-8").newEncoder();
        String string = Main.pref.get("osm-server.username") + ":" + Main.pref.get("osm-server.password");
        ByteBuffer byteBuffer = charsetEncoder.encode(CharBuffer.wrap(string));
        httpURLConnection.addRequestProperty("Authorization", "Basic " + Base64.encode(byteBuffer));
    }

    static {
        try {
            HttpURLConnection.setFollowRedirects(true);
            Authenticator.setDefault(authentication);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static class OsmAuth
    extends Authenticator {
        boolean passwordtried = false;
        boolean authCancelled = false;

        private OsmAuth() {
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            String string = Main.pref.get("osm-server.username");
            String string2 = Main.pref.get("osm-server.password");
            if (this.passwordtried || string.equals("") || string2.equals("")) {
                JPanel jPanel = new JPanel(new GridBagLayout());
                if (!string.equals("") && !string2.equals("")) {
                    jPanel.add((Component)new JLabel(I18n.tr("Incorrect password or username.")), GBC.eop());
                }
                jPanel.add((Component)new JLabel(I18n.tr("Username")), GBC.std().insets(0, 0, 10, 0));
                JTextField jTextField = new JTextField(string, 20);
                jPanel.add((Component)jTextField, GBC.eol());
                jPanel.add((Component)new JLabel(I18n.tr("Password")), GBC.std().insets(0, 0, 10, 0));
                JPasswordField jPasswordField = new JPasswordField(string2, 20);
                jPanel.add((Component)jPasswordField, GBC.eol());
                JLabel jLabel = new JLabel(I18n.tr("Warning: The password is transferred unencrypted."));
                jLabel.setFont(jLabel.getFont().deriveFont(2));
                jPanel.add((Component)jLabel, GBC.eop());
                JCheckBox jCheckBox = new JCheckBox(I18n.tr("Save user and password (unencrypted)"), !string.equals("") && !string2.equals(""));
                jPanel.add((Component)jCheckBox, GBC.eop());
                int n = new ExtendedDialog(Main.parent, I18n.tr("Enter Password"), jPanel, new String[]{I18n.tr("Login"), I18n.tr("Cancel")}, new String[]{"ok.png", "cancel.png"}).getValue();
                if (n != 1) {
                    this.authCancelled = true;
                    return null;
                }
                string = jTextField.getText();
                string2 = String.valueOf(jPasswordField.getPassword());
                if (jCheckBox.isSelected()) {
                    Main.pref.put("osm-server.username", string);
                    Main.pref.put("osm-server.password", string2);
                }
                if (string.equals("")) {
                    return null;
                }
            }
            this.passwordtried = true;
            return new PasswordAuthentication(string, string2.toCharArray());
        }
    }

    public static class OsmParseException
    extends Exception {
        public OsmParseException() {
        }

        public OsmParseException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public OsmParseException(String string) {
            super(string);
        }

        public OsmParseException(Throwable throwable) {
            super(throwable);
        }
    }
}

