/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.DateUtils;

public class OsmWriter
extends XmlWriter
implements Visitor {
    private long newIdCounter = -1L;
    public HashMap<OsmPrimitive, Long> usedNewIds = new HashMap();
    private final boolean osmConform;
    private final Changeset changeset;
    private Visitor typeWriteVisitor = new Visitor(){

        public void visit(Node node) {
            OsmWriter.this.out.print("node");
        }

        public void visit(Way way) {
            OsmWriter.this.out.print("way");
        }

        public void visit(Relation relation) {
            OsmWriter.this.out.print("relation");
        }
    };

    public OsmWriter(PrintWriter printWriter, boolean bl, Changeset changeset) {
        super(printWriter);
        this.osmConform = bl;
        this.changeset = changeset;
    }

    public void visit(Node node) {
        if (node.incomplete) {
            return;
        }
        this.addCommon(node, "node");
        this.out.print(" lat='" + node.coor.lat() + "' lon='" + node.coor.lon() + "'");
        this.addTags(node, "node", true);
    }

    public void visit(Way way) {
        if (way.incomplete) {
            return;
        }
        this.addCommon(way, "way");
        this.out.println(">");
        for (Node node : way.nodes) {
            this.out.println("    <nd ref='" + this.getUsedId(node) + "' />");
        }
        this.addTags(way, "way", false);
    }

    public void visit(Relation relation) {
        if (relation.incomplete) {
            return;
        }
        this.addCommon(relation, "relation");
        this.out.println(">");
        for (RelationMember relationMember : relation.members) {
            this.out.print("    <member type='");
            relationMember.member.visit(this.typeWriteVisitor);
            this.out.println("' ref='" + this.getUsedId(relationMember.member) + "' role='" + XmlWriter.encode(relationMember.role) + "' />");
        }
        this.addTags(relation, "relation", false);
    }

    private long getUsedId(OsmPrimitive osmPrimitive) {
        long l;
        if (osmPrimitive.id != 0L) {
            return osmPrimitive.id;
        }
        if (this.usedNewIds.containsKey(osmPrimitive)) {
            return this.usedNewIds.get(osmPrimitive);
        }
        this.usedNewIds.put(osmPrimitive, this.newIdCounter);
        if (this.osmConform) {
            l = 0L;
        } else {
            long l2 = this.newIdCounter;
            l = l2;
            this.newIdCounter = l2 - 1L;
        }
        return l;
    }

    private void addTags(OsmPrimitive osmPrimitive, String string, boolean bl) {
        if (osmPrimitive.keys != null) {
            if (bl) {
                this.out.println(">");
            }
            for (Map.Entry<String, String> entry : osmPrimitive.keys.entrySet()) {
                this.out.println("    <tag k='" + XmlWriter.encode(entry.getKey()) + "' v='" + XmlWriter.encode(entry.getValue()) + "' />");
            }
            this.out.println("  </" + string + ">");
        } else if (bl) {
            this.out.println(" />");
        } else {
            this.out.println("  </" + string + ">");
        }
    }

    private void addCommon(OsmPrimitive osmPrimitive, String string) {
        this.out.print("  <" + string + " id='" + this.getUsedId(osmPrimitive) + "'");
        if (!this.osmConform) {
            String string2 = null;
            if (osmPrimitive.deleted) {
                string2 = "delete";
            } else if (osmPrimitive.modified) {
                string2 = "modify";
            }
            if (string2 != null) {
                this.out.print(" action='" + string2 + "'");
            }
        }
        if (!osmPrimitive.isTimestampEmpty()) {
            this.out.print(" timestamp='" + DateUtils.fromDate(osmPrimitive.getTimestamp()) + "'");
        }
        if (osmPrimitive.user != null) {
            this.out.print(" user='" + XmlWriter.encode(osmPrimitive.user.name) + "'");
        }
        this.out.print(" visible='" + osmPrimitive.visible + "'");
        if (osmPrimitive.version != -1) {
            this.out.print(" version='" + osmPrimitive.version + "'");
        }
        if (this.changeset != null && this.changeset.id != 0L) {
            this.out.print(" changeset='" + this.changeset.id + "'");
        }
    }

    public static final class Single
    extends Osm {
        private final OsmPrimitive osm;
        private final boolean osmConform;
        private final Changeset changeset;

        public Single(OsmPrimitive osmPrimitive, boolean bl, Changeset changeset) {
            this.osm = osmPrimitive;
            this.osmConform = bl;
            this.changeset = changeset;
        }

        public void write(PrintWriter printWriter) {
            this.osm.visit(new OsmWriter(printWriter, this.osmConform, this.changeset));
        }
    }

    public static final class All
    extends Osm {
        private final DataSet ds;
        private final boolean osmConform;

        public All(DataSet dataSet, boolean bl) {
            this.ds = dataSet;
            this.osmConform = bl;
        }

        public void write(PrintWriter printWriter) {
            OsmWriter osmWriter = new OsmWriter(printWriter, this.osmConform, null);
            for (Node osmPrimitive : this.ds.nodes) {
                if (!this.shouldWrite(osmPrimitive)) continue;
                osmWriter.visit(osmPrimitive);
            }
            for (Way way : this.ds.ways) {
                if (!this.shouldWrite(way)) continue;
                osmWriter.visit(way);
            }
            for (Relation relation : this.ds.relations) {
                if (!this.shouldWrite(relation)) continue;
                osmWriter.visit(relation);
            }
        }

        private boolean shouldWrite(OsmPrimitive osmPrimitive) {
            return osmPrimitive.id != 0L || !osmPrimitive.deleted;
        }

        public void header(PrintWriter printWriter) {
            super.header(printWriter);
            for (DataSource dataSource : this.ds.dataSources) {
                printWriter.println("  <bounds minlat='" + dataSource.bounds.min.lat() + "' minlon='" + dataSource.bounds.min.lon() + "' maxlat='" + dataSource.bounds.max.lat() + "' maxlon='" + dataSource.bounds.max.lon() + "' origin='" + XmlWriter.encode(dataSource.origin) + "' />");
            }
        }
    }

    public static abstract class Osm
    implements XmlWriter.OsmWriterInterface {
        public void header(PrintWriter printWriter) {
            printWriter.print("<osm version='");
            printWriter.print(Main.pref.get("osm-server.version", "0.5"));
            printWriter.println("' generator='JOSM'>");
        }

        public void footer(PrintWriter printWriter) {
            printWriter.println("</osm>");
        }
    }
}

