/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;

public class WikiReader {
    private final String baseurl;

    public WikiReader(String string) {
        this.baseurl = string;
    }

    public String read(String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new URL(string).openStream(), "utf-8"));
        if (string.startsWith(this.baseurl) && !string.endsWith("?format=txt")) {
            return this.readFromTrac(bufferedReader, string);
        }
        return this.readNormal(bufferedReader);
    }

    private String readNormal(BufferedReader bufferedReader) throws IOException {
        String string = "";
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            if (!string2.contains("[[TranslatedPages]]")) {
                string = string + string2.replaceAll(" />", ">") + "\n";
            }
            string2 = bufferedReader.readLine();
        }
        return "<html>" + string + "</html>";
    }

    private String readFromTrac(BufferedReader bufferedReader, String string) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        String string2 = "";
        String string3 = bufferedReader.readLine();
        while (string3 != null) {
            if (string3.contains("<div id=\"searchable\">")) {
                bl = true;
            } else if (string3.contains("<div class=\"wiki-toc trac-nav\"")) {
                bl2 = true;
            } else if (string3.contains("<div class=\"wikipage searchable\">")) {
                bl = true;
            } else if (string3.contains("<div class=\"buttons\">")) {
                bl = false;
            }
            if (bl && !bl2) {
                string2 = string2 + string3.replaceAll("<img src=\"/", "<img src=\"" + this.baseurl + "/").replaceAll("href=\"/", "href=\"" + this.baseurl + "/").replaceAll(" />", ">") + "\n";
            } else if (bl2 && string3.contains("</div>")) {
                bl2 = false;
            }
            string3 = bufferedReader.readLine();
        }
        return "<html>" + string2 + "</html>";
    }
}

