/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.corrector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.corrector.RoleCorrection;
import org.openstreetmap.josm.corrector.TagCorrection;
import org.openstreetmap.josm.corrector.TagCorrector;
import org.openstreetmap.josm.corrector.UserCancelException;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReverseWayTagCorrector
extends TagCorrector<Way> {
    private static PrefixSuffixSwitcher[] prefixSuffixSwitchers = new PrefixSuffixSwitcher[]{new PrefixSuffixSwitcher("left", "right"), new PrefixSuffixSwitcher("forward", "backward")};

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<Command> execute(Way way) throws UserCancelException {
        String string;
        HashMap<OsmPrimitive, List<TagCorrection>> hashMap = new HashMap<OsmPrimitive, List<TagCorrection>>();
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        arrayList.add(way);
        arrayList.addAll(way.nodes);
        for (OsmPrimitive object : arrayList) {
            hashMap.put(object, new ArrayList());
            for (Object object2 : object.keySet()) {
                void var8_11;
                String string2;
                block8: {
                    Object object3;
                    String string3;
                    Object object4;
                    block6: {
                        block7: {
                            String string4 = object2;
                            string = string2 = object.get((String)object2);
                            if (!((String)object2).equals("oneway")) break block6;
                            if (!string2.equals("-1")) break block7;
                            string = "yes";
                            break block8;
                        }
                        object4 = OsmUtils.getOsmBoolean(string2);
                        if (object4 == null || !((Boolean)object4).booleanValue()) break block8;
                        string = "-1";
                        break block8;
                    }
                    object4 = prefixSuffixSwitchers;
                    int n = ((PrefixSuffixSwitcher[])object4).length;
                    for (int i = 0; i < n && ((String)object2).equals(string3 = ((PrefixSuffixSwitcher)(object3 = object4[i])).apply((String)object2)); ++i) {
                    }
                }
                if (((String)object2).equals(var8_11) && string2.equals(string)) continue;
                ((List)hashMap.get(object)).add(new TagCorrection((String)object2, string2, (String)var8_11, string));
            }
        }
        HashMap hashMap2 = new HashMap();
        hashMap2.put(way, new ArrayList());
        for (Relation relation : Main.ds.relations) {
            for (RelationMember relationMember : relation.members) {
                if (!relationMember.member.realEqual(way, true) || relationMember.role.length() == 0) continue;
                boolean bl = false;
                string = null;
                for (PrefixSuffixSwitcher prefixSuffixSwitcher : prefixSuffixSwitchers) {
                    string = prefixSuffixSwitcher.apply(relationMember.role);
                    if (string.equals(relationMember.role)) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                ((List)hashMap2.get(way)).add(new RoleCorrection(relation, relationMember, string));
            }
        }
        return this.applyCorrections(hashMap, hashMap2, I18n.tr("When reversing this way, the following changes to properties of the way and its nodes are suggested in order to maintain data consistency."));
    }

    private static class PrefixSuffixSwitcher {
        private final String a;
        private final String b;
        private final Pattern startPattern;
        private final Pattern endPattern;
        private final String SEPARATOR = "[:_]?";

        public PrefixSuffixSwitcher(String string, String string2) {
            this.a = string;
            this.b = string2;
            this.startPattern = Pattern.compile("^(" + string + "|" + string2 + ")" + "[:_]?", 2);
            this.endPattern = Pattern.compile("[:_]?(" + string + "|" + string2 + ")$", 2);
        }

        public String apply(String string) {
            Matcher matcher = this.startPattern.matcher(string);
            if (!matcher.lookingAt()) {
                matcher = this.endPattern.matcher(string);
            }
            if (matcher.lookingAt()) {
                String string2 = matcher.group(1).toLowerCase();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string.substring(0, matcher.start(1)));
                stringBuilder.append(string2.equals(this.a) ? this.b : this.a);
                stringBuilder.append(string.substring(matcher.end(1)));
                return stringBuilder.toString();
            }
            return string;
        }
    }
}

