/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.awt.geom.Area;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSet
implements Cloneable {
    public Collection<Node> nodes = new LinkedList<Node>();
    public Collection<Way> ways = new LinkedList<Way>();
    public Collection<Relation> relations = new LinkedList<Relation>();
    public Collection<DataSource> dataSources = new LinkedList<DataSource>();
    public static Collection<SelectionChangedListener> selListeners = new LinkedList<SelectionChangedListener>();

    public List<OsmPrimitive> allPrimitives() {
        LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
        linkedList.addAll(this.nodes);
        linkedList.addAll(this.ways);
        linkedList.addAll(this.relations);
        return linkedList;
    }

    public Collection<OsmPrimitive> allNonDeletedPrimitives() {
        LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : this.allPrimitives()) {
            if (osmPrimitive.deleted) continue;
            linkedList.add(osmPrimitive);
        }
        return linkedList;
    }

    public Collection<OsmPrimitive> allNonDeletedCompletePrimitives() {
        LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : this.allPrimitives()) {
            if (osmPrimitive.deleted || osmPrimitive.incomplete) continue;
            linkedList.add(osmPrimitive);
        }
        return linkedList;
    }

    public Collection<OsmPrimitive> allNonDeletedPhysicalPrimitives() {
        LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : this.allPrimitives()) {
            if (osmPrimitive.deleted || osmPrimitive.incomplete || osmPrimitive instanceof Relation) continue;
            linkedList.add(osmPrimitive);
        }
        return linkedList;
    }

    public void addPrimitive(OsmPrimitive osmPrimitive) {
        if (osmPrimitive instanceof Node) {
            this.nodes.add((Node)osmPrimitive);
        } else if (osmPrimitive instanceof Way) {
            this.ways.add((Way)osmPrimitive);
        } else if (osmPrimitive instanceof Relation) {
            this.relations.add((Relation)osmPrimitive);
        }
    }

    public Collection<OsmPrimitive> getSelectedPhysical() {
        Collection<OsmPrimitive> collection = this.getSelected(this.nodes);
        collection.addAll(this.getSelected(this.ways));
        return collection;
    }

    public Collection<OsmPrimitive> getSelected() {
        Collection<OsmPrimitive> collection = this.getSelected(this.nodes);
        collection.addAll(this.getSelected(this.ways));
        collection.addAll(this.getSelected(this.relations));
        return collection;
    }

    public Collection<OsmPrimitive> getSelectedNodes() {
        return this.getSelected(this.nodes);
    }

    public Collection<OsmPrimitive> getSelectedWays() {
        return this.getSelected(this.ways);
    }

    public Collection<OsmPrimitive> getSelectedRelations() {
        return this.getSelected(this.relations);
    }

    public void setSelected(Collection<? extends OsmPrimitive> collection) {
        this.clearSelection(this.nodes);
        this.clearSelection(this.ways);
        this.clearSelection(this.relations);
        for (OsmPrimitive osmPrimitive : collection) {
            osmPrimitive.selected = true;
        }
        DataSet.fireSelectionChanged(collection);
    }

    public void setSelected(OsmPrimitive ... osmPrimitiveArray) {
        if (osmPrimitiveArray.length == 1 && osmPrimitiveArray[0] == null) {
            this.setSelected(new OsmPrimitive[0]);
            return;
        }
        this.clearSelection(this.nodes);
        this.clearSelection(this.ways);
        this.clearSelection(this.relations);
        for (OsmPrimitive osmPrimitive : osmPrimitiveArray) {
            if (osmPrimitive == null) continue;
            osmPrimitive.selected = true;
        }
        DataSet.fireSelectionChanged(Arrays.asList(osmPrimitiveArray));
    }

    private void clearSelection(Collection<? extends OsmPrimitive> collection) {
        if (collection == null) {
            return;
        }
        for (OsmPrimitive osmPrimitive : collection) {
            osmPrimitive.selected = false;
        }
    }

    private Collection<OsmPrimitive> getSelected(Collection<? extends OsmPrimitive> collection) {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        if (collection == null) {
            return hashSet;
        }
        for (OsmPrimitive osmPrimitive : collection) {
            if (!osmPrimitive.selected || osmPrimitive.deleted) continue;
            hashSet.add(osmPrimitive);
        }
        return hashSet;
    }

    public static void fireSelectionChanged(Collection<? extends OsmPrimitive> collection) {
        for (SelectionChangedListener selectionChangedListener : selListeners) {
            selectionChangedListener.selectionChanged(collection);
        }
    }

    public DataSet clone() {
        DataSet dataSet = new DataSet();
        for (Node object : this.nodes) {
            dataSet.nodes.add(new Node(object));
        }
        for (Way way : this.ways) {
            dataSet.ways.add(new Way(way));
        }
        for (Relation relation : this.relations) {
            dataSet.relations.add(new Relation(relation));
        }
        for (DataSource dataSource : this.dataSources) {
            dataSet.dataSources.add(new DataSource(dataSource.bounds, dataSource.origin));
        }
        return dataSet;
    }

    public Area getDataSourceArea() {
        if (this.dataSources.isEmpty()) {
            return null;
        }
        Area area = new Area();
        for (DataSource dataSource : this.dataSources) {
            area.add(new Area(dataSource.bounds.asRect()));
        }
        return area;
    }

    public static OsmPrimitive[] sort(Collection<? extends OsmPrimitive> collection) {
        OsmPrimitive[] osmPrimitiveArray = new OsmPrimitive[collection.size()];
        final HashMap hashMap = new HashMap();
        osmPrimitiveArray = collection.toArray(osmPrimitiveArray);
        Arrays.sort(osmPrimitiveArray, new Comparator<OsmPrimitive>(){

            @Override
            public int compare(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
                if (osmPrimitive.getClass() == osmPrimitive2.getClass()) {
                    int n;
                    String string;
                    String string2 = (String)hashMap.get(osmPrimitive);
                    if (string2 == null) {
                        string2 = osmPrimitive.getName();
                        hashMap.put(osmPrimitive, string2);
                    }
                    if ((string = (String)hashMap.get(osmPrimitive2)) == null) {
                        string = osmPrimitive2.getName();
                        hashMap.put(osmPrimitive2, string);
                    }
                    if ((n = string2.compareTo(string)) != 0) {
                        return n;
                    }
                }
                return osmPrimitive.compareTo(osmPrimitive2);
            }
        });
        return osmPrimitiveArray;
    }
}

