/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MapMover
extends MouseAdapter
implements MouseMotionListener,
MouseWheelListener {
    private EastNorth mousePosMove;
    private final NavigatableComponent nc;
    private Cursor oldCursor;
    private boolean movementInPlace = false;

    public MapMover(NavigatableComponent navigatableComponent, JPanel jPanel) {
        this.nc = navigatableComponent;
        this.nc.addMouseListener(this);
        this.nc.addMouseMotionListener(this);
        this.nc.addMouseWheelListener(this);
        if (jPanel != null) {
            jPanel.getInputMap(2).put(Shortcut.registerShortcut("system:movefocusright", I18n.tr("Map: {0}", I18n.tr("Move right")), 39, 1).getKeyStroke(), "MapMover.Zoomer.right");
            jPanel.getActionMap().put("MapMover.Zoomer.right", new ZoomerAction("right"));
            jPanel.getInputMap(2).put(Shortcut.registerShortcut("system:movefocusleft", I18n.tr("Map: {0}", I18n.tr("Move left")), 37, 1).getKeyStroke(), "MapMover.Zoomer.left");
            jPanel.getActionMap().put("MapMover.Zoomer.left", new ZoomerAction("left"));
            jPanel.getInputMap(2).put(Shortcut.registerShortcut("system:movefocusup", I18n.tr("Map: {0}", I18n.tr("Move up")), 38, 1).getKeyStroke(), "MapMover.Zoomer.up");
            jPanel.getActionMap().put("MapMover.Zoomer.up", new ZoomerAction("up"));
            jPanel.getInputMap(2).put(Shortcut.registerShortcut("system:movefocusdown", I18n.tr("Map: {0}", I18n.tr("Move down")), 40, 1).getKeyStroke(), "MapMover.Zoomer.down");
            jPanel.getActionMap().put("MapMover.Zoomer.down", new ZoomerAction("down"));
            jPanel.getInputMap(2).put(Shortcut.registerShortcut("view:zoominalternate", I18n.tr("Map: {0}", I18n.tr("Zoom in")), 44, 1).getKeyStroke(), "MapMover.Zoomer.in");
            jPanel.getActionMap().put("MapMover.Zoomer.in", new ZoomerAction(","));
            jPanel.getInputMap(2).put(Shortcut.registerShortcut("view:zoomoutalternate", I18n.tr("Map: {0}", I18n.tr("Zoom out")), 46, 1).getKeyStroke(), "MapMover.Zoomer.out");
            jPanel.getActionMap().put("MapMover.Zoomer.out", new ZoomerAction("."));
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = 3072;
        if ((mouseEvent.getModifiersEx() & (0x1000 | n)) == 4096) {
            if (this.mousePosMove == null) {
                this.startMovement(mouseEvent);
            }
            EastNorth eastNorth = this.nc.getCenter();
            EastNorth eastNorth2 = this.nc.getEastNorth(mouseEvent.getX(), mouseEvent.getY());
            EastNorth eastNorth3 = new EastNorth(this.mousePosMove.east() + eastNorth.east() - eastNorth2.east(), this.mousePosMove.north() + eastNorth.north() - eastNorth2.north());
            this.nc.zoomTo(eastNorth3, this.nc.getScale());
        } else {
            this.endMovement();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = 3072;
        if (mouseEvent.getButton() == 3 && (mouseEvent.getModifiersEx() & n) == 0) {
            this.startMovement(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 3) {
            this.endMovement();
        }
    }

    private void startMovement(MouseEvent mouseEvent) {
        if (this.movementInPlace) {
            return;
        }
        this.movementInPlace = true;
        this.mousePosMove = this.nc.getEastNorth(mouseEvent.getX(), mouseEvent.getY());
        this.oldCursor = this.nc.getCursor();
        this.nc.setCursor(Cursor.getPredefinedCursor(13));
    }

    private void endMovement() {
        if (!this.movementInPlace) {
            return;
        }
        this.movementInPlace = false;
        if (this.oldCursor != null) {
            this.nc.setCursor(this.oldCursor);
        } else {
            this.nc.setCursor(Cursor.getDefaultCursor());
        }
        this.mousePosMove = null;
        this.oldCursor = null;
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = this.nc.getWidth();
        int n2 = this.nc.getHeight();
        double d = Math.max(0.1, 1.0 + (double)mouseWheelEvent.getWheelRotation() / 5.0);
        double d2 = (d - 1.0) / 2.0 + 1.0;
        double d3 = (double)n * d2 - (double)(n / 2);
        double d4 = (double)n2 * d2 - (double)(n2 / 2);
        double d5 = (double)mouseWheelEvent.getX() - (double)(mouseWheelEvent.getX() - n / 2) * d3 * 2.0 / (double)n;
        double d6 = (double)mouseWheelEvent.getY() - (double)(mouseWheelEvent.getY() - n2 / 2) * d4 * 2.0 / (double)n2;
        EastNorth eastNorth = this.nc.getEastNorth((int)d5, (int)d6);
        this.nc.zoomTo(eastNorth, this.nc.getScale() * d);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private final class ZoomerAction
    extends AbstractAction {
        private final String action;

        public ZoomerAction(String string) {
            this.action = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.action.equals(".") || this.action.equals(",")) {
                Point point = MapMover.this.nc.getMousePosition();
                if (point == null) {
                    point = new Point((int)MapMover.this.nc.getBounds().getCenterX(), (int)MapMover.this.nc.getBounds().getCenterY());
                }
                MouseWheelEvent mouseWheelEvent = new MouseWheelEvent((Component)MapMover.this.nc, actionEvent.getID(), actionEvent.getWhen(), actionEvent.getModifiers(), point.x, point.y, 0, false, 0, 1, this.action.equals(",") ? -1 : 1);
                MapMover.this.mouseWheelMoved(mouseWheelEvent);
            } else {
                EastNorth eastNorth = MapMover.this.nc.getCenter();
                EastNorth eastNorth2 = MapMover.this.nc.getEastNorth(MapMover.this.nc.getWidth() / 2 + MapMover.this.nc.getWidth() / 5, MapMover.this.nc.getHeight() / 2 + MapMover.this.nc.getHeight() / 5);
                if (this.action.equals("left")) {
                    MapMover.this.nc.zoomTo(new EastNorth(2.0 * eastNorth.east() - eastNorth2.east(), eastNorth.north()), MapMover.this.nc.getScale());
                } else if (this.action.equals("right")) {
                    MapMover.this.nc.zoomTo(new EastNorth(eastNorth2.east(), eastNorth.north()), MapMover.this.nc.getScale());
                } else if (this.action.equals("up")) {
                    MapMover.this.nc.zoomTo(new EastNorth(eastNorth.east(), 2.0 * eastNorth.north() - eastNorth2.north()), MapMover.this.nc.getScale());
                } else if (this.action.equals("down")) {
                    MapMover.this.nc.zoomTo(new EastNorth(eastNorth.east(), eastNorth2.north()), MapMover.this.nc.getScale());
                }
            }
        }
    }
}

