/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.CreateOsmChangeVisitor;
import org.openstreetmap.josm.data.osm.visitor.NameVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.io.DiffResultReader;
import org.openstreetmap.josm.io.MyHttpHandler;
import org.openstreetmap.josm.io.OsmConnection;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.OsmWriter;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmServerWriter
extends OsmConnection
implements Visitor {
    public Collection<OsmPrimitive> processed;
    private Changeset changeset;
    private static final int MSECS_PER_SECOND = 1000;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int MSECS_PER_MINUTE = 60000;
    long uploadStartTime;

    public String timeLeft(int n, int n2) {
        long l = System.currentTimeMillis();
        long l2 = l - this.uploadStartTime;
        if (l2 == 0L) {
            l2 = 1L;
        }
        float f = (float)n / (float)l2;
        float f2 = n2 - n;
        int n3 = (int)(f2 / f);
        int n4 = n3 / 60000;
        int n5 = n3 / 1000 % 60;
        String string = Integer.toString(n4) + ":";
        if (n5 < 10) {
            string = string + "0";
        }
        string = string + Integer.toString(n5);
        return string;
    }

    public void uploadOsm(Collection<OsmPrimitive> collection) throws SAXException {
        this.processed = new LinkedList<OsmPrimitive>();
        this.initAuthentication();
        Main.pleaseWaitDlg.progress.setMaximum(collection.size());
        Main.pleaseWaitDlg.progress.setValue(0);
        boolean bl = Main.pref.get("osm-server.version", "0.5").equals("0.6");
        boolean bl2 = Main.pref.getBoolean("osm-server.atomic-upload", Main.pref.get("osm-server.version", "0.5").equals("0.6"));
        String string = null;
        while (bl && string == null) {
            string = JOptionPane.showInputDialog(Main.parent, I18n.tr("Provide a brief comment for the changes you are uploading:"), I18n.tr("Commit comment"), 3);
            if (string == null) {
                return;
            }
            if (string.trim().length() >= 3) break;
            string = null;
        }
        try {
            if (bl && !this.startChangeset(10, string)) {
                return;
            }
        }
        catch (OsmTransferException osmTransferException) {
            this.dealWithTransferException(osmTransferException);
            return;
        }
        try {
            if (bl2) {
                this.uploadDiff(10, collection);
            } else {
                NameVisitor nameVisitor = new NameVisitor();
                this.uploadStartTime = System.currentTimeMillis();
                for (OsmPrimitive osmPrimitive : collection) {
                    if (this.cancel) {
                        return;
                    }
                    osmPrimitive.visit(nameVisitor);
                    int n = Main.pleaseWaitDlg.progress.getValue();
                    String string2 = this.timeLeft(n, collection.size());
                    Main.pleaseWaitDlg.currentAction.setText(I18n.tr("{0}% ({1}/{2}), {3} left. Uploading {4}: {5} (id: {6})", Math.round(100.0 * (double)n / (double)collection.size()), n, collection.size(), string2, I18n.tr(nameVisitor.className), nameVisitor.name, osmPrimitive.id));
                    osmPrimitive.visit(this);
                    Main.pleaseWaitDlg.progress.setValue(n + 1);
                }
            }
            if (bl) {
                this.stopChangeset(10);
            }
        }
        catch (RuntimeException runtimeException) {
            try {
                if (bl) {
                    this.stopChangeset(10);
                }
            }
            catch (OsmTransferException osmTransferException) {
                this.dealWithTransferException(osmTransferException);
            }
            runtimeException.printStackTrace();
            throw new SAXException(I18n.tr("An error occurred: {0}", runtimeException.getMessage()));
        }
        catch (OsmTransferException osmTransferException) {
            try {
                if (bl) {
                    this.stopChangeset(10);
                }
            }
            catch (OsmTransferException osmTransferException2) {
                this.dealWithTransferException(osmTransferException2);
            }
            this.dealWithTransferException(osmTransferException);
        }
    }

    private boolean startChangeset(int n, String string) throws OsmTransferException {
        Main.pleaseWaitDlg.currentAction.setText(I18n.tr("Opening changeset..."));
        this.changeset = new Changeset();
        this.changeset.put("created_by", "JOSM");
        this.changeset.put("comment", string);
        try {
            if (this.cancel) {
                return false;
            }
            String string2 = Main.pref.get("osm-server.version", "0.6");
            URL uRL = new URL(Main.pref.get("osm-server.url") + "/" + string2 + "/" + "changeset" + "/" + "create");
            System.out.print("upload to: " + uRL + "...");
            this.activeConnection = (HttpURLConnection)uRL.openConnection();
            this.activeConnection.setConnectTimeout(15000);
            this.activeConnection.setRequestMethod("PUT");
            this.addAuth(this.activeConnection);
            this.activeConnection.setDoOutput(true);
            OutputStream outputStream = this.activeConnection.getOutputStream();
            OsmWriter.output(outputStream, this.changeset);
            outputStream.close();
            this.activeConnection.connect();
            System.out.println("connected");
            int n2 = this.activeConnection.getResponseCode();
            if (n2 == 200) {
                this.changeset.id = this.readId(this.activeConnection.getInputStream());
            }
            System.out.println("got return: " + n2 + " with id " + this.changeset.id);
            String string3 = this.activeConnection.getResponseMessage();
            this.activeConnection.disconnect();
            if (n2 == 404) {
                throw new OsmTransferException(I18n.tr("Server does not support changesets"));
            }
            if (n2 != 200 && n2 != 412) {
                if (n >= 0) {
                    --n;
                    if (this.sleepAndListen()) {
                        return false;
                    }
                    System.out.println("retrying (" + n + " left)");
                    return this.startChangeset(n, string);
                }
                string3 = string3 + "\n" + this.readString(this.activeConnection.getInputStream());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                OsmWriter.output(byteArrayOutputStream, this.changeset);
                System.out.println(new String(byteArrayOutputStream.toByteArray(), "UTF-8").toString());
                throw new OsmTransferException(n2 + " " + string3);
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new OsmTransferException(I18n.tr("Unknown host") + ": " + unknownHostException.getMessage(), unknownHostException);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            System.out.println(" timed out, retries left: " + n);
            if (this.cancel) {
                return false;
            }
            if (n-- > 0) {
                this.startChangeset(n, string);
            }
            throw new OsmTransferException(socketTimeoutException.getMessage() + " " + socketTimeoutException.getClass().getCanonicalName(), socketTimeoutException);
        }
        catch (ConnectException connectException) {
            System.out.println(" timed out, retries left: " + n);
            if (this.cancel) {
                return false;
            }
            if (n-- > 0) {
                this.startChangeset(n, string);
            }
            throw new OsmTransferException(connectException.getMessage() + " " + connectException.getClass().getCanonicalName(), connectException);
        }
        catch (Exception exception) {
            if (this.cancel) {
                return false;
            }
            if (exception instanceof OsmTransferException) {
                throw (OsmTransferException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception.getMessage() + " " + exception.getClass().getCanonicalName(), exception);
        }
        return true;
    }

    private void uploadDiff(int n, Collection<OsmPrimitive> collection) throws OsmTransferException {
        block20: {
            CreateOsmChangeVisitor createOsmChangeVisitor = new CreateOsmChangeVisitor(this.changeset);
            for (OsmPrimitive object : collection) {
                int uRL = Main.pleaseWaitDlg.progress.getValue();
                Main.pleaseWaitDlg.currentAction.setText(I18n.tr("Preparing..."));
                if (this.cancel) {
                    return;
                }
                object.visit(createOsmChangeVisitor);
                Main.pleaseWaitDlg.progress.setValue(uRL + 1);
            }
            System.out.println("the document:\n");
            String string = createOsmChangeVisitor.getDocument();
            System.out.println(string);
            Main.pleaseWaitDlg.currentAction.setText(I18n.tr("Uploading..."));
            try {
                PrintWriter printWriter;
                if (this.cancel) {
                    return;
                }
                String unknownHostException = Main.pref.get("osm-server.version", "0.6");
                URL uRL = new URL(Main.pref.get("osm-server.url") + "/" + unknownHostException + "/" + "changeset" + "/" + this.changeset.id + "/upload");
                System.out.print("upload to: " + uRL + "...");
                this.activeConnection = (HttpURLConnection)uRL.openConnection();
                this.activeConnection.setConnectTimeout(15000);
                this.activeConnection.setRequestMethod("POST");
                this.addAuth(this.activeConnection);
                this.activeConnection.setDoOutput(true);
                try {
                    printWriter = new PrintWriter(new OutputStreamWriter(this.activeConnection.getOutputStream(), "UTF-8"));
                }
                catch (UnsupportedEncodingException n3) {
                    throw new RuntimeException(n3);
                }
                printWriter.print(string);
                printWriter.close();
                this.activeConnection.connect();
                System.out.println("connected");
                int n2 = this.activeConnection.getResponseCode();
                String string2 = "";
                if (n2 == 200) {
                    DiffResultReader.parseDiffResult(this.activeConnection.getInputStream(), collection, this.processed, createOsmChangeVisitor.getNewIdMap(), Main.pleaseWaitDlg);
                    break block20;
                }
                if (n2 == 200 || n2 == 412) break block20;
                if (n >= 0) {
                    --n;
                    if (this.sleepAndListen()) {
                        return;
                    }
                    System.out.println("retrying (" + n + " left)");
                    this.stopChangeset(n);
                    break block20;
                }
                string2 = string2 + "\n" + this.readString(this.activeConnection.getInputStream());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                OsmWriter.output(byteArrayOutputStream, this.changeset);
                System.out.println(new String(byteArrayOutputStream.toByteArray(), "UTF-8").toString());
                throw new OsmTransferException(n2 + " " + string2);
            }
            catch (UnknownHostException socketTimeoutException) {
                throw new OsmTransferException(I18n.tr("Unknown host") + ": " + socketTimeoutException.getMessage(), socketTimeoutException);
            }
            catch (SocketTimeoutException connectException) {
                System.out.println(" timed out, retries left: " + n);
                if (this.cancel) {
                    return;
                }
                if (n-- > 0) {
                    this.stopChangeset(n);
                }
                throw new OsmTransferException(connectException.getMessage() + " " + connectException.getClass().getCanonicalName(), connectException);
            }
            catch (ConnectException exception) {
                System.out.println(" timed out, retries left: " + n);
                if (this.cancel) {
                    return;
                }
                if (n-- > 0) {
                    this.stopChangeset(n);
                }
                throw new OsmTransferException(exception.getMessage() + " " + exception.getClass().getCanonicalName(), exception);
            }
            catch (Exception exception) {
                if (this.cancel) {
                    return;
                }
                if (exception instanceof OsmTransferException) {
                    throw (OsmTransferException)exception;
                }
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new RuntimeException(exception.getMessage() + " " + exception.getClass().getCanonicalName(), exception);
            }
        }
    }

    private void stopChangeset(int n) throws OsmTransferException {
        block16: {
            Main.pleaseWaitDlg.currentAction.setText(I18n.tr("Closing changeset..."));
            try {
                if (this.cancel) {
                    return;
                }
                String string = Main.pref.get("osm-server.version", "0.6");
                URL uRL = new URL(Main.pref.get("osm-server.url") + "/" + string + "/" + "changeset" + "/" + this.changeset.id + "/close");
                System.out.print("upload to: " + uRL + "...");
                this.activeConnection = (HttpURLConnection)uRL.openConnection();
                this.activeConnection.setConnectTimeout(15000);
                this.activeConnection.setRequestMethod("PUT");
                this.addAuth(this.activeConnection);
                this.activeConnection.setDoOutput(true);
                OutputStream outputStream = this.activeConnection.getOutputStream();
                OsmWriter.output(outputStream, this.changeset);
                outputStream.close();
                this.activeConnection.connect();
                System.out.println("connected");
                int n2 = this.activeConnection.getResponseCode();
                System.out.println("got return: " + n2);
                String string2 = this.activeConnection.getResponseMessage();
                this.activeConnection.disconnect();
                if (n2 == 404) {
                    System.out.println("Server does not support changesets, or the changeset could not be found, continuing");
                    return;
                }
                if (n2 == 200 || n2 == 412) break block16;
                if (n >= 0) {
                    --n;
                    if (this.sleepAndListen()) {
                        return;
                    }
                    System.out.println("retrying (" + n + " left)");
                    this.stopChangeset(n);
                    break block16;
                }
                string2 = string2 + this.readString(this.activeConnection.getInputStream());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                OsmWriter.output(byteArrayOutputStream, this.changeset);
                System.out.println(new String(byteArrayOutputStream.toByteArray(), "UTF-8").toString());
                throw new OsmTransferException(n2 + " " + string2);
            }
            catch (UnknownHostException unknownHostException) {
                throw new OsmTransferException(I18n.tr("Unknown host") + ": " + unknownHostException.getMessage(), unknownHostException);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                System.out.println(" timed out, retries left: " + n);
                if (this.cancel) {
                    return;
                }
                if (n-- > 0) {
                    this.stopChangeset(n);
                }
                throw new OsmTransferException(socketTimeoutException.getMessage() + " " + socketTimeoutException.getClass().getCanonicalName(), socketTimeoutException);
            }
            catch (ConnectException connectException) {
                System.out.println(" timed out, retries left: " + n);
                if (this.cancel) {
                    return;
                }
                if (n-- > 0) {
                    this.stopChangeset(n);
                }
                throw new OsmTransferException(connectException.getMessage() + " " + connectException.getClass().getCanonicalName(), connectException);
            }
            catch (Exception exception) {
                if (this.cancel) {
                    return;
                }
                if (exception instanceof OsmTransferException) {
                    throw (OsmTransferException)exception;
                }
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new RuntimeException(exception.getMessage() + " " + exception.getClass().getCanonicalName(), exception);
            }
        }
    }

    private boolean sleepAndListen() {
        for (int i = 0; i < 10; ++i) {
            if (this.cancel || this.isAuthCancelled()) {
                if (!this.cancel) {
                    this.cancel();
                }
                return true;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public void visit(Node node) {
        if (node.deleted) {
            this.sendRequest("DELETE", "node", node, true);
        } else {
            this.sendRequest("PUT", "node", node, true);
        }
        this.processed.add(node);
    }

    @Override
    public void visit(Way way) {
        if (way.deleted) {
            this.sendRequest("DELETE", "way", way, true);
        } else {
            this.sendRequest("PUT", "way", way, true);
        }
        this.processed.add(way);
    }

    @Override
    public void visit(Relation relation) {
        if (relation.deleted) {
            this.sendRequest("DELETE", "relation", relation, true);
        } else {
            this.sendRequest("PUT", "relation", relation, true);
        }
        this.processed.add(relation);
    }

    private long readId(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = bufferedReader.readLine();
        if (string == null) {
            return 0L;
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    private String readString(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private void sendRequestRetry(String string, String string2, OsmPrimitive osmPrimitive, XmlWriter.OsmWriterInterface osmWriterInterface, int n) throws OsmTransferException {
        block23: {
            try {
                if (this.cancel) {
                    return;
                }
                String string3 = Main.pref.get("osm-server.version", "0.5");
                URL uRL = new URL(new URL(Main.pref.get("osm-server.url") + "/" + string3 + "/"), string2 + "/" + (osmPrimitive.id == 0L ? "create" : Long.valueOf(osmPrimitive.id)), new MyHttpHandler());
                System.out.print("upload to: " + uRL + "...");
                this.activeConnection = (HttpURLConnection)uRL.openConnection();
                this.activeConnection.setConnectTimeout(15000);
                this.activeConnection.setRequestMethod(string);
                this.addAuth(this.activeConnection);
                if (osmWriterInterface != null) {
                    this.activeConnection.setDoOutput(true);
                    OutputStream outputStream = this.activeConnection.getOutputStream();
                    OsmWriter.output(outputStream, osmWriterInterface);
                    outputStream.close();
                }
                this.activeConnection.connect();
                System.out.println("connected");
                int n2 = this.activeConnection.getResponseCode();
                if (n2 == 200) {
                    if (osmPrimitive.id == 0L) {
                        osmPrimitive.id = this.readId(this.activeConnection.getInputStream());
                        osmPrimitive.version = 1;
                    } else {
                        int n3 = (int)this.readId(this.activeConnection.getInputStream());
                        if (n3 > 0) {
                            osmPrimitive.version = n3;
                        }
                    }
                } else {
                    System.out.println("got return: " + n2 + " with id " + osmPrimitive.id);
                }
                this.activeConnection.disconnect();
                if (n2 == 410 && string.equals("DELETE")) {
                    return;
                }
                if (n2 == 200) break block23;
                if (n >= 0 && n2 != 412) {
                    --n;
                    if (this.sleepAndListen()) {
                        return;
                    }
                    System.out.println("retrying (" + n + " left)");
                    this.sendRequestRetry(string, string2, osmPrimitive, osmWriterInterface, n);
                    break block23;
                }
                String string4 = this.activeConnection.getResponseMessage();
                if (this.activeConnection.getHeaderField("Error") != null) {
                    string4 = string4 + "\n" + this.activeConnection.getHeaderField("Error");
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                OsmWriter.output(byteArrayOutputStream, osmWriterInterface);
                System.out.println(new String(byteArrayOutputStream.toByteArray(), "UTF-8").toString());
                throw new OsmTransferException(n2 + " " + string4);
            }
            catch (UnknownHostException unknownHostException) {
                throw new OsmTransferException(I18n.tr("Unknown host") + ": " + unknownHostException.getMessage(), unknownHostException);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                System.out.println(" timed out, retries left: " + n);
                if (this.cancel) {
                    return;
                }
                if (n-- > 0) {
                    this.sendRequestRetry(string, string2, osmPrimitive, osmWriterInterface, n);
                }
                throw new OsmTransferException(socketTimeoutException.getMessage() + " " + socketTimeoutException.getClass().getCanonicalName(), socketTimeoutException);
            }
            catch (ConnectException connectException) {
                System.out.println(" timed out, retries left: " + n);
                if (this.cancel) {
                    return;
                }
                if (n-- > 0) {
                    this.sendRequestRetry(string, string2, osmPrimitive, osmWriterInterface, n);
                }
                throw new OsmTransferException(connectException.getMessage() + " " + connectException.getClass().getCanonicalName(), connectException);
            }
            catch (Exception exception) {
                if (this.cancel) {
                    return;
                }
                if (exception instanceof OsmTransferException) {
                    throw (OsmTransferException)exception;
                }
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new RuntimeException(exception.getMessage() + " " + exception.getClass().getCanonicalName(), exception);
            }
        }
    }

    private void sendRequest(String string, String string2, OsmPrimitive osmPrimitive, boolean bl) {
        OsmWriter.Single single = null;
        if (bl) {
            single = new OsmWriter.Single(osmPrimitive, true, this.changeset);
        }
        try {
            this.sendRequestRetry(string, string2, osmPrimitive, single, 10);
        }
        catch (OsmTransferException osmTransferException) {
            this.dealWithTransferException(osmTransferException);
        }
    }

    private void dealWithTransferException(OsmTransferException osmTransferException) {
        Main.pleaseWaitDlg.currentAction.setText(I18n.tr("Transfer aborted due to error (will wait for 5 seconds):") + osmTransferException.getMessage());
        this.cancel = true;
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

