/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.gui.mappaint.AreaElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.IconElemStyle;
import org.openstreetmap.josm.gui.mappaint.LineElemStyle;

public class ElemStyles {
    HashMap<String, StyleSet> styleSet = new HashMap();

    private String getKey(String string, String string2, String string3) {
        if (string2 != null) {
            return "n" + string + "=" + string2;
        }
        if (string3 != null) {
            return "b" + string + "=" + OsmUtils.getNamedOsmBoolean(string3);
        }
        return "x" + string;
    }

    public void add(String string, String string2, String string3, String string4, LineElemStyle lineElemStyle) {
        String string5;
        lineElemStyle.code = string5 = this.getKey(string2, string3, string4);
        this.getStyleSet(string, true).lines.put(string5, lineElemStyle);
    }

    public void addModifier(String string, String string2, String string3, String string4, LineElemStyle lineElemStyle) {
        String string5;
        lineElemStyle.code = string5 = this.getKey(string2, string3, string4);
        this.getStyleSet(string, true).modifiers.put(string5, lineElemStyle);
    }

    public void add(String string, String string2, String string3, String string4, AreaElemStyle areaElemStyle) {
        String string5;
        areaElemStyle.code = string5 = this.getKey(string2, string3, string4);
        this.getStyleSet(string, true).areas.put(string5, areaElemStyle);
    }

    public void add(String string, String string2, String string3, String string4, IconElemStyle iconElemStyle) {
        String string5;
        iconElemStyle.code = string5 = this.getKey(string2, string3, string4);
        this.getStyleSet(string, true).icons.put(string5, iconElemStyle);
    }

    private StyleSet getStyleSet(String string, boolean bl) {
        if (string == null) {
            string = Main.pref.get("mappaint.style", "standard");
        }
        StyleSet styleSet = this.styleSet.get(string);
        if (bl && styleSet == null) {
            styleSet = new StyleSet();
            this.styleSet.put(string, styleSet);
        }
        return styleSet;
    }

    public StyleSet getStyleSet() {
        return this.getStyleSet(null, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class StyleSet {
        private HashMap<String, IconElemStyle> icons = new HashMap();
        private HashMap<String, LineElemStyle> lines = new HashMap();
        private HashMap<String, AreaElemStyle> areas;
        private HashMap<String, LineElemStyle> modifiers = new HashMap();

        public StyleSet() {
            this.areas = new HashMap();
        }

        private IconElemStyle getNode(Map<String, String> map) {
            IconElemStyle iconElemStyle = null;
            for (String string : map.keySet()) {
                String string2 = map.get(string);
                IconElemStyle iconElemStyle2 = this.icons.get("n" + string + "=" + string2);
                if (iconElemStyle2 != null && (iconElemStyle == null || iconElemStyle2.priority > iconElemStyle.priority)) {
                    iconElemStyle = iconElemStyle2;
                }
                if ((iconElemStyle2 = this.icons.get("b" + string + "=" + OsmUtils.getNamedOsmBoolean(string2))) != null && (iconElemStyle == null || iconElemStyle2.priority > iconElemStyle.priority)) {
                    iconElemStyle = iconElemStyle2;
                }
                if ((iconElemStyle2 = this.icons.get("x" + string)) == null || iconElemStyle != null && iconElemStyle2.priority <= iconElemStyle.priority) continue;
                iconElemStyle = iconElemStyle2;
            }
            return iconElemStyle;
        }

        private ElemStyle get(Map<String, String> map) {
            AreaElemStyle areaElemStyle = null;
            LineElemStyle lineElemStyle = null;
            String string = null;
            HashMap<String, LineElemStyle> hashMap = new HashMap<String, LineElemStyle>();
            for (String object : map.keySet()) {
                LineElemStyle lineElemStyle2;
                String string2 = map.get(object);
                String string3 = "n" + object + "=" + string2;
                AreaElemStyle areaElemStyle2 = this.areas.get(string3);
                if (areaElemStyle2 != null && (areaElemStyle == null || areaElemStyle2.priority > areaElemStyle.priority)) {
                    areaElemStyle = areaElemStyle2;
                }
                if ((lineElemStyle2 = this.lines.get(string3)) != null && (lineElemStyle == null || lineElemStyle2.priority > lineElemStyle.priority)) {
                    lineElemStyle = lineElemStyle2;
                    string = string3;
                }
                if ((lineElemStyle2 = this.modifiers.get(string3)) != null) {
                    hashMap.put(string3, lineElemStyle2);
                }
                if ((areaElemStyle2 = this.areas.get(string3 = "b" + object + "=" + OsmUtils.getNamedOsmBoolean(string2))) != null && (areaElemStyle == null || areaElemStyle2.priority > areaElemStyle.priority)) {
                    areaElemStyle = areaElemStyle2;
                }
                if ((lineElemStyle2 = this.lines.get(string3)) != null && (lineElemStyle == null || lineElemStyle2.priority > lineElemStyle.priority)) {
                    lineElemStyle = lineElemStyle2;
                    string = string3;
                }
                if ((lineElemStyle2 = this.modifiers.get(string3)) != null) {
                    hashMap.put(string3, lineElemStyle2);
                }
                if ((areaElemStyle2 = this.areas.get(string3 = "x" + object)) != null && (areaElemStyle == null || areaElemStyle2.priority > areaElemStyle.priority)) {
                    areaElemStyle = areaElemStyle2;
                }
                if ((lineElemStyle2 = this.lines.get(string3)) != null && (lineElemStyle == null || lineElemStyle2.priority > lineElemStyle.priority)) {
                    lineElemStyle = lineElemStyle2;
                    string = string3;
                }
                if ((lineElemStyle2 = this.modifiers.get(string3)) == null) continue;
                hashMap.put(string3, lineElemStyle2);
            }
            hashMap.remove(string);
            if (hashMap.size() != 0 && lineElemStyle != null) {
                LinkedList<LineElemStyle> linkedList = new LinkedList<LineElemStyle>(hashMap.values());
                Collections.sort(linkedList);
                lineElemStyle = new LineElemStyle(lineElemStyle, linkedList);
            }
            if (areaElemStyle != null) {
                if (lineElemStyle != null) {
                    return new AreaElemStyle(areaElemStyle, lineElemStyle);
                }
                return areaElemStyle;
            }
            return lineElemStyle;
        }

        public ElemStyle get(OsmPrimitive osmPrimitive) {
            return osmPrimitive.keys == null ? null : (osmPrimitive instanceof Node ? this.getNode(osmPrimitive.keys) : this.get(osmPrimitive.keys));
        }

        public IconElemStyle getIcon(OsmPrimitive osmPrimitive) {
            return osmPrimitive.keys == null ? null : this.getNode(osmPrimitive.keys);
        }

        public boolean isArea(OsmPrimitive osmPrimitive) {
            if (osmPrimitive.keys != null && !(osmPrimitive instanceof Node)) {
                for (String string : osmPrimitive.keys.keySet()) {
                    String string2 = osmPrimitive.keys.get(string);
                    if (!this.areas.containsKey("n" + string + "=" + string2) && !this.areas.containsKey("b" + string + "=" + OsmUtils.getNamedOsmBoolean(string2)) && !this.areas.containsKey("x" + string)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean hasAreas() {
            return this.areas.size() > 0;
        }
    }
}

