/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public final class DateUtils {
    private static GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
    private static final DatatypeFactory XML_DATE;

    private DateUtils() {
    }

    public static synchronized Date fromString(String string) {
        if (DateUtils.checkLayout(string, "xxxx-xx-xxTxx:xx:xxZ") || DateUtils.checkLayout(string, "xxxx-xx-xxTxx:xx:xx+xx:00") || DateUtils.checkLayout(string, "xxxx-xx-xxTxx:xx:xx-xx:00")) {
            calendar.set(DateUtils.parsePart(string, 0, 4), DateUtils.parsePart(string, 5, 2) - 1, DateUtils.parsePart(string, 8, 2), DateUtils.parsePart(string, 11, 2), DateUtils.parsePart(string, 14, 2), DateUtils.parsePart(string, 17, 2));
            if (string.length() == 25) {
                int n = DateUtils.parsePart(string, 20, 2);
                int n2 = string.charAt(19) == '+' ? -3600000 : 3600000;
                calendar.setTimeInMillis(calendar.getTimeInMillis() + (long)(n * n2));
            }
            return calendar.getTime();
        }
        try {
            return XML_DATE.newXMLGregorianCalendar(string).toGregorianCalendar().getTime();
        }
        catch (Exception exception) {
            return new Date();
        }
    }

    public static synchronized String fromDate(Date date) {
        calendar.setTime(date);
        XMLGregorianCalendar xMLGregorianCalendar = XML_DATE.newXMLGregorianCalendar(calendar);
        if (calendar.get(14) == 0) {
            xMLGregorianCalendar.setFractionalSecond(null);
        }
        return xMLGregorianCalendar.toXMLFormat();
    }

    private static boolean checkLayout(String string, String string2) {
        if (string.length() != string2.length()) {
            return false;
        }
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == 'x' || string2.charAt(i) == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static int parsePart(String string, int n, int n2) {
        return Integer.valueOf(string.substring(n, n + n2));
    }

    static {
        calendar.setTimeInMillis(0L);
        DatatypeFactory datatypeFactory = null;
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            datatypeConfigurationException.printStackTrace();
        }
        XML_DATE = datatypeFactory;
    }
}

