/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class AlignInLineAction
extends JosmAction {
    public AlignInLineAction() {
        super(I18n.tr("Align Nodes in Line"), "alignline", I18n.tr("Move the selected nodes in to a line."), Shortcut.registerShortcut("tools:alignline", I18n.tr("Tool: {0}", I18n.tr("Align Nodes in Line")), 76, 3), true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        double d;
        Collection<OsmPrimitive> collection = Main.ds.getSelected();
        LinkedList<Node> linkedList = new LinkedList<Node>();
        LinkedList<Node> linkedList2 = new LinkedList<Node>();
        for (OsmPrimitive osmPrimitive : collection) {
            if (!(osmPrimitive instanceof Node)) continue;
            linkedList.add((Node)osmPrimitive);
            linkedList2.add((Node)osmPrimitive);
        }
        if (linkedList.size() == 0 && collection.size() == 1) {
            for (OsmPrimitive osmPrimitive : collection) {
                if (!(osmPrimitive instanceof Way)) continue;
                linkedList.addAll(((Way)osmPrimitive).nodes);
                linkedList2.addAll(((Way)osmPrimitive).nodes);
            }
        }
        if (linkedList.size() < 3) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least three nodes."));
            return;
        }
        double d2 = 0.0;
        Node node = null;
        Node node2 = null;
        for (Node node3 : linkedList) {
            linkedList2.remove(node3);
            for (Node node4 : linkedList2) {
                d = Math.sqrt(node3.eastNorth.distance(node4.eastNorth));
                if (!(d > d2)) continue;
                node = node3;
                node2 = node4;
                d2 = d;
            }
        }
        linkedList.remove(node);
        linkedList.remove(node2);
        double d3 = node.eastNorth.east();
        double d4 = node.eastNorth.north();
        d = node2.eastNorth.east();
        double d5 = node2.eastNorth.north();
        LinkedList<Command> linkedList3 = new LinkedList<Command>();
        for (Node node5 : linkedList) {
            double d6 = node5.eastNorth.east();
            double d7 = node5.eastNorth.north();
            if (d3 == d) {
                d6 = d3;
            } else if (d4 == d5) {
                d7 = d4;
            } else {
                double d8 = (d5 - d4) / (d - d3);
                double d9 = d4 - d3 * d8;
                double d10 = -1.0 / d8;
                double d11 = node5.eastNorth.north() - node5.eastNorth.east() * d10;
                d6 = (d11 - d9) / (d8 - d10);
                d7 = d8 * d6 + d9;
            }
            linkedList3.add(new MoveCommand(node5, d6 - node5.eastNorth.east(), d7 - node5.eastNorth.north()));
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Align Nodes in Line"), linkedList3));
        Main.map.repaint();
    }
}

