/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.search;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.io.OsmIdReader;
import org.openstreetmap.josm.io.ProgressInputStream;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class SelectionWebsiteLoader
extends PleaseWaitRunnable {
    public final URL url;
    public Collection<OsmPrimitive> sel;
    private final SearchAction.SearchMode mode;
    private OsmIdReader idReader = new OsmIdReader();

    public SelectionWebsiteLoader(String string, SearchAction.SearchMode searchMode) {
        super(I18n.tr("Load Selection"));
        this.mode = searchMode;
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.url = uRL;
    }

    protected void realRun() {
        Main.pleaseWaitDlg.currentAction.setText(I18n.tr("Contact {0}...", this.url.getHost()));
        this.sel = this.mode != SearchAction.SearchMode.remove ? new LinkedList() : Main.ds.allNonDeletedPrimitives();
        try {
            URLConnection uRLConnection = this.url.openConnection();
            ProgressInputStream progressInputStream = new ProgressInputStream(uRLConnection, Main.pleaseWaitDlg);
            Main.pleaseWaitDlg.currentAction.setText(I18n.tr("Downloading..."));
            Map<Long, String> map = this.idReader.parseIds(progressInputStream);
            for (OsmPrimitive osmPrimitive : Main.ds.allNonDeletedPrimitives()) {
                if (!map.containsKey(osmPrimitive.id) || !osmPrimitive.getClass().getName().toLowerCase().endsWith(map.get(osmPrimitive.id))) continue;
                if (this.mode == SearchAction.SearchMode.remove) {
                    this.sel.remove(osmPrimitive);
                    continue;
                }
                this.sel.add(osmPrimitive);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not read from URL: \"{0}\"", this.url));
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Parsing error in URL: \"{0}\"", this.url));
        }
    }

    protected void cancel() {
        this.sel = null;
        this.idReader.cancel();
    }

    protected void finish() {
        if (this.sel != null) {
            Main.ds.setSelected(this.sel);
        }
    }
}

