/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.AdvancedPreference;
import org.openstreetmap.josm.gui.preferences.AudioPreference;
import org.openstreetmap.josm.gui.preferences.ColorPreference;
import org.openstreetmap.josm.gui.preferences.DrawingPreference;
import org.openstreetmap.josm.gui.preferences.FilePreferences;
import org.openstreetmap.josm.gui.preferences.LafPreference;
import org.openstreetmap.josm.gui.preferences.LanguagePreference;
import org.openstreetmap.josm.gui.preferences.MapPaintPreference;
import org.openstreetmap.josm.gui.preferences.PluginPreference;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.ProjectionPreference;
import org.openstreetmap.josm.gui.preferences.ProxyPreferences;
import org.openstreetmap.josm.gui.preferences.ServerAccessPreference;
import org.openstreetmap.josm.gui.preferences.ShortcutPreference;
import org.openstreetmap.josm.gui.preferences.TaggingPresetPreference;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class PreferenceDialog
extends JTabbedPane {
    public static final Collection<PreferenceSetting> settings = new LinkedList<PreferenceSetting>();
    public final JPanel display = this.createPreferenceTab("display", I18n.tr("Display Settings"), I18n.tr("Various settings that influence the visual representation of the whole program."));
    public final JPanel connection = this.createPreferenceTab("connection", I18n.tr("Connection Settings"), I18n.tr("Connection Settings for the OSM server."));
    public final JPanel map = this.createPreferenceTab("map", I18n.tr("Map Settings"), I18n.tr("Settings for the map projection and data interpretation."));
    public final JPanel audio = this.createPreferenceTab("audio", I18n.tr("Audio Settings"), I18n.tr("Settings for the audio player and audio markers."));
    public final JTabbedPane displaycontent = new JTabbedPane();

    public JPanel createPreferenceTab(String string, String string2, String string3) {
        return this.createPreferenceTab(string, string2, string3, false);
    }

    public JPanel createPreferenceTab(String string, String string2, String string3, boolean bl) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)new JLabel(string2), GBC.eol().anchor(10).insets(0, 5, 0, 10));
        JLabel jLabel = new JLabel("<html>" + string3 + "</html>");
        jLabel.setFont(jLabel.getFont().deriveFont(2));
        jPanel.add((Component)jLabel, GBC.eol().insets(5, 0, 5, 20).fill(2));
        JComponent jComponent = jPanel;
        if (bl) {
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jComponent = jScrollPane;
        }
        this.addTab(null, ImageProvider.get("preferences", string), jComponent);
        this.setToolTipTextAt(this.getTabCount() - 1, "<html>" + string3 + "</html>");
        return jPanel;
    }

    public void ok() {
        boolean bl = false;
        for (PreferenceSetting preferenceSetting : settings) {
            if (!preferenceSetting.ok()) continue;
            bl = true;
        }
        if (bl) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("You have to restart JOSM for some settings to take effect."));
        }
        Main.parent.repaint();
    }

    public PreferenceDialog() {
        super(2, 1);
        this.display.add((Component)this.displaycontent, GBC.eol().fill(1));
        Iterator<PreferenceSetting> iterator = settings.iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next().addGui(this);
            }
            catch (SecurityException securityException) {
                iterator.remove();
            }
            catch (Throwable throwable) {
                BugReportExceptionHandler.handleException(throwable);
            }
        }
    }

    static {
        settings.add(new DrawingPreference());
        settings.add(new ColorPreference());
        settings.add(new LafPreference());
        settings.add(new LanguagePreference());
        settings.add(new MapPaintPreference());
        settings.add(new ServerAccessPreference());
        settings.add(new FilePreferences());
        settings.add(new ProxyPreferences());
        settings.add(new ProjectionPreference());
        settings.add(new TaggingPresetPreference());
        settings.add(new PluginPreference());
        settings.add(Main.toolbar);
        settings.add(new AudioPreference());
        settings.add(new ShortcutPreference());
        PluginHandler.getPreferenceSetting(settings);
        settings.add(new AdvancedPreference());
    }
}

