/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.i18n;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.xnap.commons.i18n.I18n;

class I18nCache {
    private final Map i18nByPackage = Collections.synchronizedMap(new HashMap());

    I18nCache() {
    }

    public void clear() {
        this.i18nByPackage.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I18n get(String packageName, Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException();
        }
        List list = (List)this.i18nByPackage.get(packageName);
        if (list != null) {
            List list2 = list;
            synchronized (list2) {
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    I18n i18n = (I18n)it.next();
                    if (!locale.equals(i18n.getLocale())) continue;
                    return i18n;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String packageName, I18n i18n) {
        List<I18n> list;
        Map map = this.i18nByPackage;
        synchronized (map) {
            list = (List<I18n>)this.i18nByPackage.get(packageName);
            if (list == null) {
                list = Collections.synchronizedList(new ArrayList(2));
                this.i18nByPackage.put(packageName, list);
            }
        }
        list.add(i18n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(Visitor visitor) {
        List[] lists;
        Map map = this.i18nByPackage;
        synchronized (map) {
            lists = this.i18nByPackage.values().toArray(new List[0]);
        }
        for (int i = 0; i < lists.length; ++i) {
            List list;
            List list2 = list = lists[i];
            synchronized (list2) {
                Iterator it2 = list.iterator();
                while (it2.hasNext()) {
                    I18n i18n = (I18n)it2.next();
                    visitor.visit(i18n);
                }
                continue;
            }
        }
    }

    public static interface Visitor {
        public void visit(I18n var1);
    }
}

