/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class AlignInCircleAction
extends JosmAction {
    public AlignInCircleAction() {
        super(I18n.tr("Align Nodes in Circle"), "aligncircle", I18n.tr("Move the selected nodes into a circle."), Shortcut.registerShortcut("tools:aligncircle", I18n.tr("Tool: {0}", I18n.tr("Align Nodes in Circle")), 79, 3), true);
    }

    public double determinant(double[][] dArray) {
        double d = 0.0;
        if (dArray.length == 1) {
            d = dArray[0][0];
            return d;
        }
        if (dArray.length == 2) {
            d = dArray[0][0] * dArray[1][1] - dArray[0][1] * dArray[1][0];
            return d;
        }
        for (int i = 0; i < dArray[0].length; ++i) {
            double[][] dArray2 = new double[dArray.length - 1][dArray[0].length - 1];
            for (int j = 1; j < dArray.length; ++j) {
                for (int k = 0; k < dArray[0].length; ++k) {
                    if (k < i) {
                        dArray2[j - 1][k] = dArray[j][k];
                        continue;
                    }
                    if (k <= i) continue;
                    dArray2[j - 1][k - 1] = dArray[j][k];
                }
            }
            d += dArray[0][i] * Math.pow(-1.0, i) * this.determinant(dArray2);
        }
        return d;
    }

    public double distance(EastNorth eastNorth, EastNorth eastNorth2) {
        double d = eastNorth.east() - eastNorth2.east();
        double d2 = eastNorth.north() - eastNorth2.north();
        return Math.sqrt(d * d + d2 * d2);
    }

    public EastNorth circumcenter(EastNorth eastNorth, EastNorth eastNorth2, EastNorth eastNorth3) {
        double d = eastNorth.east() - eastNorth.east();
        double d2 = eastNorth.north() - eastNorth.north();
        double d3 = eastNorth2.east() - eastNorth.east();
        double d4 = eastNorth2.north() - eastNorth.north();
        double d5 = eastNorth3.east() - eastNorth.east();
        double d6 = eastNorth3.north() - eastNorth.north();
        double[][] dArrayArray = new double[][]{{d, d2, 1.0}, {d3, d4, 1.0}, {d5, d6, 1.0}};
        double[][] dArrayArray2 = new double[][]{{d * d + d2 * d2, d2, 1.0}, {d3 * d3 + d4 * d4, d4, 1.0}, {d5 * d5 + d6 * d6, d6, 1.0}};
        double[][] dArrayArray3 = new double[][]{{d * d + d2 * d2, d, 1.0}, {d3 * d3 + d4 * d4, d3, 1.0}, {d5 * d5 + d6 * d6, d5, 1.0}};
        double d7 = this.determinant(dArrayArray);
        double d8 = this.determinant(dArrayArray2);
        double d9 = this.determinant(dArrayArray3);
        EastNorth eastNorth4 = new EastNorth(d8 / (2.0 * d7) + eastNorth.east(), -d9 / (2.0 * d7) + eastNorth.north());
        Node node = new Node(Main.proj.eastNorth2latlon(eastNorth4));
        if (node.coor.isOutSideWorld()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Some of the nodes are (almost) in the line"));
            return null;
        }
        return eastNorth4;
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Collection<OsmPrimitive> collection = Main.ds.getSelected();
        LinkedList<Node> linkedList = new LinkedList<Node>();
        LinkedList<Way> linkedList2 = new LinkedList<Way>();
        Node node = null;
        double d = 0.0;
        boolean bl = false;
        for (OsmPrimitive object22 : collection) {
            if (object22 instanceof Node) {
                linkedList.add((Node)object22);
                continue;
            }
            if (!(object22 instanceof Way)) continue;
            linkedList2.add((Way)object22);
        }
        if (linkedList.size() <= 2 && linkedList2.size() == 1) {
            object = (Way)linkedList2.toArray()[0];
            if (linkedList.size() > 0) {
                if (linkedList.size() == 1 && ((Way)object).nodes.contains(linkedList.toArray()[0])) {
                    bl = true;
                } else {
                    node = (Node)linkedList.toArray()[((Way)object).nodes.contains(linkedList.toArray()[0]) ? 1 : 0];
                    if (linkedList.size() == 2) {
                        d = this.distance(((Node)linkedList.toArray()[0]).eastNorth, ((Node)linkedList.toArray()[1]).eastNorth);
                    }
                }
                linkedList = new LinkedList();
            }
            for (Node node2 : ((Way)object).nodes) {
                if (linkedList.contains(node2)) continue;
                linkedList.add(node2);
            }
        }
        if (linkedList.size() < 4) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least four nodes."));
            return;
        }
        if (node == null) {
            node = new Node(new LatLon(0.0, 0.0));
            node.eastNorth = new EastNorth(0.0, 0.0);
            object = (Node)linkedList.toArray()[linkedList.size() - 1];
            Node node3 = (Node)linkedList.toArray()[linkedList.size() - 2];
            for (Node node4 : linkedList) {
                void var10_13;
                void var11_23 = var10_13;
                Object object2 = object;
                object = node4;
                Object object3 = this.circumcenter(((Node)object).eastNorth, ((Node)object2).eastNorth, var11_23.eastNorth);
                if (object3 == null) {
                    return;
                }
                node.eastNorth = new EastNorth(node.eastNorth.east() + ((EastNorth)object3).east(), node.eastNorth.north() + ((EastNorth)object3).north());
            }
            node.eastNorth = new EastNorth(node.eastNorth.east() / (double)linkedList.size(), node.eastNorth.north() / (double)linkedList.size());
            node.coor = Main.proj.eastNorth2latlon(node.eastNorth);
        }
        if (d == 0.0) {
            for (Node node5 : linkedList) {
                d += this.distance(node.eastNorth, node5.eastNorth);
            }
            d /= (double)linkedList.size();
        }
        object = new LinkedList();
        if (bl) {
            double d2 = Math.PI * 2 / (double)linkedList.size();
            PolarCoor polarCoor = new PolarCoor(((Node)linkedList.toArray()[0]).eastNorth, node.eastNorth, 0.0);
            PolarCoor polarCoor2 = new PolarCoor(((Node)linkedList.toArray()[1]).eastNorth, node.eastNorth, 0.0);
            if (polarCoor.angle > polarCoor2.angle) {
                d2 *= -1.0;
            }
            polarCoor.radius = d;
            for (Object object3 : linkedList) {
                EastNorth eastNorth = polarCoor.toEastNorth();
                object.add(new MoveCommand((OsmPrimitive)object3, eastNorth.east() - ((Node)object3).eastNorth.east(), eastNorth.north() - ((Node)object3).eastNorth.north()));
                polarCoor.angle += d2;
            }
        } else {
            for (Object object4 : linkedList) {
                PolarCoor polarCoor = new PolarCoor(((Node)object4).eastNorth, node.eastNorth, 0.0);
                polarCoor.radius = d;
                EastNorth eastNorth = polarCoor.toEastNorth();
                object.add(new MoveCommand((OsmPrimitive)object4, eastNorth.east() - ((Node)object4).eastNorth.east(), eastNorth.north() - ((Node)object4).eastNorth.north()));
            }
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Align Nodes in Circle"), (Collection<Command>)object));
        Main.map.repaint();
    }

    public class PolarCoor {
        double radius;
        double angle;
        EastNorth origin = new EastNorth(0.0, 0.0);
        double azimuth = 0.0;

        PolarCoor(double d, double d2) {
            this(d, d2, new EastNorth(0.0, 0.0), 0.0);
        }

        PolarCoor(double d, double d2, EastNorth eastNorth, double d3) {
            this.radius = d;
            this.angle = d2;
            this.origin = eastNorth;
            this.azimuth = d3;
        }

        PolarCoor(EastNorth eastNorth) {
            this(eastNorth, new EastNorth(0.0, 0.0), 0.0);
        }

        PolarCoor(EastNorth eastNorth, EastNorth eastNorth2, double d) {
            this.radius = AlignInCircleAction.this.distance(eastNorth, eastNorth2);
            this.angle = Math.atan2(eastNorth.north() - eastNorth2.north(), eastNorth.east() - eastNorth2.east());
            this.origin = eastNorth2;
            this.azimuth = d;
        }

        public EastNorth toEastNorth() {
            return new EastNorth(this.radius * Math.cos(this.angle - this.azimuth) + this.origin.east(), this.radius * Math.sin(this.angle - this.azimuth) + this.origin.north());
        }
    }
}

