/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.TigerUtils;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombineWayAction
extends JosmAction
implements SelectionChangedListener {
    public CombineWayAction() {
        super(I18n.tr("Combine Way"), "combineway", I18n.tr("Combine several ways into one."), Shortcut.registerShortcut("tools:combineway", I18n.tr("Tool: {0}", I18n.tr("Combine Way")), 67, 3), true);
        DataSet.selListeners.add(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        void var7_15;
        void var9_26;
        Object object;
        Collection<OsmPrimitive> collection = Main.ds.getSelected();
        LinkedList<Way> linkedList = new LinkedList<Way>();
        for (OsmPrimitive object72 : collection) {
            if (!(object72 instanceof Way)) continue;
            linkedList.add((Way)object72);
        }
        if (linkedList.size() < 2) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least two ways to combine."));
            return;
        }
        HashMap hashMap = new HashMap();
        HashSet<Relation> hashSet = new HashSet<Relation>();
        for (Relation relation : Main.ds.relations) {
            if (relation.deleted || relation.incomplete) continue;
            for (RelationMember relationMember : relation.members) {
                if (!(relationMember.member instanceof Way)) continue;
                for (Way way : linkedList) {
                    if (relationMember.member != way) continue;
                    object = new Pair<Relation, String>(relation, relationMember.role);
                    Object object2 = new HashSet();
                    if (hashMap.containsKey(object)) {
                        object2 = (HashSet)hashMap.get(object);
                    } else {
                        object2 = new HashSet();
                        hashMap.put(object, object2);
                    }
                    ((HashSet)object2).add(way);
                    hashSet.add(relation);
                }
            }
        }
        for (HashSet hashSet2 : hashMap.values()) {
            if (hashSet2.containsAll(linkedList)) continue;
            int n = new ExtendedDialog(Main.parent, I18n.tr("Combine ways with different memberships?"), I18n.tr("The selected ways have differing relation memberships.  Do you still want to combine them?"), new String[]{I18n.tr("Combine Anyway"), I18n.tr("Cancel")}, new String[]{"combineway.png", "cancel.png"}).getValue();
            if (n == 1) break;
            return;
        }
        TreeMap treeMap = new TreeMap();
        for (Way way : linkedList) {
            for (Map.Entry<String, String> entry : way.entrySet()) {
                if (!treeMap.containsKey(entry.getKey())) {
                    treeMap.put(entry.getKey(), new TreeSet());
                }
                ((Set)treeMap.get(entry.getKey())).add(entry.getValue());
            }
        }
        Object var7_12 = null;
        Object object3 = this.actuallyCombineWays(linkedList, false);
        if (object3 instanceof List) {
            List list = (List)object3;
        } else {
            Object object4 = this.actuallyCombineWays(linkedList, true);
            if (object4 instanceof List) {
                int n = new ExtendedDialog(Main.parent, I18n.tr("Change directions?"), I18n.tr("The ways can not be combined in their current directions.  Do you want to reverse some of them?"), new String[]{I18n.tr("Reverse and Combine"), I18n.tr("Cancel")}, new String[]{"wayflip.png", "cancel.png"}).getValue();
                if (n != 1) {
                    return;
                }
                List list = (List)object4;
            } else {
                JOptionPane.showMessageDialog(Main.parent, object4);
                return;
            }
        }
        Way way = linkedList.peek();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            Way way2;
            Way way3 = way2 = (Way)iterator.next();
            if (way2.id == 0L) continue;
            break;
        }
        Way way4 = new Way((Way)var9_26);
        way4.nodes.clear();
        way4.nodes.addAll((Collection<Node>)var7_15);
        HashMap hashMap2 = new HashMap();
        object = new JPanel(new GridBagLayout());
        for (Map.Entry entry : treeMap.entrySet()) {
            if (TigerUtils.isTigerTag((String)entry.getKey())) {
                String string = TigerUtils.combineTags((String)entry.getKey(), (Set)entry.getValue());
                way4.put((String)entry.getKey(), string);
                continue;
            }
            if (((Set)entry.getValue()).size() > 1) {
                JComboBox<Object> jComboBox = new JComboBox<Object>(((Set)entry.getValue()).toArray());
                jComboBox.setEditable(true);
                ((Container)object).add((Component)new JLabel((String)entry.getKey()), GBC.std());
                ((Container)object).add(Box.createHorizontalStrut(10), GBC.std());
                ((Container)object).add(jComboBox, GBC.eol());
                hashMap2.put(entry.getKey(), jComboBox);
                continue;
            }
            way4.put((String)entry.getKey(), (String)((Set)entry.getValue()).iterator().next());
        }
        if (!hashMap2.isEmpty()) {
            int n = new ExtendedDialog(Main.parent, I18n.tr("Enter values for all conflicts."), (Component)object, new String[]{I18n.tr("Solve Conflicts"), I18n.tr("Cancel")}, new String[]{"dialogs/conflict.png", "cancel.png"}).getValue();
            if (n != 1) {
                return;
            }
            for (Map.Entry entry : hashMap2.entrySet()) {
                way4.put((String)entry.getKey(), ((JComboBox)entry.getValue()).getEditor().getItem().toString());
            }
        }
        LinkedList<Command> linkedList2 = new LinkedList<Command>();
        LinkedList<Way> linkedList3 = new LinkedList<Way>(linkedList);
        linkedList3.remove(var9_26);
        linkedList2.add(new DeleteCommand(linkedList3));
        linkedList2.add(new ChangeCommand((OsmPrimitive)var9_26, way4));
        for (Relation relation : hashSet) {
            Relation relation2 = new Relation(relation);
            relation2.members.clear();
            HashSet<String> hashSet3 = new HashSet<String>();
            for (RelationMember relationMember : relation.members) {
                if (linkedList.contains(relationMember.member)) {
                    hashSet3.add(relationMember.role);
                    continue;
                }
                relation2.members.add(relationMember);
            }
            for (String string : hashSet3) {
                relation2.members.add(new RelationMember(string, (OsmPrimitive)var9_26));
            }
            linkedList2.add(new ChangeCommand(relation, relation2));
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Combine {0} ways", linkedList.size()), linkedList2));
        Main.ds.setSelected(new OsmPrimitive[]{var9_26});
    }

    private Object actuallyCombineWays(List<Way> list, boolean bl) {
        HashSet<Pair<Node, Node>> hashSet = new HashSet<Pair<Node, Node>>();
        for (Way object2 : list) {
            hashSet.addAll(object2.getNodePairs(bl));
        }
        LinkedList linkedList = new LinkedList(hashSet);
        if (linkedList.isEmpty()) {
            return I18n.tr("All the ways were empty");
        }
        ArrayList arrayList = Pair.toArrayList((Pair)linkedList.poll());
        while (!linkedList.isEmpty()) {
            ListIterator listIterator = linkedList.listIterator();
            boolean bl2 = false;
            while (listIterator.hasNext()) {
                Pair pair = (Pair)listIterator.next();
                if (pair.a == arrayList.get(arrayList.size() - 1)) {
                    arrayList.add(pair.b);
                } else if (pair.b == arrayList.get(0)) {
                    arrayList.add(0, pair.a);
                } else if (bl && pair.b == arrayList.get(arrayList.size() - 1)) {
                    arrayList.add(pair.a);
                } else {
                    if (!bl || pair.a != arrayList.get(0)) continue;
                    arrayList.add(0, pair.b);
                }
                bl2 = true;
                listIterator.remove();
                break;
            }
            if (bl2) continue;
            break;
        }
        if (!linkedList.isEmpty()) {
            return I18n.tr("Could not combine ways (They could not be merged into a single string of nodes)");
        }
        return arrayList;
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        boolean bl = false;
        for (OsmPrimitive osmPrimitive : collection) {
            if (!(osmPrimitive instanceof Way)) continue;
            if (bl) {
                this.setEnabled(true);
                return;
            }
            bl = true;
        }
        this.setEnabled(false);
    }
}

