/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.util.Iterator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.tools.I18n;

public class SimplePaintVisitor
extends AbstractVisitor {
    public static final Color darkerblue = new Color(0, 0, 96);
    public static final Color darkblue = new Color(0, 0, 128);
    public static final Color darkgreen = new Color(0, 128, 0);
    public static final Color teal = new Color(0, 128, 128);
    public static final Color lightteal = new Color(0, 255, 186);
    protected Graphics g;
    protected NavigatableComponent nc;
    public boolean inactive;
    protected static final double PHI = Math.toRadians(20.0);
    protected Color inactiveColor;
    protected Color selectedColor;
    protected Color nodeColor;
    protected Color dfltWayColor;
    protected Color relationColor;
    protected Color untaggedWayColor;
    protected Color incompleteColor;
    protected Color backgroundColor;
    protected Color highlightColor;
    protected boolean showDirectionArrow;
    protected boolean showRelevantDirectionsOnly;
    protected boolean showHeadArrowOnly;
    protected boolean showOrderNumber;
    protected boolean fillSelectedNode;
    protected boolean fillUnselectedNode;
    protected int selectedNodeRadius;
    protected int unselectedNodeRadius;
    protected int selectedNodeSize;
    protected int unselectedNodeSize;
    protected int defaultSegmentWidth;
    protected int virtualNodeSize;
    protected int virtualNodeSpace;
    protected int segmentNumberSpace;
    protected int taggedNodeRadius;
    protected int taggedNodeSize;
    protected Color currentColor = null;
    protected GeneralPath currentPath = new GeneralPath();
    Rectangle bbox = new Rectangle();
    private Stroke relatedWayStroke = new BasicStroke(4.0f, 2, 2);

    public void getColors() {
        this.inactiveColor = Main.pref.getColor(I18n.marktr("inactive"), Color.darkGray);
        this.selectedColor = Main.pref.getColor(I18n.marktr("selected"), Color.red);
        this.nodeColor = Main.pref.getColor(I18n.marktr("node"), Color.yellow);
        this.dfltWayColor = Main.pref.getColor(I18n.marktr("way"), darkblue);
        this.relationColor = Main.pref.getColor(I18n.marktr("relation"), teal);
        this.untaggedWayColor = Main.pref.getColor(I18n.marktr("untagged way"), darkgreen);
        this.incompleteColor = Main.pref.getColor(I18n.marktr("incomplete way"), darkerblue);
        this.backgroundColor = Main.pref.getColor(I18n.marktr("background"), Color.BLACK);
        this.highlightColor = Main.pref.getColor(I18n.marktr("highlight"), lightteal);
    }

    protected void getSettings(Boolean bl) {
        this.showDirectionArrow = Main.pref.getBoolean("draw.segment.direction", true);
        this.showRelevantDirectionsOnly = Main.pref.getBoolean("draw.segment.relevant_directions_only", true);
        this.showHeadArrowOnly = Main.pref.getBoolean("draw.segment.head_only", false);
        this.showOrderNumber = Main.pref.getBoolean("draw.segment.order_number", false);
        this.selectedNodeRadius = Main.pref.getInteger("mappaint.node.selected-size", 5) / 2;
        this.selectedNodeSize = this.selectedNodeRadius * 2;
        this.unselectedNodeRadius = Main.pref.getInteger("mappaint.node.unselected-size", 3) / 2;
        this.unselectedNodeSize = this.unselectedNodeRadius * 2;
        this.taggedNodeRadius = Main.pref.getInteger("mappaint.node.tagged-size", 5) / 2;
        this.taggedNodeSize = this.taggedNodeRadius * 2;
        this.defaultSegmentWidth = Main.pref.getInteger("mappaint.segment.default-width", 2);
        this.fillSelectedNode = Main.pref.getBoolean("mappaint.node.fill-selected", true);
        this.fillUnselectedNode = Main.pref.getBoolean("mappaint.node.fill-unselected", false);
        this.virtualNodeSize = bl != false ? Main.pref.getInteger("mappaint.node.virtual-size", 8) / 2 : 0;
        this.virtualNodeSpace = Main.pref.getInteger("mappaint.node.virtual-space", 70);
        this.segmentNumberSpace = Main.pref.getInteger("mappaint.segmentnumber.space", 40);
        this.getColors();
        ((Graphics2D)this.g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, Main.pref.getBoolean("mappaint.use-antialiasing", false) ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public void visitAll(DataSet dataSet, Boolean bl) {
        this.getSettings(bl);
        for (Relation osmPrimitive : dataSet.relations) {
            if (osmPrimitive.deleted || osmPrimitive.selected) continue;
            ((OsmPrimitive)osmPrimitive).visit(this);
        }
        for (Way way : dataSet.ways) {
            if (way.deleted || way.selected || !way.isTagged()) continue;
            ((OsmPrimitive)way).visit(this);
        }
        this.displaySegments();
        for (Way way : dataSet.ways) {
            if (way.deleted || way.selected || way.isTagged()) continue;
            ((OsmPrimitive)way).visit(this);
        }
        this.displaySegments();
        for (OsmPrimitive osmPrimitive : dataSet.getSelected()) {
            if (osmPrimitive.deleted) continue;
            osmPrimitive.visit(this);
        }
        this.displaySegments();
        for (Node node : dataSet.nodes) {
            if (node.deleted || node.selected) continue;
            ((OsmPrimitive)node).visit(this);
        }
        if (this.virtualNodeSize != 0) {
            this.currentColor = this.nodeColor;
            for (Way way : dataSet.ways) {
                if (way.deleted) continue;
                this.visitVirtual(way);
            }
            this.displaySegments();
        }
    }

    public void visit(Node node) {
        if (node.incomplete) {
            return;
        }
        if (this.inactive) {
            this.drawNode(node, this.inactiveColor, this.unselectedNodeSize, this.unselectedNodeRadius, this.fillUnselectedNode);
        } else if (node.highlighted) {
            this.drawNode(node, this.highlightColor, this.selectedNodeSize, this.selectedNodeRadius, this.fillSelectedNode);
        } else if (node.selected) {
            this.drawNode(node, this.selectedColor, this.selectedNodeSize, this.selectedNodeRadius, this.fillSelectedNode);
        } else if (node.isTagged()) {
            this.drawNode(node, this.nodeColor, this.taggedNodeSize, this.taggedNodeRadius, this.fillUnselectedNode);
        } else {
            this.drawNode(node, this.nodeColor, this.unselectedNodeSize, this.unselectedNodeRadius, this.fillUnselectedNode);
        }
    }

    public static Boolean isLargeSegment(Point point, Point point2, int n) {
        int n2;
        int n3 = point.x - point2.x;
        if (n3 < 0) {
            n3 = -n3;
        }
        if ((n2 = point.y - point2.y) < 0) {
            n2 = -n2;
        }
        return n3 + n2 > n;
    }

    public void visitVirtual(Way way) {
        Iterator<Node> iterator = way.nodes.iterator();
        if (iterator.hasNext()) {
            Point point = this.nc.getPoint(iterator.next().eastNorth);
            while (iterator.hasNext()) {
                Point point2 = this.nc.getPoint(iterator.next().eastNorth);
                if (this.isSegmentVisible(point, point2) && SimplePaintVisitor.isLargeSegment(point, point2, this.virtualNodeSpace).booleanValue()) {
                    int n = (point2.x + point.x) / 2;
                    int n2 = (point2.y + point.y) / 2;
                    this.currentPath.moveTo(n - this.virtualNodeSize, n2);
                    this.currentPath.lineTo(n + this.virtualNodeSize, n2);
                    this.currentPath.moveTo(n, n2 - this.virtualNodeSize);
                    this.currentPath.lineTo(n, n2 + this.virtualNodeSize);
                }
                point = point2;
            }
        }
    }

    public void visit(Way way) {
        boolean bl;
        if (way.incomplete || way.nodes.size() < 2) {
            return;
        }
        boolean bl2 = way.selected || this.showDirectionArrow && (!this.showRelevantDirectionsOnly || way.hasDirectionKeys());
        boolean bl3 = bl = bl2 && !way.selected && this.showHeadArrowOnly;
        Color color = this.inactive ? this.inactiveColor : (way.highlighted ? this.highlightColor : (way.selected ? this.selectedColor : (!way.isTagged() ? this.untaggedWayColor : this.dfltWayColor)));
        Iterator<Node> iterator = way.nodes.iterator();
        if (iterator.hasNext()) {
            Point point = this.nc.getPoint(iterator.next().eastNorth);
            int n = 1;
            while (iterator.hasNext()) {
                Point point2 = this.nc.getPoint(iterator.next().eastNorth);
                this.drawSegment(point, point2, color, bl ? !iterator.hasNext() : bl2);
                if (this.showOrderNumber) {
                    this.drawOrderNumber(point, point2, n);
                }
                point = point2;
                ++n;
            }
        }
    }

    public void visit(Relation relation) {
        if (relation.incomplete) {
            return;
        }
        Color color = this.inactive ? this.inactiveColor : (relation.selected ? this.selectedColor : this.relationColor);
        this.g.setColor(color);
        for (RelationMember relationMember : relation.members) {
            Cloneable cloneable;
            if (relationMember.member.incomplete || relationMember.member.deleted) continue;
            if (relationMember.member instanceof Node) {
                cloneable = this.nc.getPoint(((Node)relationMember.member).eastNorth);
                if (((Point)cloneable).x < 0 || ((Point)cloneable).y < 0 || ((Point)cloneable).x > this.nc.getWidth() || ((Point)cloneable).y > this.nc.getHeight()) continue;
                this.g.drawOval(((Point)cloneable).x - 3, ((Point)cloneable).y - 3, 6, 6);
                continue;
            }
            if (!(relationMember.member instanceof Way)) continue;
            cloneable = new GeneralPath();
            boolean bl = true;
            for (Node node : ((Way)relationMember.member).nodes) {
                if (node.incomplete || node.deleted) continue;
                Point point = this.nc.getPoint(node.eastNorth);
                if (bl) {
                    ((Path2D.Float)cloneable).moveTo(point.x, point.y);
                    bl = false;
                    continue;
                }
                ((Path2D.Float)cloneable).lineTo(point.x, point.y);
            }
            ((Graphics2D)this.g).draw(this.relatedWayStroke.createStrokedShape((Shape)((Object)cloneable)));
        }
    }

    protected void drawOrderNumber(Point point, Point point2, int n) {
        if (this.isSegmentVisible(point, point2) && SimplePaintVisitor.isLargeSegment(point, point2, this.segmentNumberSpace).booleanValue()) {
            String string = Integer.toString(n);
            int n2 = string.length();
            int n3 = (point.x + point2.x) / 2 - 4 * n2;
            int n4 = (point.y + point2.y) / 2 + 4;
            if (this.virtualNodeSize != 0 && SimplePaintVisitor.isLargeSegment(point, point2, this.virtualNodeSpace).booleanValue()) {
                n4 = (point.y + point2.y) / 2 - this.virtualNodeSize - 3;
            }
            this.displaySegments();
            Color color = this.g.getColor();
            this.g.setColor(this.backgroundColor);
            this.g.fillRect(n3 - 1, n4 - 12, 8 * n2 + 1, 14);
            this.g.setColor(color);
            this.g.drawString(string, n3, n4);
        }
    }

    public void drawNode(Node node, Color color, int n, int n2, boolean bl) {
        if (n > 1) {
            Point point = this.nc.getPoint(node.eastNorth);
            if (point.x < 0 || point.y < 0 || point.x > this.nc.getWidth() || point.y > this.nc.getHeight()) {
                return;
            }
            this.g.setColor(color);
            if (bl) {
                this.g.fillRect(point.x - n2, point.y - n2, n, n);
                this.g.drawRect(point.x - n2, point.y - n2, n, n);
            } else {
                this.g.drawRect(point.x - n2, point.y - n2, n, n);
            }
        }
    }

    protected void drawSegment(Point point, Point point2, Color color, boolean bl) {
        if (color != this.currentColor) {
            this.displaySegments(color);
        }
        if (this.isSegmentVisible(point, point2)) {
            this.currentPath.moveTo(point.x, point.y);
            this.currentPath.lineTo(point2.x, point2.y);
            if (bl) {
                double d = Math.atan2(point2.y - point.y, point2.x - point.x) + Math.PI;
                this.currentPath.lineTo((int)((double)point2.x + 10.0 * Math.cos(d - PHI)), (int)((double)point2.y + 10.0 * Math.sin(d - PHI)));
                this.currentPath.moveTo((int)((double)point2.x + 10.0 * Math.cos(d + PHI)), (int)((double)point2.y + 10.0 * Math.sin(d + PHI)));
                this.currentPath.lineTo(point2.x, point2.y);
            }
        }
    }

    protected boolean isSegmentVisible(Point point, Point point2) {
        if (point.x < 0 && point2.x < 0) {
            return false;
        }
        if (point.y < 0 && point2.y < 0) {
            return false;
        }
        if (point.x > this.nc.getWidth() && point2.x > this.nc.getWidth()) {
            return false;
        }
        return point.y <= this.nc.getHeight() || point2.y <= this.nc.getHeight();
    }

    protected boolean isPolygonVisible(Polygon polygon) {
        Rectangle rectangle = polygon.getBounds();
        if (rectangle.width == 0 && rectangle.height == 0) {
            return false;
        }
        if (rectangle.x > this.nc.getWidth()) {
            return false;
        }
        if (rectangle.y > this.nc.getHeight()) {
            return false;
        }
        if (rectangle.x + rectangle.width < 0) {
            return false;
        }
        return rectangle.y + rectangle.height >= 0;
    }

    public void setGraphics(Graphics graphics) {
        this.g = graphics;
    }

    public void setNavigatableComponent(NavigatableComponent navigatableComponent) {
        this.nc = navigatableComponent;
    }

    protected void displaySegments() {
        this.displaySegments(null);
    }

    protected void displaySegments(Color color) {
        if (this.currentPath != null) {
            this.g.setColor(this.currentColor);
            ((Graphics2D)this.g).draw(this.currentPath);
            this.currentPath = new GeneralPath();
            this.currentColor = color;
        }
    }
}

