/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Color;
import java.util.Collection;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineElemStyle
extends ElemStyle
implements Comparable<LineElemStyle> {
    public int width;
    public int realWidth;
    public Color color;
    public int dashed;
    public Color dashedColor;
    public boolean over;
    public WidthMode widthMode;
    public Collection<LineElemStyle> overlays;

    public LineElemStyle(LineElemStyle lineElemStyle, long l, long l2) {
        this.width = lineElemStyle.width;
        this.realWidth = lineElemStyle.realWidth;
        this.color = lineElemStyle.color;
        this.dashed = lineElemStyle.dashed;
        this.dashedColor = lineElemStyle.dashedColor;
        this.over = lineElemStyle.over;
        this.widthMode = lineElemStyle.widthMode;
        this.priority = lineElemStyle.priority;
        this.maxScale = l;
        this.minScale = l2;
    }

    public LineElemStyle(LineElemStyle lineElemStyle, Collection<LineElemStyle> collection) {
        this.width = lineElemStyle.width;
        this.realWidth = lineElemStyle.realWidth;
        this.color = lineElemStyle.color;
        this.dashed = lineElemStyle.dashed;
        this.dashedColor = lineElemStyle.dashedColor;
        this.over = lineElemStyle.over;
        this.widthMode = lineElemStyle.widthMode;
        this.priority = lineElemStyle.priority;
        this.maxScale = lineElemStyle.maxScale;
        this.minScale = lineElemStyle.minScale;
        this.overlays = collection;
        this.code = lineElemStyle.code;
        for (LineElemStyle lineElemStyle2 : collection) {
            this.code = this.code + lineElemStyle2.code;
        }
    }

    public LineElemStyle() {
        this.init();
    }

    public void init() {
        this.width = 1;
        this.realWidth = 0;
        this.dashed = 0;
        this.dashedColor = null;
        this.priority = 0;
        this.color = null;
        this.over = true;
        this.widthMode = WidthMode.ABSOLUTE;
        this.overlays = null;
    }

    public int getWidth(int n) {
        int n2 = this.widthMode == WidthMode.ABSOLUTE ? this.width : (this.widthMode == WidthMode.OFFSET ? n + this.width : (this.width < 0 ? 0 : n * this.width / 100));
        return n2 <= 0 ? 1 : n2;
    }

    @Override
    public int compareTo(LineElemStyle lineElemStyle) {
        if (lineElemStyle.priority != this.priority) {
            return lineElemStyle.priority > this.priority ? 1 : -1;
        }
        if (!this.over && lineElemStyle.over) {
            return -1;
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WidthMode {
        ABSOLUTE,
        PERCENT,
        OFFSET;

    }
}

