/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadOsmTaskList
implements Runnable {
    private List<DownloadDialog.DownloadTask> osmTasks = new LinkedList<DownloadDialog.DownloadTask>();

    public void download(boolean bl, List<Rectangle2D> list) {
        if (bl) {
            OsmDataLayer osmDataLayer = new OsmDataLayer(new DataSet(), I18n.tr("Data Layer"), null);
            Main.main.addLayer(osmDataLayer);
            Main.map.mapView.setActiveLayer(osmDataLayer);
        }
        int n = 0;
        for (Rectangle2D rectangle2D : list) {
            DownloadOsmTask downloadOsmTask = new DownloadOsmTask();
            downloadOsmTask.download(null, rectangle2D.getMinY(), rectangle2D.getMinX(), rectangle2D.getMaxY(), rectangle2D.getMaxX(), true, I18n.tr("Download {0} of {1} ({2} left)", ++n, list.size(), list.size() - n));
            this.osmTasks.add(downloadOsmTask);
        }
        Main.worker.execute(this);
    }

    public void download(boolean bl, Collection<Area> collection) {
        LinkedList<Rectangle2D> linkedList = new LinkedList<Rectangle2D>();
        for (Area area : collection) {
            linkedList.add(area.getBounds2D());
        }
        this.download(bl, (List<Rectangle2D>)linkedList);
    }

    @Override
    public void run() {
        String string = "";
        for (DownloadDialog.DownloadTask downloadTask : this.osmTasks) {
            String string2 = downloadTask.getErrorMessage();
            if (string2.equals("")) continue;
            string = string + "* " + string2 + "\r\n";
        }
        this.osmTasks.clear();
        if (string.equals("")) {
            return;
        }
        JOptionPane.showMessageDialog(Main.parent, I18n.tr("The following errors occured during mass download:") + "\r\n" + string, I18n.tr("Errors during Download"), 0);
    }
}

