/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Collections;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class DeleteAction
extends MapMode {
    public DeleteAction(MapFrame mapFrame) {
        super(I18n.tr("Delete Mode"), "delete", I18n.tr("Delete nodes or ways."), Shortcut.registerShortcut("mapmode:delete", I18n.tr("Mode: {0}", I18n.tr("Delete")), 68, 3), mapFrame, ImageProvider.getCursor("normal", "delete"));
    }

    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener(this);
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (!Main.map.mapView.isDrawableLayer().booleanValue()) {
            return;
        }
        this.doActionPerformed(actionEvent);
    }

    public void doActionPerformed(ActionEvent actionEvent) {
        boolean bl;
        if (!Main.map.mapView.isDrawableLayer().booleanValue()) {
            return;
        }
        boolean bl2 = (actionEvent.getModifiers() & 2) != 0;
        boolean bl3 = bl = (actionEvent.getModifiers() & 0x28) != 0;
        Command command = bl2 ? DeleteCommand.deleteWithReferences(Main.ds.getSelected()) : DeleteCommand.delete(Main.ds.getSelected(), !bl);
        if (command != null) {
            Main.main.undoRedo.add(command);
        }
        Main.ds.setSelected(new OsmPrimitive[0]);
        Main.map.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() != 1) {
            return;
        }
        if (!Main.map.mapView.isVisibleDrawableLayer().booleanValue()) {
            return;
        }
        boolean bl = (mouseEvent.getModifiers() & 2) != 0;
        boolean bl2 = (mouseEvent.getModifiers() & 1) != 0;
        boolean bl3 = (mouseEvent.getModifiers() & 0x28) != 0;
        Node node = Main.map.mapView.getNearestNode(mouseEvent.getPoint());
        Command command = null;
        if (node == null) {
            WaySegment waySegment = Main.map.mapView.getNearestWaySegment(mouseEvent.getPoint());
            if (waySegment != null) {
                command = bl2 ? DeleteCommand.deleteWaySegment(waySegment) : (bl ? DeleteCommand.deleteWithReferences(Collections.singleton(waySegment.way)) : DeleteCommand.delete(Collections.singleton(waySegment.way), !bl3));
            }
        } else {
            command = bl ? DeleteCommand.deleteWithReferences(Collections.singleton(node)) : DeleteCommand.delete(Collections.singleton(node), !bl3);
        }
        if (command != null) {
            Main.main.undoRedo.add(command);
        }
        Main.ds.setSelected(new OsmPrimitive[0]);
        Main.map.mapView.repaint();
    }

    public String getModeHelpText() {
        return I18n.tr("Click to delete. Shift: delete way segment. Alt: don't delete unused nodes when deleting a way. Ctrl: delete referring objects.");
    }

    public boolean layerIsSupported(Layer layer) {
        return layer instanceof OsmDataLayer;
    }
}

