/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxRoute;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.gpx.WithAttributes;

public class GpxData
extends WithAttributes {
    public static final String META_PREFIX = "meta.";
    public static final String META_AUTHOR_NAME = "meta.author.name";
    public static final String META_AUTHOR_EMAIL = "meta.author.email";
    public static final String META_AUTHOR_LINK = "meta.author.link";
    public static final String META_COPYRIGHT_AUTHOR = "meta.copyright.author";
    public static final String META_COPYRIGHT_LICENSE = "meta.copyright.license";
    public static final String META_COPYRIGHT_YEAR = "meta.copyright.year";
    public static final String META_DESC = "meta.desc";
    public static final String META_KEYWORDS = "meta.keywords";
    public static final String META_LINKS = "meta.links";
    public static final String META_NAME = "meta.name";
    public static final String META_TIME = "meta.time";
    public File storageFile;
    public boolean fromServer;
    public Collection<GpxTrack> tracks = new LinkedList<GpxTrack>();
    public Collection<GpxRoute> routes = new LinkedList<GpxRoute>();
    public Collection<WayPoint> waypoints = new LinkedList<WayPoint>();
    public Bounds bounds;

    public void mergeFrom(GpxData gpxData) {
        if (this.storageFile == null && gpxData.storageFile != null) {
            this.storageFile = gpxData.storageFile;
        }
        this.fromServer = this.fromServer && gpxData.fromServer;
        for (Map.Entry entry : gpxData.attr.entrySet()) {
            String string = (String)entry.getKey();
            if (string.equals(META_LINKS) && this.attr.containsKey(META_LINKS)) {
                ((Collection)this.attr.get(META_LINKS)).addAll((Collection)entry.getValue());
                continue;
            }
            this.attr.put(string, entry.getValue());
        }
        this.tracks.addAll(gpxData.tracks);
        this.routes.addAll(gpxData.routes);
        this.waypoints.addAll(gpxData.waypoints);
    }

    public boolean hasTrackPoints() {
        for (GpxTrack gpxTrack : this.tracks) {
            for (Collection<WayPoint> collection : gpxTrack.trackSegs) {
                if (collection.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasRoutePoints() {
        for (GpxRoute gpxRoute : this.routes) {
            if (gpxRoute.routePoints.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void recalculateBounds() {
        this.bounds = null;
        for (WayPoint withAttributes : this.waypoints) {
            if (this.bounds == null) {
                this.bounds = new Bounds(withAttributes.latlon, withAttributes.latlon);
                continue;
            }
            this.bounds.extend(withAttributes.latlon);
        }
        for (GpxRoute gpxRoute : this.routes) {
            for (WayPoint wayPoint : gpxRoute.routePoints) {
                if (this.bounds == null) {
                    this.bounds = new Bounds(wayPoint.latlon, wayPoint.latlon);
                    continue;
                }
                this.bounds.extend(wayPoint.latlon);
            }
        }
        for (GpxTrack gpxTrack : this.tracks) {
            for (Collection collection : gpxTrack.trackSegs) {
                for (WayPoint wayPoint : collection) {
                    if (this.bounds == null) {
                        this.bounds = new Bounds(wayPoint.latlon, wayPoint.latlon);
                        continue;
                    }
                    this.bounds.extend(wayPoint.latlon);
                }
            }
        }
        if (this.bounds == null) {
            this.bounds = new Bounds();
        }
    }

    public double length() {
        double d = 0.0;
        WayPoint wayPoint = null;
        for (GpxTrack gpxTrack : this.tracks) {
            for (Collection<WayPoint> collection : gpxTrack.trackSegs) {
                for (WayPoint wayPoint2 : collection) {
                    if (wayPoint != null) {
                        d += GpxData.calcDistance(wayPoint.latlon, wayPoint2.latlon);
                    }
                    wayPoint = wayPoint2;
                }
                wayPoint = null;
            }
        }
        return d;
    }

    public static double calcDistance(LatLon latLon, LatLon latLon2) {
        double d = latLon.lat() * Math.PI / 180.0;
        double d2 = latLon.lon() * Math.PI / 180.0;
        double d3 = latLon2.lat() * Math.PI / 180.0;
        double d4 = latLon2.lon() * Math.PI / 180.0;
        double d5 = d4 - d2;
        double d6 = d3 - d;
        double d7 = Math.pow(Math.sin(d6 / 2.0), 2.0) + Math.cos(d) * Math.cos(d3) * Math.pow(Math.sin(d5 / 2.0), 2.0);
        double d8 = 2.0 * Math.atan2(Math.sqrt(d7), Math.sqrt(1.0 - d7));
        return 6367000.0 * d8;
    }
}

