/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class TileSelection
implements DownloadSelection {
    private JTextField tileX0 = new JTextField(7);
    private JTextField tileY0 = new JTextField(7);
    private JTextField tileX1 = new JTextField(7);
    private JTextField tileY1 = new JTextField(7);
    private JSpinner tileZ = new JSpinner(new SpinnerNumberModel(12, 10, 18, 1));

    public void addGui(final DownloadDialog downloadDialog) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("zoom level")), GBC.std().insets(0, 0, 10, 0));
        jPanel.add((Component)new JLabel(I18n.tr("x from")), GBC.std().insets(10, 0, 5, 0));
        jPanel.add((Component)this.tileX0, GBC.std());
        jPanel.add((Component)new JLabel(I18n.tr("to")), GBC.std().insets(10, 0, 5, 0));
        jPanel.add((Component)this.tileX1, GBC.eol());
        jPanel.add((Component)this.tileZ, GBC.std().insets(0, 0, 10, 0));
        jPanel.add((Component)new JLabel(I18n.tr("y from")), GBC.std().insets(10, 0, 5, 0));
        jPanel.add((Component)this.tileY0, GBC.std());
        jPanel.add((Component)new JLabel(I18n.tr("to")), GBC.std().insets(10, 0, 5, 0));
        jPanel.add((Component)this.tileY1, GBC.eol());
        FocusAdapter focusAdapter = new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                try {
                    int n;
                    int n2;
                    int n3 = (Integer)TileSelection.this.tileZ.getValue();
                    int n4 = n2 = Integer.parseInt(TileSelection.this.tileX0.getText());
                    if (TileSelection.this.tileX1.getText().length() > 0) {
                        n4 = Integer.parseInt(TileSelection.this.tileX1.getText());
                    }
                    if (n4 < n2) {
                        n = n2;
                        n2 = n4;
                        n4 = n;
                    }
                    int n5 = n = Integer.parseInt(TileSelection.this.tileY0.getText());
                    if (TileSelection.this.tileY1.getText().length() > 0) {
                        n5 = Integer.parseInt(TileSelection.this.tileY1.getText());
                    }
                    if (n5 < n) {
                        int n6 = n;
                        n = n5;
                        n5 = n6;
                    }
                    downloadDialog.minlat = TileSelection.tileYToLat(n3, n5 + 1);
                    downloadDialog.minlon = TileSelection.tileXToLon(n3, n2);
                    downloadDialog.maxlat = TileSelection.tileYToLat(n3, n);
                    downloadDialog.maxlon = TileSelection.tileXToLon(n3, n4 + 1);
                    downloadDialog.boundingBoxChanged(TileSelection.this);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        for (JTextField jTextField : new JTextField[]{this.tileX0, this.tileX1, this.tileY0, this.tileY1}) {
            jTextField.setMinimumSize(new Dimension(100, new JTextField().getMinimumSize().height));
            jTextField.addFocusListener(focusAdapter);
        }
        downloadDialog.tabpane.addTab(I18n.tr("Tile Numbers"), jPanel);
    }

    public void boundingBoxChanged(DownloadDialog downloadDialog) {
        this.updateBboxFields(downloadDialog);
    }

    private void updateBboxFields(DownloadDialog downloadDialog) {
        int n = (Integer)this.tileZ.getValue();
        this.tileX0.setText(Integer.toString(TileSelection.lonToTileX(n, downloadDialog.minlon)));
        this.tileX1.setText(Integer.toString(TileSelection.lonToTileX(n, downloadDialog.maxlon - 1.0E-5)));
        this.tileY0.setText(Integer.toString(TileSelection.latToTileY(n, downloadDialog.maxlat - 1.0E-5)));
        this.tileY1.setText(Integer.toString(TileSelection.latToTileY(n, downloadDialog.minlat)));
    }

    public static int latToTileY(int n, double d) {
        if (n < 3 || n > 18) {
            return -1;
        }
        double d2 = d / 180.0 * Math.PI;
        double d3 = Math.log(Math.tan(d2) + 1.0 / Math.cos(d2));
        return (int)((double)(1 << n - 1) * (Math.PI - d3) / Math.PI);
    }

    public static int lonToTileX(int n, double d) {
        if (n < 3 || n > 18) {
            return -1;
        }
        return (int)((double)(1 << n - 3) * (d + 180.0) / 45.0);
    }

    public static double tileYToLat(int n, int n2) {
        if (n < 3 || n > 18) {
            return Double.MIN_VALUE;
        }
        return Math.atan(Math.sinh(Math.PI - Math.PI * (double)n2 / (double)(1 << n - 1))) * 180.0 / Math.PI;
    }

    public static double tileXToLon(int n, int n2) {
        if (n < 3 || n > 18) {
            return Double.MIN_VALUE;
        }
        return (double)n2 * 45.0 / (double)(1 << n - 3) - 180.0;
    }
}

