/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.PleaseWaitDialog;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmConnection;
import org.openstreetmap.josm.io.ProgressInputStream;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public abstract class OsmServerReader
extends OsmConnection {
    private OsmApi api = new OsmApi();

    protected InputStream getInputStream(String string, PleaseWaitDialog pleaseWaitDialog) throws IOException {
        try {
            this.api.initialize();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, I18n.tr("Failed to initialize communication with the OSM server {0}.\nCheck the server URL in your preferences and your internet connection.", Main.pref.get("osm-server.url")), I18n.tr("Error"), 0);
            exception.printStackTrace();
            return null;
        }
        string = this.api.getBaseUrl() + string;
        return this.getInputStreamRaw(string, pleaseWaitDialog);
    }

    protected InputStream getInputStreamRaw(String string, PleaseWaitDialog pleaseWaitDialog) throws IOException {
        URL uRL = new URL(string);
        this.activeConnection = (HttpURLConnection)uRL.openConnection();
        if (this.cancel) {
            this.activeConnection.disconnect();
            return null;
        }
        if (Main.pref.getBoolean("osm-server.use-compression", true)) {
            this.activeConnection.setRequestProperty("Accept-Encoding", "gzip, deflate");
        }
        this.activeConnection.setConnectTimeout(15000);
        try {
            this.activeConnection.connect();
        }
        catch (Exception exception) {
            throw new IOException(I18n.tr("Couldn't connect to the osm server. Please check your internet connection."));
        }
        if (this.isAuthCancelled() && this.activeConnection.getResponseCode() == 401) {
            return null;
        }
        if (this.activeConnection.getResponseCode() == 500) {
            throw new IOException(I18n.tr("Server returned internal error. Try a reduced area or retry after waiting some time."));
        }
        String string2 = this.activeConnection.getContentEncoding();
        InputStream inputStream = new ProgressInputStream(this.activeConnection, pleaseWaitDialog);
        if (string2 != null && string2.equalsIgnoreCase("gzip")) {
            inputStream = new GZIPInputStream(inputStream);
        } else if (string2 != null && string2.equalsIgnoreCase("deflate")) {
            inputStream = new InflaterInputStream(inputStream, new Inflater(true));
        }
        return inputStream;
    }

    public abstract DataSet parseOsm() throws SAXException, IOException;
}

