/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WayNodesConflictResolverCommand
extends Command {
    private final Way my;
    private final Way their;
    private final List<Node> mergedNodeList;

    public WayNodesConflictResolverCommand(Way way, Way way2, List<Node> list) {
        this.my = way;
        this.their = way2;
        this.mergedNodeList = list;
    }

    @Override
    public MutableTreeNode description() {
        return new DefaultMutableTreeNode(new JLabel(I18n.tr("Resolve conflicts in node list of of way {0}", this.my.id), ImageProvider.get("data", "object"), 0));
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        this.my.nodes.clear();
        for (int i = 0; i < this.mergedNodeList.size(); ++i) {
            Node node = this.mergedNodeList.get(i);
            this.my.nodes.add(node);
            if (Main.ds.nodes.contains(node)) continue;
            System.out.println("Main.ds doesn't include node " + node.toString());
        }
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.add(this.my);
    }

    @Override
    public void undoCommand() {
        super.undoCommand();
        if (!Main.map.conflictDialog.conflicts.containsKey(this.my)) {
            Main.map.conflictDialog.addConflict(this.my, this.their);
        }
    }
}

