/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.actions.HelpAction;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.MapView;

class MapSlider
extends JSlider
implements PropertyChangeListener,
ChangeListener,
HelpAction.Helpful {
    private final MapView mv;
    boolean preventChange = false;

    public MapSlider(MapView mapView) {
        super(35, 150);
        this.setOpaque(false);
        this.mv = mapView;
        mapView.addPropertyChangeListener("scale", this);
        this.addChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.getModel().getValueIsAdjusting()) {
            return;
        }
        double d = this.mv.scale * (double)this.mv.getWidth();
        double d2 = this.mv.scale * (double)this.mv.getHeight();
        int n = 0;
        while (n <= 150) {
            if (d > MapView.world.east() || d2 > MapView.world.north()) {
                this.preventChange = true;
                this.setValue(n);
                this.preventChange = false;
                break;
            }
            ++n;
            d *= 1.1;
            d2 *= 1.1;
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.preventChange) {
            return;
        }
        EastNorth eastNorth = MapView.world;
        for (int i = 0; i < this.getValue(); ++i) {
            eastNorth = new EastNorth(eastNorth.east() / 1.1, eastNorth.north() / 1.1);
        }
        if (this.mv.getWidth() < this.mv.getHeight()) {
            this.mv.zoomTo(this.mv.center, eastNorth.east() / (double)(this.mv.getWidth() - 20));
        } else {
            this.mv.zoomTo(this.mv.center, eastNorth.north() / (double)(this.mv.getHeight() - 20));
        }
    }

    public String helpTopic() {
        return "MapView/Slider";
    }
}

