/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.MoveAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapMover;
import org.openstreetmap.josm.gui.MapScaler;
import org.openstreetmap.josm.gui.MapSlider;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.PlayHeadMarker;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapView
extends NavigatableComponent {
    private ArrayList<Layer> layers = new ArrayList();
    public PlayHeadMarker playHeadMarker = null;
    public OsmDataLayer editLayer;
    private Layer activeLayer;
    public MouseEvent lastMEvent;
    private LinkedList<MapViewPaintable> temporaryLayers = new LinkedList();
    private BufferedImage offscreenBuffer;
    private Boolean virtualnodes = false;

    public MapView() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                MapView.this.removeComponentListener(this);
                MapSlider mapSlider = new MapSlider(MapView.this);
                MapView.this.add(mapSlider);
                mapSlider.setBounds(3, 0, 114, 30);
                MapScaler mapScaler = new MapScaler(MapView.this, Main.proj);
                MapView.this.add(mapScaler);
                mapScaler.setLocation(10, 30);
                if (!MapView.this.zoomToEditLayerBoundingBox()) {
                    new AutoScaleAction("data").actionPerformed(null);
                }
                new MapMover(MapView.this, Main.contentPane);
                MoveAction moveAction = new MoveAction(MoveAction.Direction.UP);
                if (moveAction.getShortcut() != null) {
                    Main.contentPane.getInputMap(2).put(moveAction.getShortcut().getKeyStroke(), "UP");
                    Main.contentPane.getActionMap().put("UP", moveAction);
                }
                if ((moveAction = new MoveAction(MoveAction.Direction.DOWN)).getShortcut() != null) {
                    Main.contentPane.getInputMap(2).put(moveAction.getShortcut().getKeyStroke(), "DOWN");
                    Main.contentPane.getActionMap().put("DOWN", moveAction);
                }
                if ((moveAction = new MoveAction(MoveAction.Direction.LEFT)).getShortcut() != null) {
                    Main.contentPane.getInputMap(2).put(moveAction.getShortcut().getKeyStroke(), "LEFT");
                    Main.contentPane.getActionMap().put("LEFT", moveAction);
                }
                if ((moveAction = new MoveAction(MoveAction.Direction.RIGHT)).getShortcut() != null) {
                    Main.contentPane.getInputMap(2).put(moveAction.getShortcut().getKeyStroke(), "RIGHT");
                    Main.contentPane.getActionMap().put("RIGHT", moveAction);
                }
            }
        });
        DataSet.selListeners.add(new SelectionChangedListener(){

            @Override
            public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
                MapView.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent mouseEvent) {
                this.mouseMoved(mouseEvent);
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                MapView.this.lastMEvent = mouseEvent;
            }
        });
    }

    public void addLayer(Layer layer) {
        int n;
        if (layer instanceof OsmDataLayer) {
            this.editLayer = (OsmDataLayer)layer;
            Main.ds = this.editLayer.data;
            this.editLayer.listenerModified.add(new OsmDataLayer.ModifiedChangedListener(){

                public void modifiedChanged(boolean bl, OsmDataLayer osmDataLayer) {
                    JOptionPane.getFrameForComponent(Main.parent).setTitle((bl ? "*" : "") + I18n.tr("Java OpenStreetMap Editor"));
                }
            });
        }
        if (layer instanceof MarkerLayer && this.playHeadMarker == null) {
            this.playHeadMarker = PlayHeadMarker.create();
        }
        for (n = this.layers.size(); n > 0 && this.layers.get((int)(n - 1)).background; --n) {
        }
        this.layers.add(n, layer);
        for (Layer.LayerChangeListener object : Layer.listeners) {
            object.layerAdded(layer);
        }
        if (layer instanceof OsmDataLayer || this.activeLayer == null) {
            Layer layer2 = this.activeLayer;
            this.setActiveLayer(layer);
            for (Layer.LayerChangeListener layerChangeListener : Layer.listeners) {
                layerChangeListener.activeLayerChange(layer2, layer);
            }
        }
        this.repaint();
    }

    @Override
    protected DataSet getData() {
        if (this.activeLayer != null && this.activeLayer instanceof OsmDataLayer) {
            return ((OsmDataLayer)this.activeLayer).data;
        }
        return new DataSet();
    }

    public Boolean isDrawableLayer() {
        return this.activeLayer != null && this.activeLayer instanceof OsmDataLayer;
    }

    public Boolean isVisibleDrawableLayer() {
        return this.isDrawableLayer() != false && this.activeLayer.visible;
    }

    public void removeLayer(Layer layer) {
        if (this.layers.remove(layer)) {
            for (Layer.LayerChangeListener layerChangeListener : Layer.listeners) {
                layerChangeListener.layerRemoved(layer);
            }
        }
        if (layer == this.editLayer) {
            this.editLayer = null;
            Main.ds.setSelected(new OsmPrimitive[0]);
        }
        layer.destroy();
    }

    public void enableVirtualNodes(Boolean bl) {
        if (this.virtualnodes != bl) {
            this.virtualnodes = bl;
            this.repaint();
        }
    }

    public Boolean useVirtualNodes() {
        return this.virtualnodes;
    }

    public void moveLayer(Layer layer, int n) {
        int n2 = this.layers.indexOf(layer);
        if (n2 == -1) {
            throw new IllegalArgumentException(I18n.tr("layer not in list."));
        }
        if (n == n2) {
            return;
        }
        this.layers.remove(n2);
        if (n >= this.layers.size()) {
            this.layers.add(layer);
        } else {
            this.layers.add(n, layer);
        }
    }

    public int getLayerPos(Layer layer) {
        int n = this.layers.indexOf(layer);
        if (n == -1) {
            throw new IllegalArgumentException(I18n.tr("layer not in list."));
        }
        return n;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.center == null) {
            return;
        }
        if (null == this.offscreenBuffer || this.offscreenBuffer.getWidth() != this.getWidth() || this.offscreenBuffer.getHeight() != this.getHeight()) {
            this.offscreenBuffer = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        }
        Graphics2D graphics2D = this.offscreenBuffer.createGraphics();
        graphics2D.setColor(Main.pref.getColor("background", Color.BLACK));
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            Layer object2 = this.layers.get(i);
            if (!object2.visible) continue;
            object2.paint(graphics2D, this);
        }
        for (MapViewPaintable mapViewPaintable : this.temporaryLayers) {
            mapViewPaintable.paint(graphics2D, this);
        }
        graphics2D.setColor(Color.WHITE);
        Bounds bounds = new Bounds();
        Point point = this.getPoint(this.getProjection().latlon2eastNorth(bounds.min));
        Point point2 = this.getPoint(this.getProjection().latlon2eastNorth(bounds.max));
        int n = Math.min(point.x, point2.x);
        int n2 = Math.min(point.y, point2.y);
        int n3 = Math.max(point.x, point2.x);
        int n4 = Math.max(point.y, point2.y);
        if (n > 0 || n2 > 0 || n3 < this.getWidth() || n4 < this.getHeight()) {
            graphics2D.drawRect(n, n2, n3 - n + 1, n4 - n2 + 1);
        }
        if (this.playHeadMarker != null) {
            this.playHeadMarker.paint(graphics2D, this);
        }
        graphics.drawImage(this.offscreenBuffer, 0, 0, null);
        super.paint(graphics);
    }

    public void recalculateCenterScale(BoundingXYVisitor boundingXYVisitor) {
        int n;
        int n2 = this.getWidth() - 20;
        if (n2 < 20) {
            n2 = 20;
        }
        if ((n = this.getHeight() - 20) < 20) {
            n = 20;
        }
        EastNorth eastNorth = this.center;
        double d = this.scale;
        if (boundingXYVisitor == null || boundingXYVisitor.min == null || boundingXYVisitor.max == null) {
            this.center = this.getProjection().latlon2eastNorth(new LatLon(0.0, 0.0));
            EastNorth eastNorth2 = this.getProjection().latlon2eastNorth(new LatLon(85.05112877980659, 180.0));
            double d2 = eastNorth2.east() * 2.0 / (double)n2;
            double d3 = eastNorth2.north() * 2.0 / (double)n;
            this.scale = Math.max(d2, d3);
        } else {
            if (boundingXYVisitor.min.equals(boundingXYVisitor.max)) {
                boundingXYVisitor.enlargeBoundingBox();
            }
            this.center = new EastNorth(boundingXYVisitor.min.east() / 2.0 + boundingXYVisitor.max.east() / 2.0, boundingXYVisitor.min.north() / 2.0 + boundingXYVisitor.max.north() / 2.0);
            double d4 = (boundingXYVisitor.max.east() - boundingXYVisitor.min.east()) / (double)n2;
            double d5 = (boundingXYVisitor.max.north() - boundingXYVisitor.min.north()) / (double)n;
            this.scale = Math.max(d4, d5);
        }
        if (!this.center.equals(eastNorth)) {
            this.firePropertyChange("center", eastNorth, this.center);
        }
        if (d != this.scale) {
            this.firePropertyChange("scale", d, this.scale);
        }
        this.repaint();
    }

    public Collection<Layer> getAllLayers() {
        return Collections.unmodifiableCollection(this.layers);
    }

    public void setActiveLayer(Layer layer) {
        if (!this.layers.contains(layer)) {
            throw new IllegalArgumentException("Layer must be in layerlist");
        }
        if (layer instanceof OsmDataLayer) {
            this.editLayer = (OsmDataLayer)layer;
            Main.ds = this.editLayer.data;
        } else {
            Main.ds.setSelected(new OsmPrimitive[0]);
        }
        DataSet.fireSelectionChanged(Main.ds.getSelected());
        Layer layer2 = this.activeLayer;
        this.activeLayer = layer;
        if (layer2 != layer) {
            for (Layer.LayerChangeListener object : Layer.listeners) {
                object.activeLayerChange(layer2, layer);
            }
        }
        Enumeration<AbstractButton> enumeration = Main.map.toolGroup.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = (AbstractButton)enumeration.nextElement();
            abstractButton.setEnabled(((MapMode)abstractButton.getAction()).layerIsSupported(layer));
        }
        this.repaint();
    }

    public Layer getActiveLayer() {
        return this.activeLayer;
    }

    @Override
    public void zoomTo(EastNorth eastNorth, double d) {
        EastNorth eastNorth2 = this.center;
        double d2 = this.scale;
        super.zoomTo(eastNorth, d);
        if (eastNorth2 == null && this.center != null || !eastNorth2.equals(this.center)) {
            this.firePropertyChange("center", eastNorth2, this.center);
        }
        if (d2 != d) {
            this.firePropertyChange("scale", d2, d);
        }
    }

    public boolean zoomToEditLayerBoundingBox() {
        Collection<DataSource> collection = Main.main.editLayer().data.dataSources;
        BoundingXYVisitor boundingXYVisitor = new BoundingXYVisitor();
        for (DataSource dataSource : collection) {
            if (dataSource.bounds != null) {
                boundingXYVisitor.visit(Main.proj.latlon2eastNorth(dataSource.bounds.max));
                boundingXYVisitor.visit(Main.proj.latlon2eastNorth(dataSource.bounds.min));
            }
            if (boundingXYVisitor.max == null || boundingXYVisitor.min == null || boundingXYVisitor.max.equals(boundingXYVisitor.min)) continue;
            this.recalculateCenterScale(boundingXYVisitor);
            return true;
        }
        return false;
    }

    public boolean addTemporaryLayer(MapViewPaintable mapViewPaintable) {
        if (this.temporaryLayers.contains(mapViewPaintable)) {
            return false;
        }
        return this.temporaryLayers.add(mapViewPaintable);
    }

    public boolean removeTemporaryLayer(MapViewPaintable mapViewPaintable) {
        return this.temporaryLayers.remove(mapViewPaintable);
    }
}

