/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.relation;

import java.util.logging.Logger;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.command.RelationMemberConflictResolverCommand;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.conflict.ListMergeModel;
import org.openstreetmap.josm.gui.conflict.ListRole;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationMemberListMergeModel
extends ListMergeModel<RelationMember> {
    private static final Logger logger = Logger.getLogger(RelationMemberListMergeModel.class.getName());

    @Override
    public boolean isEqualEntry(RelationMember relationMember, RelationMember relationMember2) {
        boolean bl;
        boolean bl2 = bl = relationMember.role == null && relationMember2.role == null || relationMember.role != null && relationMember.role.equals(relationMember2.role);
        bl = relationMember.member.id > 0L ? bl && relationMember.member.id == relationMember2.member.id : bl && relationMember == relationMember2;
        return bl;
    }

    @Override
    protected void buildMergedEntriesTableModel() {
        this.mergedEntriesTableModel = new ListMergeModel.EntriesTableModel(this, ListRole.MERGED_ENTRIES){
            {
                RelationMemberListMergeModel relationMemberListMergeModel3 = relationMemberListMergeModel2;
                relationMemberListMergeModel3.getClass();
                super(relationMemberListMergeModel3, listRole);
            }

            public boolean isCellEditable(int n, int n2) {
                switch (n2) {
                    case 1: {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    @Override
    protected void setValueAt(DefaultTableModel defaultTableModel, Object object, int n, int n2) {
        if (defaultTableModel == this.getMergedTableModel() && n2 == 1) {
            RelationMember relationMember = (RelationMember)this.getMergedEntries().get(n);
            relationMember.role = (String)object;
            this.fireModelDataChanged();
        }
    }

    public void populate(Relation relation, Relation relation2) {
        if (relation == null) {
            throw new IllegalArgumentException(I18n.tr("parameter '{0}' must not be null", "my"));
        }
        if (relation2 == null) {
            throw new IllegalArgumentException(I18n.tr("parameter '{0}' must not be null", "their"));
        }
        this.getMergedEntries().clear();
        this.getMyEntries().clear();
        this.getTheirEntries().clear();
        for (RelationMember relationMember : relation.members) {
            this.getMyEntries().add(relationMember);
        }
        for (RelationMember relationMember : relation2.members) {
            this.getTheirEntries().add(relationMember);
        }
        if (this.myAndTheirEntriesEqual()) {
            for (RelationMember relationMember : this.getMyEntries()) {
                this.getMergedEntries().add(this.cloneEntryForMergedList(relationMember));
            }
            this.setFrozen(true);
        } else {
            this.setFrozen(false);
        }
        this.fireModelDataChanged();
    }

    @Override
    protected RelationMember cloneEntryForMergedList(RelationMember relationMember) {
        RelationMember relationMember2 = new RelationMember();
        relationMember2.role = relationMember.role;
        relationMember2.member = relationMember.member;
        return relationMember2;
    }

    public RelationMemberConflictResolverCommand buildResolveCommand(Relation relation, Relation relation2) {
        if (relation == null) {
            throw new IllegalArgumentException(I18n.tr("parameter '{0}' must not be null", "my"));
        }
        if (relation2 == null) {
            throw new IllegalArgumentException(I18n.tr("parameter '{0}' must not be null", "their"));
        }
        if (!this.isFrozen()) {
            throw new IllegalArgumentException(I18n.tr("merged nodes not frozen yet. Can't build resolution command"));
        }
        return new RelationMemberConflictResolverCommand(relation, relation2, this.getMergedEntries());
    }
}

