/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.DateParser;
import org.openstreetmap.josm.tools.ExifReader;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoImageLayer
extends Layer {
    public ArrayList<ImageEntry> data;
    private LinkedList<TimedPoint> gps = new LinkedList();
    private long delta = Long.parseLong(Main.pref.get("tagimages.delta", "0"));
    private long gpstimezone = Long.parseLong(Main.pref.get("tagimages.gpstimezone", "0")) * 60L * 60L * 1000L;
    private boolean mousePressed = false;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    private MouseAdapter mouseAdapter;
    private int currentImage;

    public static void create(Collection<File> collection, GpxLayer gpxLayer) {
        Loader loader = new Loader(collection, gpxLayer);
        Main.worker.execute(loader);
    }

    private GeoImageLayer(final ArrayList<ImageEntry> arrayList, LinkedList<TimedPoint> linkedList) {
        super(I18n.tr("Geotagged Images"));
        Collections.sort(arrayList);
        Collections.sort(linkedList);
        this.data = arrayList;
        this.gps = linkedList;
        final GeoImageLayer geoImageLayer = this;
        this.mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1) {
                    return;
                }
                GeoImageLayer.this.mousePressed = true;
                if (GeoImageLayer.this.visible) {
                    Main.map.mapView.repaint();
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1) {
                    return;
                }
                GeoImageLayer.this.mousePressed = false;
                if (!GeoImageLayer.this.visible) {
                    return;
                }
                for (int i = arrayList.size(); i > 0; --i) {
                    ImageEntry imageEntry = (ImageEntry)arrayList.get(i - 1);
                    if (imageEntry.pos == null) continue;
                    Point point = Main.map.mapView.getPoint(imageEntry.pos);
                    Rectangle rectangle = new Rectangle(point.x - imageEntry.icon.getIconWidth() / 2, point.y - imageEntry.icon.getIconHeight() / 2, imageEntry.icon.getIconWidth(), imageEntry.icon.getIconHeight());
                    if (!rectangle.contains(mouseEvent.getPoint())) continue;
                    GeoImageLayer.this.showImage(i - 1);
                    break;
                }
                Main.map.mapView.repaint();
            }
        };
        Main.map.mapView.addMouseListener(this.mouseAdapter);
        Layer.listeners.add(new Layer.LayerChangeListener(){

            public void activeLayerChange(Layer layer, Layer layer2) {
            }

            public void layerAdded(Layer layer) {
            }

            public void layerRemoved(Layer layer) {
                if (layer == geoImageLayer) {
                    Main.map.mapView.removeMouseListener(GeoImageLayer.this.mouseAdapter);
                }
            }
        });
    }

    private void showImage(int n) {
        this.currentImage = n;
        final JPanel jPanel = new JPanel(new BorderLayout());
        final ImageEntry imageEntry = this.data.get(this.currentImage);
        if (!imageEntry.image.exists() || !imageEntry.image.canRead()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Image with path {0} does not exist or is not readable.", imageEntry.image), I18n.tr("Warning"), 2);
            return;
        }
        JScrollPane jScrollPane = new JScrollPane(new JLabel(GeoImageLayer.loadScaledImage(imageEntry.image, 580)));
        final JViewport jViewport = jScrollPane.getViewport();
        jPanel.add((Component)jScrollPane, "Center");
        final JToggleButton jToggleButton = new JToggleButton(ImageProvider.get("dialogs", "zoom-best-fit"));
        final JButton jButton = new JButton(ImageProvider.get("dialogs", "next"));
        final JButton jButton2 = new JButton(ImageProvider.get("dialogs", "previous"));
        final JToggleButton jToggleButton2 = new JToggleButton(ImageProvider.get("dialogs", "centreview"));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jButton2);
        jPanel2.add(jToggleButton);
        jPanel2.add(jToggleButton2);
        jPanel2.add(jButton);
        jButton2.setEnabled(this.currentImage > 0);
        jButton.setEnabled(this.currentImage < this.data.size() - 1);
        jPanel.add((Component)jPanel2, "South");
        JOptionPane jOptionPane = new JOptionPane(jPanel, -1);
        final JDialog jDialog = jOptionPane.createDialog(Main.parent, imageEntry.image + " (" + imageEntry.coor.toDisplayString() + ")");
        jToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jPanel.setCursor(Cursor.getPredefinedCursor(3));
                if (jToggleButton.getModel().isSelected()) {
                    ((JLabel)jViewport.getView()).setIcon(GeoImageLayer.loadScaledImage(imageEntry.image, Math.max(jViewport.getWidth(), jViewport.getHeight())));
                } else {
                    ((JLabel)jViewport.getView()).setIcon(new ImageIcon(imageEntry.image.getPath()));
                }
                jPanel.setCursor(Cursor.getDefaultCursor());
            }
        });
        jToggleButton.setSelected(true);
        jToggleButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageEntry imageEntry = GeoImageLayer.this.data.get(GeoImageLayer.this.currentImage);
                if (jToggleButton2.getModel().isSelected()) {
                    Main.map.mapView.zoomTo(imageEntry.pos, Main.map.mapView.getScale());
                }
            }
        });
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jPanel.setCursor(Cursor.getPredefinedCursor(3));
                if (actionEvent.getActionCommand().equals("Next")) {
                    GeoImageLayer.this.currentImage++;
                    if (GeoImageLayer.this.currentImage >= GeoImageLayer.this.data.size() - 1) {
                        jButton.setEnabled(false);
                    }
                    jButton2.setEnabled(true);
                } else {
                    GeoImageLayer.this.currentImage--;
                    if (GeoImageLayer.this.currentImage <= 0) {
                        jButton2.setEnabled(false);
                    }
                    jButton.setEnabled(true);
                }
                ImageEntry imageEntry = GeoImageLayer.this.data.get(GeoImageLayer.this.currentImage);
                if (jToggleButton.getModel().isSelected()) {
                    ((JLabel)jViewport.getView()).setIcon(GeoImageLayer.loadScaledImage(imageEntry.image, Math.max(jViewport.getWidth(), jViewport.getHeight())));
                } else {
                    ((JLabel)jViewport.getView()).setIcon(new ImageIcon(imageEntry.image.getPath()));
                }
                jDialog.setTitle(imageEntry.image + " (" + imageEntry.coor.toDisplayString() + ")");
                if (jToggleButton2.getModel().isSelected()) {
                    Main.map.mapView.zoomTo(imageEntry.pos, Main.map.mapView.getScale());
                }
                jPanel.setCursor(Cursor.getDefaultCursor());
            }
        };
        jButton.setActionCommand("Next");
        jButton2.setActionCommand("Previous");
        jButton.setMnemonic(39);
        jButton2.setMnemonic(37);
        jToggleButton.setMnemonic(70);
        jToggleButton2.setMnemonic(67);
        jButton.setToolTipText("Show next image");
        jButton2.setToolTipText("Show previous image");
        jToggleButton2.setToolTipText("Centre image location in main display");
        jToggleButton.setToolTipText("Scale image to fit");
        jButton2.addActionListener(actionListener);
        jButton.addActionListener(actionListener);
        jToggleButton2.setSelected(false);
        jDialog.addComponentListener(new ComponentListener(){
            boolean ignoreEvent = true;

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                if (jToggleButton.getModel().isSelected() && !this.ignoreEvent) {
                    ((JLabel)jViewport.getView()).setIcon(GeoImageLayer.loadScaledImage(imageEntry.image, Math.max(jViewport.getWidth(), jViewport.getHeight())));
                }
                this.ignoreEvent = false;
            }

            public void componentShown(ComponentEvent componentEvent) {
            }
        });
        jDialog.setModal(false);
        jDialog.setVisible(true);
        jDialog.setResizable(true);
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("layer", "tagimages_small");
    }

    @Override
    public Object getInfoComponent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(this.getToolTipText()), GBC.eop());
        jPanel.add((Component)new JLabel(I18n.tr("GPS start: {0}", dateFormat.format(this.gps.getFirst().time))), GBC.eol());
        jPanel.add((Component)new JLabel(I18n.tr("GPS end: {0}", dateFormat.format(this.gps.getLast().time))), GBC.eop());
        jPanel.add((Component)new JLabel(I18n.tr("current delta: {0}s", (double)this.delta / 1000.0)), GBC.eol());
        jPanel.add((Component)new JLabel(I18n.tr("timezone difference: ") + (this.gpstimezone > 0L ? "+" : "") + this.gpstimezone / 1000L / 60L / 60L), GBC.eop());
        JList<Object> jList = new JList<Object>(this.data.toArray());
        jList.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                ImageEntry imageEntry = (ImageEntry)object;
                this.setIcon(imageEntry.icon);
                this.setText(imageEntry.image.getName() + " (" + dateFormat.format(new Date(imageEntry.time.getTime() + (GeoImageLayer.this.delta + GeoImageLayer.this.gpstimezone))) + ")");
                if (imageEntry.pos == null) {
                    this.setForeground(Color.red);
                }
                return this;
            }
        });
        jList.setVisibleRowCount(5);
        jPanel.add((Component)new JScrollPane(jList), GBC.eop().fill(1));
        return jPanel;
    }

    @Override
    public String getToolTipText() {
        int n = 0;
        for (ImageEntry imageEntry : this.data) {
            if (imageEntry.pos == null) continue;
            ++n;
        }
        return this.data.size() + " " + I18n.trn("image", "images", this.data.size()) + ". " + I18n.tr("{0} within the track.", n);
    }

    @Override
    public boolean isMergable(Layer layer) {
        return layer instanceof GeoImageLayer;
    }

    @Override
    public void mergeFrom(Layer layer) {
        GeoImageLayer geoImageLayer = (GeoImageLayer)layer;
        this.data.addAll(geoImageLayer.data);
    }

    @Override
    public void paint(Graphics graphics, MapView mapView) {
        boolean bl = false;
        for (ImageEntry imageEntry : this.data) {
            if (imageEntry.pos == null) continue;
            Point point = mapView.getPoint(imageEntry.pos);
            Rectangle rectangle = new Rectangle(point.x - imageEntry.icon.getIconWidth() / 2, point.y - imageEntry.icon.getIconHeight() / 2, imageEntry.icon.getIconWidth(), imageEntry.icon.getIconHeight());
            imageEntry.icon.paintIcon(mapView, graphics, rectangle.x, rectangle.y);
            Border border = null;
            Point point2 = mapView.getMousePosition();
            if (point2 == null) continue;
            if (!bl && this.mousePressed && rectangle.contains(point2)) {
                border = BorderFactory.createBevelBorder(1);
                bl = true;
            } else {
                border = BorderFactory.createBevelBorder(0);
            }
            Insets insets = border.getBorderInsets(mapView);
            rectangle.grow((insets.top + insets.bottom) / 2, (insets.left + insets.right) / 2);
            border.paintBorder(mapView, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
        for (ImageEntry imageEntry : this.data) {
            boundingXYVisitor.visit(imageEntry.pos);
        }
    }

    @Override
    public Component[] getMenuEntries() {
        JMenuItem jMenuItem = new JMenuItem(I18n.tr("Sync clock"), ImageProvider.get("clock"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(Main.pref.get("tagimages.lastdirectory"));
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setAcceptAllFileFilterUsed(false);
                jFileChooser.setFileFilter(new FileFilter(){

                    public boolean accept(File file) {
                        return file.isDirectory() || file.getName().toLowerCase().endsWith(".jpg");
                    }

                    public String getDescription() {
                        return I18n.tr("JPEG images (*.jpg)");
                    }
                });
                jFileChooser.showOpenDialog(Main.parent);
                File file = jFileChooser.getSelectedFile();
                if (file == null) {
                    return;
                }
                Main.pref.put("tagimages.lastdirectory", file.getPath());
                GeoImageLayer.this.sync(file);
                Main.map.repaint();
            }
        });
        return new Component[]{new JMenuItem(new LayerListDialog.ShowHideLayerAction(this)), new JMenuItem(new LayerListDialog.DeleteLayerAction(this)), new JSeparator(), jMenuItem, new JSeparator(), new JMenuItem(new RenameLayerAction(null, this)), new JSeparator(), new JMenuItem(new LayerListPopup.InfoAction(this))};
    }

    private void calculatePosition() {
        for (ImageEntry imageEntry : this.data) {
            TimedPoint timedPoint = null;
            for (TimedPoint timedPoint2 : this.gps) {
                Date date = new Date(timedPoint2.time.getTime() - (this.delta + this.gpstimezone));
                if (date.after(imageEntry.time) && timedPoint != null) {
                    double d = (timedPoint.pos.east() + timedPoint2.pos.east()) / 2.0;
                    double d2 = (timedPoint.pos.north() + timedPoint2.pos.north()) / 2.0;
                    imageEntry.pos = new EastNorth(d, d2);
                    break;
                }
                timedPoint = timedPoint2;
            }
            if (imageEntry.pos == null) continue;
            imageEntry.coor = Main.proj.eastNorth2latlon(imageEntry.pos);
        }
    }

    private void sync(File file) {
        Date date;
        try {
            date = ExifReader.readTime(file);
        }
        catch (ParseException parseException) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("The date in file \"{0}\" could not be parsed.", file.getName()));
            return;
        }
        if (date == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("There is no EXIF time within the file \"{0}\".", file.getName()));
            return;
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("Image")), GBC.eol());
        jPanel.add((Component)new JLabel(GeoImageLayer.loadScaledImage(file, 300)), GBC.eop());
        jPanel.add((Component)new JLabel(I18n.tr("Enter shown date (mm/dd/yyyy HH:MM:SS)")), GBC.eol());
        JTextField jTextField = new JTextField(dateFormat.format(new Date(date.getTime() + this.delta)));
        jPanel.add((Component)jTextField, GBC.eol().fill(2));
        jPanel.add((Component)new JLabel(I18n.tr("GPS unit timezone (difference to photo)")), GBC.eol());
        String string = Main.pref.get("tagimages.gpstimezone", "0");
        if (string.charAt(0) != '-') {
            string = "+" + string;
        }
        JTextField jTextField2 = new JTextField(string);
        jPanel.add((Component)jTextField2, GBC.eol().fill(2));
        int n;
        while ((n = JOptionPane.showConfirmDialog(Main.parent, jPanel, I18n.tr("Synchronize Time with GPS Unit"), 2)) == 0 && !jTextField.getText().equals("")) {
            try {
                this.delta = DateParser.parse(jTextField.getText()).getTime() - date.getTime();
                String string2 = jTextField2.getText();
                if (!string2.equals("") && string2.charAt(0) == '+') {
                    string2 = string2.substring(1);
                }
                if (string2.equals("")) {
                    string2 = "0";
                }
                this.gpstimezone = Long.valueOf(string2) * 60L * 60L * 1000L;
                Main.pref.put("tagimages.delta", "" + this.delta);
                Main.pref.put("tagimages.gpstimezone", string2);
                this.calculatePosition();
                return;
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Time entered could not be parsed."));
                continue;
            }
            catch (ParseException parseException) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Time entered could not be parsed."));
                continue;
            }
            break;
        }
        return;
    }

    private static Icon loadScaledImage(File file, int n) {
        int n2;
        Image image = Toolkit.getDefaultToolkit().createImage(file.getPath());
        while (image.getWidth(null) < 0 || image.getHeight(null) < 0) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        int n3 = image.getWidth(null);
        if (n3 > (n2 = image.getHeight(null))) {
            n2 = Math.round((float)n * ((float)n2 / (float)n3));
            n3 = n;
        } else {
            n3 = Math.round((float)n * ((float)n3 / (float)n2));
            n2 = n;
        }
        return new ImageIcon(GeoImageLayer.createResizedCopy(image, n3, n2));
    }

    private static BufferedImage createResizedCopy(Image image, int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        while (!graphics2D.drawImage(image, 0, 0, n, n2, null)) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TimedPoint
    implements Comparable<TimedPoint> {
        Date time;
        EastNorth pos;

        public TimedPoint(Date date, EastNorth eastNorth) {
            this.time = date;
            this.pos = eastNorth;
        }

        @Override
        public int compareTo(TimedPoint timedPoint) {
            return this.time.compareTo(timedPoint.time);
        }
    }

    public static final class GpsTimeIncorrect
    extends Exception {
        public GpsTimeIncorrect(String string, Throwable throwable) {
            super(string, throwable);
        }

        public GpsTimeIncorrect(String string) {
            super(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Loader
    extends PleaseWaitRunnable {
        boolean cancelled = false;
        private GeoImageLayer layer;
        private final Collection<File> files;
        private final GpxLayer gpxLayer;

        public Loader(Collection<File> collection, GpxLayer gpxLayer) {
            super(I18n.tr("Images for {0}", gpxLayer.name));
            this.files = collection;
            this.gpxLayer = gpxLayer;
        }

        @Override
        protected void realRun() throws IOException {
            Main.pleaseWaitDlg.currentAction.setText(I18n.tr("Read GPX..."));
            LinkedList<TimedPoint> linkedList = new LinkedList<TimedPoint>();
            for (GpxTrack gpxTrack : this.gpxLayer.data.tracks) {
                for (Collection<WayPoint> object2 : gpxTrack.trackSegs) {
                    for (WayPoint wayPoint : object2) {
                        if (!wayPoint.attr.containsKey("time")) {
                            throw new IOException(I18n.tr("No time for point {0} x {1}", wayPoint.latlon.lat(), wayPoint.latlon.lon()));
                        }
                        Date date = null;
                        try {
                            date = DateParser.parse((String)wayPoint.attr.get("time"));
                        }
                        catch (ParseException parseException) {
                            throw new IOException(I18n.tr("Cannot read time \"{0}\" from point {1} x {2}", wayPoint.attr.get("time"), wayPoint.latlon.lat(), wayPoint.latlon.lon()));
                        }
                        linkedList.add(new TimedPoint(date, wayPoint.eastNorth));
                    }
                }
            }
            if (linkedList.isEmpty()) {
                this.errorMessage = I18n.tr("No images with readable timestamps found.");
                return;
            }
            ArrayList arrayList = new ArrayList(this.files.size());
            int n = 0;
            Main.pleaseWaitDlg.progress.setMaximum(this.files.size());
            for (File file : this.files) {
                if (this.cancelled) break;
                Main.pleaseWaitDlg.currentAction.setText(I18n.tr("Reading {0}...", file.getName()));
                Main.pleaseWaitDlg.progress.setValue(n++);
                ImageEntry imageEntry = new ImageEntry();
                try {
                    imageEntry.time = ExifReader.readTime(file);
                }
                catch (ParseException parseException) {
                    continue;
                }
                if (imageEntry.time == null) continue;
                imageEntry.image = file;
                imageEntry.icon = GeoImageLayer.loadScaledImage(file, 16);
                arrayList.add(imageEntry);
            }
            this.layer = new GeoImageLayer(arrayList, linkedList);
            this.layer.calculatePosition();
        }

        @Override
        protected void finish() {
            if (this.layer != null) {
                Main.main.addLayer(this.layer);
            }
        }

        @Override
        protected void cancel() {
            this.cancelled = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ImageEntry
    implements Comparable<ImageEntry> {
        File image;
        Date time;
        LatLon coor;
        EastNorth pos;
        Icon icon;

        private ImageEntry() {
        }

        @Override
        public int compareTo(ImageEntry imageEntry) {
            return this.time.compareTo(imageEntry.time);
        }
    }
}

