/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.MenuElement;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolbarPreferences
implements PreferenceSetting {
    private Move moveAction = new Move();
    private Map<String, Action> actions = new HashMap<String, Action>();
    private Map<String, Action> regactions = new HashMap<String, Action>();
    private DefaultListModel selected = new DefaultListModel();
    private DefaultMutableTreeNode rootActionsNode = new DefaultMutableTreeNode("Actions");
    private DefaultTreeModel actionsTreeModel = new DefaultTreeModel(this.rootActionsNode);
    private JTree actionsTree = new JTree(this.actionsTreeModel);
    private JList selectedList = new JList(this.selected);
    private String movingComponent;
    public JToolBar control = new JToolBar();
    private JButton upButton;
    private JButton downButton;
    private static final String[] deftoolbar = new String[]{"open", "save", "exportgpx", "|", "download", "upload", "|", "undo", "redo", "|", "preference"};
    private static DataFlavor ACTION_FLAVOR = new DataFlavor(AbstractAction.class, "ActionItem");

    public ToolbarPreferences() {
        this.control.setFloatable(false);
        this.actionsTree.setCellRenderer(new DefaultTreeCellRenderer(){

            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                if (defaultMutableTreeNode.getUserObject() == null) {
                    jLabel.setText(I18n.tr("Separator"));
                    jLabel.setIcon(ImageProvider.get("preferences/separator"));
                } else if (defaultMutableTreeNode.getUserObject() instanceof Action) {
                    Action action = (Action)defaultMutableTreeNode.getUserObject();
                    jLabel.setText((String)action.getValue("Name"));
                    jLabel.setIcon((Icon)action.getValue("SmallIcon"));
                }
                return jLabel;
            }
        });
        DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Icon icon;
                String string;
                Object object2;
                if (object != null) {
                    object2 = ToolbarPreferences.this.getAction((String)object);
                    string = (String)object2.getValue("Name");
                    icon = (Icon)object2.getValue("SmallIcon");
                } else {
                    icon = ImageProvider.get("preferences/separator");
                    string = I18n.tr("Separator");
                }
                object2 = (JLabel)super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
                ((JLabel)object2).setIcon(icon);
                return object2;
            }
        };
        this.selectedList.setCellRenderer(defaultListCellRenderer);
        this.selectedList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                boolean bl;
                boolean bl2 = bl = ToolbarPreferences.this.selectedList.getSelectedIndex() != -1;
                if (bl) {
                    ToolbarPreferences.this.actionsTree.clearSelection();
                }
                ToolbarPreferences.this.upButton.setEnabled(bl);
                ToolbarPreferences.this.downButton.setEnabled(bl);
            }
        });
        this.selectedList.setDragEnabled(true);
        this.selectedList.setTransferHandler(new TransferHandler(){

            protected Transferable createTransferable(JComponent jComponent) {
                return new ActionTransferable(((JList)jComponent).getSelectedValues());
            }

            public int getSourceActions(JComponent jComponent) {
                return 2;
            }

            public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
                for (DataFlavor dataFlavor : dataFlavorArray) {
                    if (!ACTION_FLAVOR.equals(dataFlavor)) continue;
                    return true;
                }
                return false;
            }

            public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
                super.exportAsDrag(jComponent, inputEvent, n);
                ToolbarPreferences.this.movingComponent = "list";
            }

            public boolean importData(JComponent jComponent, Transferable transferable) {
                try {
                    int n;
                    int n2 = ToolbarPreferences.this.selectedList.locationToIndex(ToolbarPreferences.this.selectedList.getMousePosition(true));
                    Object[] objectArray = (Object[])transferable.getTransferData(ACTION_FLAVOR);
                    Object object = n2 >= 0 ? (Object)ToolbarPreferences.this.selected.elementAt(n2) : null;
                    int n3 = objectArray.length;
                    if (object != null) {
                        for (n = 0; n < n3; ++n) {
                            if (!object.equals(objectArray[n])) continue;
                            return false;
                        }
                    }
                    n = -1;
                    boolean bl = "list".equals(ToolbarPreferences.this.movingComponent);
                    if (bl) {
                        n = ToolbarPreferences.this.selected.indexOf(objectArray[0]);
                        for (int i = 0; i < n3; ++i) {
                            ToolbarPreferences.this.selected.removeElement(objectArray[i]);
                        }
                    }
                    int[] nArray = new int[n3];
                    if (bl) {
                        int n4 = ToolbarPreferences.this.selected.indexOf(object);
                        int n5 = n <= n4 ? 1 : 0;
                        for (int i = 0; i < n3; ++i) {
                            ToolbarPreferences.this.selected.insertElementAt(objectArray[i], n4 + n5 + i);
                            nArray[i] = n4 + n5 + i;
                        }
                    } else {
                        for (int i = 0; i < n3; ++i) {
                            ToolbarPreferences.this.selected.add(n2, objectArray[i]);
                            nArray[i] = n2 + i;
                        }
                    }
                    ToolbarPreferences.this.selectedList.clearSelection();
                    ToolbarPreferences.this.selectedList.setSelectedIndices(nArray);
                    ToolbarPreferences.this.movingComponent = "";
                    return true;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return false;
                }
            }

            protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
                if (ToolbarPreferences.this.movingComponent.equals("list")) {
                    try {
                        Object[] objectArray = (Object[])transferable.getTransferData(ACTION_FLAVOR);
                        boolean bl = ToolbarPreferences.this.selected.contains(objectArray[0]);
                        if (bl) {
                            int[] nArray = ToolbarPreferences.this.selectedList.getSelectedIndices();
                            Arrays.sort(nArray);
                            for (int i = nArray.length - 1; i >= 0; --i) {
                                ToolbarPreferences.this.selected.remove(nArray[i]);
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    ToolbarPreferences.this.movingComponent = "";
                }
            }
        });
        this.actionsTree.setTransferHandler(new TransferHandler(){
            private static final long serialVersionUID = 1L;

            public int getSourceActions(JComponent jComponent) {
                return 2;
            }

            protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            }

            protected Transferable createTransferable(JComponent jComponent) {
                TreePath[] treePathArray = ToolbarPreferences.this.actionsTree.getSelectionPaths();
                LinkedList<String> linkedList = new LinkedList<String>();
                for (TreePath treePath : treePathArray) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    Object object = defaultMutableTreeNode.getUserObject();
                    if (object == null) {
                        linkedList.add(null);
                        continue;
                    }
                    if (!(object instanceof Action)) continue;
                    linkedList.add((String)((Action)object).getValue("toolbar"));
                }
                return new ActionTransferable(linkedList.toArray());
            }
        });
        this.actionsTree.setDragEnabled(true);
    }

    @Override
    public void addGui(PreferenceDialog preferenceDialog) {
        final JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("Toolbar")), GBC.eol());
        jPanel.add((Component)new JScrollPane(this.selectedList), GBC.std().fill(1));
        final JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)new JLabel(I18n.tr("Available")), GBC.eol());
        jPanel2.add((Component)new JScrollPane(this.actionsTree), GBC.eol().fill(1));
        final JPanel jPanel3 = new JPanel(new GridLayout(6, 1));
        this.upButton = this.createButton("up");
        jPanel3.add(this.upButton);
        jPanel3.add(this.createButton("<"));
        jPanel3.add(this.createButton(">"));
        this.downButton = this.createButton("down");
        jPanel3.add(this.downButton);
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        final JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new LayoutManager(){

            public void addLayoutComponent(String string, Component component) {
            }

            public void removeLayoutComponent(Component component) {
            }

            public Dimension minimumLayoutSize(Container container) {
                Dimension dimension = jPanel.getMinimumSize();
                Dimension dimension2 = jPanel2.getMinimumSize();
                Dimension dimension3 = jPanel3.getMinimumSize();
                return new Dimension(dimension.width + dimension3.width + 10 + dimension2.width, dimension.height + dimension3.height + 10 + dimension2.height);
            }

            public Dimension preferredLayoutSize(Container container) {
                Dimension dimension = new Dimension(200, 200);
                Dimension dimension2 = new Dimension(200, 200);
                return new Dimension(dimension.width + dimension2.width + 10 + jPanel3.getPreferredSize().width, Math.max(dimension.height, dimension2.height));
            }

            public void layoutContainer(Container container) {
                Dimension dimension = jPanel4.getSize();
                Dimension dimension2 = jPanel3.getPreferredSize();
                int n = (dimension.width - 10 - dimension2.width) / 2;
                jPanel.setBounds(new Rectangle(0, 0, n, dimension.height));
                jPanel2.setBounds(new Rectangle(n + 10 + dimension2.width, 0, n, dimension.height));
                jPanel3.setBounds(new Rectangle(n + 5, dimension.height / 2 - dimension2.height / 2, dimension2.width, dimension2.height));
            }
        });
        jPanel4.add(jPanel);
        jPanel4.add(jPanel3);
        jPanel4.add(jPanel2);
        JPanel jPanel5 = preferenceDialog.createPreferenceTab("toolbar", I18n.tr("Toolbar customization"), I18n.tr("Customize the elements on the toolbar."), false);
        jPanel5.add((Component)jPanel4, GBC.eol().fill(1));
        this.selected.removeAllElements();
        for (String string : this.getToolString()) {
            if (string.equals("|")) {
                this.selected.addElement(null);
                continue;
            }
            if (this.getAction(string) == null) continue;
            this.selected.addElement(string);
        }
    }

    private void loadAction(DefaultMutableTreeNode defaultMutableTreeNode, MenuElement menuElement) {
        Object object = null;
        MenuElement menuElement2 = menuElement;
        if (menuElement.getSubElements().length > 0 && menuElement.getSubElements()[0] instanceof JPopupMenu) {
            menuElement2 = menuElement.getSubElements()[0];
        }
        for (MenuElement menuElement3 : menuElement2.getSubElements()) {
            Serializable serializable;
            if (menuElement3 instanceof JMenuItem) {
                serializable = (JMenuItem)menuElement3;
                if (((AbstractButton)serializable).getAction() != null) {
                    Action action = ((AbstractButton)serializable).getAction();
                    object = action;
                    this.actions.put((String)action.getValue("toolbar"), action);
                } else {
                    object = ((AbstractButton)serializable).getText();
                }
            }
            serializable = new DefaultMutableTreeNode(object);
            defaultMutableTreeNode.add((MutableTreeNode)((Object)serializable));
            this.loadAction((DefaultMutableTreeNode)serializable, menuElement3);
        }
    }

    public Action getAction(String string) {
        Action action = this.actions.get(string);
        if (action == null) {
            action = this.regactions.get(string);
        }
        return action;
    }

    private void loadActions() {
        this.rootActionsNode.removeAllChildren();
        this.loadAction(this.rootActionsNode, Main.main.menu);
        for (Map.Entry<String, Action> entry : this.regactions.entrySet()) {
            if (this.actions.get(entry.getKey()) != null) continue;
            this.rootActionsNode.add(new DefaultMutableTreeNode(entry.getValue()));
        }
        this.rootActionsNode.add(new DefaultMutableTreeNode(null));
        this.actionsTree.updateUI();
        this.actionsTree.setRootVisible(false);
        this.actionsTree.expandPath(new TreePath(this.rootActionsNode));
    }

    private Collection<String> getToolString() {
        return Main.pref.getCollection("toolbar", Arrays.asList(deftoolbar));
    }

    private JButton createButton(String string) {
        JButton jButton = new JButton();
        if (string.equals("up")) {
            jButton.setIcon(ImageProvider.get("dialogs", "up"));
        } else if (string.equals("down")) {
            jButton.setIcon(ImageProvider.get("dialogs", "down"));
        } else {
            jButton.setText(string);
        }
        jButton.addActionListener(this.moveAction);
        jButton.setActionCommand(string);
        return jButton;
    }

    @Override
    public boolean ok() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = 0; i < this.selected.size(); ++i) {
            if (this.selected.get(i) == null) {
                linkedList.add("|");
                continue;
            }
            linkedList.add((String)this.getAction((String)this.selected.get(i)).getValue("toolbar"));
        }
        Main.pref.putCollection("toolbar", linkedList);
        this.refreshToolbarControl();
        return false;
    }

    public Action register(Action action) {
        this.regactions.put((String)action.getValue("toolbar"), action);
        return action;
    }

    public void refreshToolbarControl() {
        this.loadActions();
        this.control.removeAll();
        for (String string : this.getToolString()) {
            if (string.equals("|")) {
                this.control.addSeparator();
                continue;
            }
            this.control.add(this.getAction(string));
        }
        this.control.setVisible(this.control.getComponentCount() != 0);
    }

    private class ActionTransferable
    implements Transferable {
        private DataFlavor[] flavors = new DataFlavor[]{ToolbarPreferences.access$600()};
        private Object[] actions;

        public ActionTransferable(Action action) {
            this.actions = new Action[]{action};
        }

        public ActionTransferable(Object[] objectArray) {
            this.actions = objectArray;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            return this.actions;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return this.flavors[0] == dataFlavor;
        }
    }

    private final class Move
    implements ActionListener {
        private Move() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("<") && ToolbarPreferences.this.actionsTree.getSelectionCount() > 0) {
                int n = ToolbarPreferences.this.selected.getSize();
                if (ToolbarPreferences.this.selectedList.getSelectedIndex() != -1) {
                    int[] objectArray = ToolbarPreferences.this.selectedList.getSelectedIndices();
                    n = objectArray[objectArray.length - 1];
                }
                for (TreePath treePath : ToolbarPreferences.this.actionsTree.getSelectionPaths()) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    if (defaultMutableTreeNode.getUserObject() == null) {
                        ToolbarPreferences.this.selected.add(n++, null);
                        continue;
                    }
                    if (defaultMutableTreeNode.getUserObject() != null && !(defaultMutableTreeNode.getUserObject() instanceof Action)) continue;
                    ToolbarPreferences.this.selected.add(n++, ((Action)defaultMutableTreeNode.getUserObject()).getValue("toolbar"));
                }
            } else if (actionEvent.getActionCommand().equals(">") && ToolbarPreferences.this.selectedList.getSelectedIndex() != -1) {
                while (ToolbarPreferences.this.selectedList.getSelectedIndex() != -1) {
                    ToolbarPreferences.this.selected.remove(ToolbarPreferences.this.selectedList.getSelectedIndex());
                }
            } else if (actionEvent.getActionCommand().equals("up")) {
                int n = ToolbarPreferences.this.selectedList.getSelectedIndex();
                Object e = ToolbarPreferences.this.selected.get(n);
                if (n != 0) {
                    ToolbarPreferences.this.selected.remove(n);
                    ToolbarPreferences.this.selected.add(n - 1, e);
                    ToolbarPreferences.this.selectedList.setSelectedIndex(n - 1);
                }
            } else if (actionEvent.getActionCommand().equals("down")) {
                int n = ToolbarPreferences.this.selectedList.getSelectedIndex();
                Object e = ToolbarPreferences.this.selected.get(n);
                if (n != ToolbarPreferences.this.selected.size() - 1) {
                    ToolbarPreferences.this.selected.remove(n);
                    ToolbarPreferences.this.selected.add(n + 1, e);
                    ToolbarPreferences.this.selectedList.setSelectedIndex(n + 1);
                }
            }
        }
    }
}

