/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class AbstractInfoAction
extends JosmAction {
    public AbstractInfoAction() {
    }

    public AbstractInfoAction(String string, String string2, String string3, Shortcut shortcut, boolean bl) {
        super(string, string2, string3, shortcut, bl);
    }

    protected String getBaseURL() {
        String string = Main.pref.get("osm-server.url", "http://api.openstreetmap.org/api");
        Pattern pattern = Pattern.compile("/api/?$");
        String string2 = pattern.matcher(string).replaceAll("/browse");
        if (string2.equals(string)) {
            System.out.println(I18n.tr("WARNING: unexpected format of API base URL. Redirection to history page for OSM primitive will probably fail. API base URL is: ''{0}''", string));
        }
        if (string2.startsWith("http://api.openstreetmap.org/")) {
            string2 = string2.substring("http://api.openstreetmap.org/".length());
            string2 = "http://www.openstreetmap.org/" + string2;
        }
        return string2;
    }

    protected void launchBrowser() {
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(Main.ds.getSelected());
        Iterator<OsmPrimitive> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().id != 0L) continue;
            iterator.remove();
        }
        if (arrayList.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least one already uploaded node, way, or relation."), I18n.tr("Warning"), 2);
            return;
        }
        int n = Math.min(10, arrayList.size());
        if (n < arrayList.size()) {
            System.out.println(I18n.tr("WARNING: launching browser windows for the first {0} of {1} selected primitives only", 10, arrayList.size()));
        }
        for (int i = 0; i < n; ++i) {
            OpenBrowser.displayUrl(this.createInfoUrl(arrayList.get(i)));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.launchBrowser();
    }

    protected abstract String createInfoUrl(OsmPrimitive var1);
}

