/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class AlignInCircleAction
extends JosmAction {
    public AlignInCircleAction() {
        super(I18n.tr("Align Nodes in Circle"), "aligncircle", I18n.tr("Move the selected nodes into a circle."), Shortcut.registerShortcut("tools:aligncircle", I18n.tr("Tool: {0}", I18n.tr("Align Nodes in Circle")), 79, 3), true);
    }

    public double distance(EastNorth eastNorth, EastNorth eastNorth2) {
        double d = eastNorth.east() - eastNorth2.east();
        double d2 = eastNorth.north() - eastNorth2.north();
        return Math.sqrt(d * d + d2 * d2);
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Serializable serializable;
        Object object;
        Object object2;
        Collection<OsmPrimitive> collection = Main.ds.getSelected();
        LinkedList<Node> linkedList = new LinkedList<Node>();
        LinkedList<Way> linkedList2 = new LinkedList<Way>();
        EastNorth eastNorth = null;
        double d = 0.0;
        boolean bl = false;
        for (OsmPrimitive object32 : collection) {
            if (object32 instanceof Node) {
                linkedList.add((Node)object32);
                continue;
            }
            if (!(object32 instanceof Way)) continue;
            linkedList2.add((Way)object32);
        }
        if (linkedList.size() <= 2 && linkedList2.size() == 1) {
            object2 = (Way)linkedList2.toArray()[0];
            if (linkedList.size() > 0) {
                if (linkedList.size() == 1 && ((Way)object2).nodes.contains(linkedList.toArray()[0])) {
                    bl = true;
                } else {
                    eastNorth = ((Node)linkedList.toArray()[((Way)object2).nodes.contains(linkedList.toArray()[0]) ? 1 : 0]).getEastNorth();
                    if (linkedList.size() == 2) {
                        d = this.distance(((Node)linkedList.toArray()[0]).getEastNorth(), ((Node)linkedList.toArray()[1]).getEastNorth());
                    }
                }
                linkedList = new LinkedList();
            }
            for (Node node : ((Way)object2).nodes) {
                if (linkedList.contains(node)) continue;
                linkedList.add(node);
            }
        }
        if (linkedList.size() < 4) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least four nodes."));
            return;
        }
        if (eastNorth == null) {
            void var10_13;
            void var11_24;
            void var12_31;
            object2 = new BigDecimal("0");
            BigDecimal bigDecimal = new BigDecimal("0");
            BigDecimal bigDecimal2 = new BigDecimal("0");
            boolean bl2 = false;
            while (var12_31 < linkedList.size()) {
                object = ((Node)linkedList.toArray()[var12_31]).getEastNorth();
                Object object3 = ((Node)linkedList.toArray()[(var12_31 + true) % linkedList.size()]).getEastNorth();
                serializable = new BigDecimal(((EastNorth)object).east());
                BigDecimal bigDecimal3 = new BigDecimal(((EastNorth)object).north());
                BigDecimal bigDecimal4 = new BigDecimal(((EastNorth)object3).east());
                BigDecimal bigDecimal5 = new BigDecimal(((EastNorth)object3).north());
                BigDecimal bigDecimal6 = ((BigDecimal)serializable).multiply(bigDecimal5, MathContext.DECIMAL128).subtract(bigDecimal3.multiply(bigDecimal4, MathContext.DECIMAL128));
                object2 = ((BigDecimal)object2).add(bigDecimal6, MathContext.DECIMAL128);
                BigDecimal bigDecimal7 = var11_24.add(bigDecimal6.multiply(((BigDecimal)serializable).add(bigDecimal4, MathContext.DECIMAL128), MathContext.DECIMAL128));
                BigDecimal bigDecimal8 = var10_13.add(bigDecimal6.multiply(bigDecimal3.add(bigDecimal5, MathContext.DECIMAL128), MathContext.DECIMAL128));
                ++var12_31;
            }
            BigDecimal bigDecimal9 = new BigDecimal("2");
            object2 = ((BigDecimal)object2).divide(bigDecimal9, MathContext.DECIMAL128);
            BigDecimal bigDecimal10 = new BigDecimal("6");
            BigDecimal bigDecimal11 = var10_13.divide(bigDecimal10.multiply((BigDecimal)object2, MathContext.DECIMAL128), MathContext.DECIMAL128);
            BigDecimal bigDecimal12 = var11_24.divide(bigDecimal10.multiply((BigDecimal)object2, MathContext.DECIMAL128), MathContext.DECIMAL128);
            eastNorth = new EastNorth(bigDecimal12.doubleValue(), bigDecimal11.doubleValue());
        }
        if (d == 0.0) {
            for (Node node : linkedList) {
                d += this.distance(eastNorth, node.getEastNorth());
            }
            d /= (double)linkedList.size();
        }
        object2 = new LinkedList();
        if (bl) {
            double d2 = Math.PI * 2 / (double)linkedList.size();
            PolarCoor polarCoor = new PolarCoor(((Node)linkedList.toArray()[0]).getEastNorth(), eastNorth, 0.0);
            PolarCoor polarCoor2 = new PolarCoor(((Node)linkedList.toArray()[1]).getEastNorth(), eastNorth, 0.0);
            if (polarCoor.angle > polarCoor2.angle) {
                d2 *= -1.0;
            }
            polarCoor.radius = d;
            for (Object object3 : linkedList) {
                serializable = polarCoor.toEastNorth();
                object2.add(new MoveCommand((OsmPrimitive)object3, ((EastNorth)serializable).east() - ((Node)object3).getEastNorth().east(), ((EastNorth)serializable).north() - ((Node)object3).getEastNorth().north()));
                polarCoor.angle += d2;
            }
        } else {
            for (Node node : linkedList) {
                PolarCoor polarCoor = new PolarCoor(node.getEastNorth(), eastNorth, 0.0);
                polarCoor.radius = d;
                object = polarCoor.toEastNorth();
                object2.add(new MoveCommand(node, ((EastNorth)object).east() - node.getEastNorth().east(), ((EastNorth)object).north() - node.getEastNorth().north()));
            }
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Align Nodes in Circle"), (Collection<Command>)object2));
        Main.map.repaint();
    }

    public class PolarCoor {
        double radius;
        double angle;
        EastNorth origin = new EastNorth(0.0, 0.0);
        double azimuth = 0.0;

        PolarCoor(double d, double d2) {
            this(d, d2, new EastNorth(0.0, 0.0), 0.0);
        }

        PolarCoor(double d, double d2, EastNorth eastNorth, double d3) {
            this.radius = d;
            this.angle = d2;
            this.origin = eastNorth;
            this.azimuth = d3;
        }

        PolarCoor(EastNorth eastNorth) {
            this(eastNorth, new EastNorth(0.0, 0.0), 0.0);
        }

        PolarCoor(EastNorth eastNorth, EastNorth eastNorth2, double d) {
            this.radius = AlignInCircleAction.this.distance(eastNorth, eastNorth2);
            this.angle = Math.atan2(eastNorth.north() - eastNorth2.north(), eastNorth.east() - eastNorth2.east());
            this.origin = eastNorth2;
            this.azimuth = d;
        }

        public EastNorth toEastNorth() {
            return new EastNorth(this.radius * Math.cos(this.angle - this.azimuth) + this.origin.east(), this.radius * Math.sin(this.angle - this.azimuth) + this.origin.north());
        }
    }
}

