/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.UploadAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiInitializationException;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiPreconditionChecker
implements UploadAction.UploadHook {
    @Override
    public boolean checkUpload(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        OsmApi osmApi = OsmApi.getOsmApi();
        try {
            osmApi.initialize();
            long l = 0L;
            if (osmApi.getCapabilities().isDefined("waynodes", "maximum")) {
                l = osmApi.getCapabilities().getLong("waynodes", "maximum");
            }
            long l2 = 0L;
            if (osmApi.getCapabilities().isDefined("changesets", "maximum_elements")) {
                l2 = osmApi.getCapabilities().getLong("changesets", "maximum_elements");
            }
            if (l > 0L) {
                if (!this.checkMaxNodes(collection, l)) {
                    return false;
                }
                if (!this.checkMaxNodes(collection2, l)) {
                    return false;
                }
                if (!this.checkMaxNodes(collection3, l)) {
                    return false;
                }
            }
            if (l2 > 0L) {
                int n = 0;
                n = collection.size() + collection2.size() + collection3.size();
                if ((long)n > l2) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Current number of changes exceeds the max. number of changes, current is {0}, max is {1}", n, l2), I18n.tr("API Capabilities Violation"), 0);
                    return false;
                }
            }
        }
        catch (OsmApiInitializationException osmApiInitializationException) {
            osmApiInitializationException.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Failed to initialize API. Please try again later."), I18n.tr("API initialization failed"), 0);
            return false;
        }
        return true;
    }

    private boolean checkMaxNodes(Collection<OsmPrimitive> collection, long l) {
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive.keys == null) continue;
            for (Map.Entry<String, String> entry : osmPrimitive.keys.entrySet()) {
                if (entry.getValue().length() <= 255) continue;
                if (osmPrimitive.deleted) {
                    System.out.println(I18n.tr("Warning: automatically truncating value of tag ''{0}'' on deleted primitive {1}", entry.getKey(), Long.toString(osmPrimitive.id)));
                    osmPrimitive.put(entry.getKey(), entry.getValue().substring(0, 255));
                    continue;
                }
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Length of value for tag ''{0}'' on primitive {1} exceeds the max. allowed length {2}. Values length is {3}.", entry.getKey(), Long.toString(osmPrimitive.id), 255, entry.getValue().length()), I18n.tr("Precondition Violation"), 0);
                LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
                linkedList.add(osmPrimitive);
                Main.ds.setSelected(linkedList);
                return false;
            }
            if (!(osmPrimitive instanceof Way) || (long)((Way)osmPrimitive).nodes.size() <= l) continue;
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("{0} nodes in way {1} exceed the max. allowed number of nodes {2}", ((Way)osmPrimitive).nodes.size(), Long.toString(osmPrimitive.id), l), I18n.tr("API Capabilities Violation"), 0);
            LinkedList linkedList = new LinkedList();
            linkedList.add(osmPrimitive);
            Main.ds.setSelected(linkedList);
            return false;
        }
        return true;
    }
}

