/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.DontShowAgainInfo;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class OrthogonalizeAction
extends JosmAction {
    public OrthogonalizeAction() {
        super(I18n.tr("Orthogonalize Shape"), "ortho", I18n.tr("Move nodes so all angles are 90 or 270 degree"), Shortcut.registerShortcut("tools:orthogonalize", I18n.tr("Tool: {0}", I18n.tr("Orthogonalize Shape")), 81, 3), true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        Collection<OsmPrimitive> collection = Main.ds.getSelected();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        LinkedList<Command> linkedList = collection.iterator();
        while (linkedList.hasNext()) {
            OsmPrimitive osmPrimitive = linkedList.next();
            if (osmPrimitive instanceof Node) {
                if (arrayList.size() == 2) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Only two nodes allowed"));
                    return;
                }
                arrayList.add((Node)osmPrimitive);
                continue;
            }
            if (!(osmPrimitive instanceof Way)) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Selection must consist only of ways."));
                return;
            }
            Way way = (Way)osmPrimitive;
            if (way.nodes.size() < 5 || !way.nodes.get(0).equals(way.nodes.get(way.nodes.size() - 1))) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select one or more closed ways of at least four nodes."));
                return;
            }
            for (n = 0; n < way.nodes.size() - 1; ++n) {
                double d;
                int n2 = (n + 1) % (way.nodes.size() - 1);
                int n3 = (n + 2) % (way.nodes.size() - 1);
                double d2 = Math.abs(way.nodes.get(n).getEastNorth().heading(way.nodes.get(n2).getEastNorth()));
                double d3 = Math.abs(way.nodes.get(n2).getEastNorth().heading(way.nodes.get(n3).getEastNorth()));
                for (d = Math.abs(d3 - d2); d > Math.PI; d -= Math.PI) {
                }
                if (!(d < 0.7853981633974483)) continue;
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select ways with almost right angles to orthogonalize."));
                return;
            }
        }
        if ("EPSG:4326".equals(((Object)Main.proj).toString()) && !DontShowAgainInfo.show("align_rectangular_4326", (String)((Object)(linkedList = I18n.tr("<html>You are using the EPSG:4326 projection which might lead<br>to undesirable results when doing rectangular alignments.<br>Change your projection to get rid of this warning.<br>Do you want to continue?"))), false)) {
            return;
        }
        if (arrayList.size() == 1) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Only one node selected"));
            return;
        }
        linkedList = new LinkedList<Command>();
        double d = 0.0;
        n = 0;
        if (arrayList.size() == 2) {
            d = OrthogonalizeAction.normalize_angle(((Node)arrayList.get(0)).getEastNorth().heading(((Node)arrayList.get(1)).getEastNorth()));
            n = 1;
        }
        for (OsmPrimitive osmPrimitive : collection) {
            double d4;
            double d5;
            if (!(osmPrimitive instanceof Way)) continue;
            Way way = (Way)osmPrimitive;
            int n4 = way.nodes.size();
            int n5 = n4 - 1;
            EastNorth[] eastNorthArray = new EastNorth[n5];
            for (int i = 0; i < n5; ++i) {
                eastNorthArray[i] = new EastNorth(way.nodes.get(i).getEastNorth().east(), way.nodes.get(i).getEastNorth().north());
            }
            if (n == 0) {
                int n6;
                double[] dArray = new double[n5];
                double[] dArray2 = new double[n5];
                for (int i = 0; i < n5; ++i) {
                    dArray[i] = OrthogonalizeAction.normalize_angle(way.nodes.get(i).getEastNorth().heading(way.nodes.get(i + 1).getEastNorth()));
                    dArray2[i] = way.nodes.get(i).getEastNorth().distance(way.nodes.get(i + 1).getEastNorth());
                }
                double d6 = 0.0;
                for (n6 = 0; n6 < n5; ++n6) {
                    double d7 = 0.0;
                    d7 = n6 == 0 ? OrthogonalizeAction.heading_diff(dArray[n6], dArray[n5 - 1]) : OrthogonalizeAction.heading_diff(dArray[n6], dArray[n6 - 1]);
                    if (!(d7 > d6)) continue;
                    d6 = d7;
                }
                if (d6 > 1.0471975511965976) {
                    for (n6 = 0; n6 < n5; ++n6) {
                        if (!(dArray[n6] < 0.0)) continue;
                        int n7 = n6;
                        dArray[n7] = dArray[n7] + 1.5707963267948966;
                    }
                }
                d5 = 0.0;
                d4 = 0.0;
                for (int i = 0; i < n5; ++i) {
                    d5 += dArray[i] * dArray2[i];
                    d4 += dArray2[i];
                }
                d = OrthogonalizeAction.normalize_angle(d5 / d4);
            }
            for (int i = 0; i < n5; ++i) {
                int n8 = i;
                int n9 = (i + 1) % n5;
                int n10 = (i + 2) % n5;
                d5 = OrthogonalizeAction.normalize_angle(eastNorthArray[n8].heading(eastNorthArray[n9]), d);
                double d8 = d - d5;
                d4 = OrthogonalizeAction.normalize_angle(eastNorthArray[n9].heading(eastNorthArray[n10]), d);
                double d9 = d - d4;
                EastNorth eastNorth = new EastNorth((eastNorthArray[n8].east() + eastNorthArray[n9].east()) / 2.0, (eastNorthArray[n8].north() + eastNorthArray[n9].north()) / 2.0);
                EastNorth eastNorth2 = eastNorthArray[n8].rotate(eastNorth, d8);
                EastNorth eastNorth3 = eastNorthArray[n9].rotate(eastNorth, d8);
                EastNorth eastNorth4 = new EastNorth((eastNorthArray[n9].east() + eastNorthArray[n10].east()) / 2.0, (eastNorthArray[n9].north() + eastNorthArray[n10].north()) / 2.0);
                EastNorth eastNorth5 = eastNorthArray[n9].rotate(eastNorth4, d9);
                EastNorth eastNorth6 = eastNorthArray[n10].rotate(eastNorth4, d9);
                double d10 = OrthogonalizeAction.det(eastNorth3.east() - eastNorth2.east(), eastNorth3.north() - eastNorth2.north(), eastNorth5.east() - eastNorth6.east(), eastNorth5.north() - eastNorth6.north());
                if (d10 == 0.0) continue;
                double d11 = OrthogonalizeAction.det(eastNorth3.north() - eastNorth5.north(), eastNorth3.east() - eastNorth5.east(), eastNorth6.north() - eastNorth5.north(), eastNorth6.east() - eastNorth5.east()) / d10;
                EastNorth eastNorth7 = new EastNorth(eastNorth3.east() + d11 * (eastNorth2.east() - eastNorth3.east()), eastNorth3.north() + d11 * (eastNorth2.north() - eastNorth3.north()));
                Node node = way.nodes.get(n9);
                LatLon latLon = Main.proj.eastNorth2latlon(eastNorth7);
                if (latLon.equalsEpsilon(node.getCoor())) continue;
                double d12 = eastNorth7.east() - node.getEastNorth().east();
                double d13 = eastNorth7.north() - node.getEastNorth().north();
                linkedList.add(new MoveCommand(node, d12, d13));
            }
        }
        if (linkedList.size() > 0) {
            Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Orthogonalize"), linkedList));
            Main.map.repaint();
        }
    }

    static double det(double d, double d2, double d3, double d4) {
        return d * d4 - d2 * d3;
    }

    static double normalize_angle(double d) {
        return OrthogonalizeAction.normalize_angle(d, 0.0);
    }

    static double normalize_angle(double d, double d2) {
        double d3 = -0.7853981633974483;
        double d4 = 0.7853981633974483;
        while (d - d2 > d4) {
            d -= 1.5707963267948966;
        }
        while (d - d2 < d3) {
            d += 1.5707963267948966;
        }
        return d;
    }

    static double heading_diff(double d, double d2) {
        double d3 = d > d2 ? d - d2 : d2 - d;
        return d3;
    }
}

