/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.zip.GZIPOutputStream;
import javax.swing.JOptionPane;
import org.apache.tools.bzip2.CBZip2OutputStream;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.actions.GpxExportAction;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.GpxImporter;
import org.openstreetmap.josm.io.GpxWriter;
import org.openstreetmap.josm.io.OsmBzip2Importer;
import org.openstreetmap.josm.io.OsmGzipImporter;
import org.openstreetmap.josm.io.OsmImporter;
import org.openstreetmap.josm.io.OsmWriter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class SaveActionBase
extends DiskAccessAction {
    private Layer layer;

    public SaveActionBase(String string, String string2, String string3, Shortcut shortcut, Layer layer) {
        super(string, string2, string3, shortcut);
        this.layer = layer;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.doSave();
    }

    public Boolean doSave() {
        Layer layer = this.layer;
        if (layer == null && Main.map != null && (Main.map.mapView.getActiveLayer() instanceof OsmDataLayer || Main.map.mapView.getActiveLayer() instanceof GpxLayer)) {
            layer = Main.map.mapView.getActiveLayer();
        }
        if (layer == null) {
            layer = Main.main.createOrGetEditLayer();
        }
        if (!this.checkSaveConditions(layer)) {
            return false;
        }
        File file = this.getFile(layer);
        if (file == null) {
            return false;
        }
        SaveActionBase.save(file, layer);
        layer.name = file.getName();
        layer.setAssociatedFile(file);
        Main.parent.repaint();
        return true;
    }

    protected abstract File getFile(Layer var1);

    public boolean checkSaveConditions(Layer layer) {
        int n;
        ConflictCollection conflictCollection;
        if (layer == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Internal Error: cannot check conditions for no layer. Please report this as a bug."));
            return false;
        }
        if (Main.map == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No document open so nothing to save."));
            return false;
        }
        if (layer instanceof OsmDataLayer && this.isDataSetEmpty((OsmDataLayer)layer) && 1 != new ExtendedDialog(Main.parent, I18n.tr("Empty document"), I18n.tr("The document contains no data."), new String[]{I18n.tr("Save anyway"), I18n.tr("Cancel")}, new String[]{"save.png", "cancel.png"}).getValue()) {
            return false;
        }
        if (layer instanceof GpxLayer && ((GpxLayer)layer).data == null) {
            return false;
        }
        return !(layer instanceof OsmDataLayer) || (conflictCollection = ((OsmDataLayer)layer).getConflicts()) == null || conflictCollection.isEmpty() || (n = new ExtendedDialog(Main.parent, I18n.tr("Conflicts"), I18n.tr("There are unresolved conflicts. Conflicts will not be saved and handled as if you rejected all. Continue?"), new String[]{I18n.tr("Reject Conflicts and Save"), I18n.tr("Cancel")}, new String[]{"save.png", "cancel.png"}).getValue()) == 1;
    }

    public static File openFileDialog(Layer layer) {
        if (layer instanceof OsmDataLayer) {
            return SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Save OSM file"), ".osm");
        }
        if (layer instanceof GpxLayer) {
            return SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Save GPX file"), ".gpx");
        }
        return SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Save Layer"), ".lay");
    }

    private static void copy(File file, File file2) throws IOException {
        int n;
        FileOutputStream fileOutputStream;
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not back up file.") + "\n" + fileNotFoundException.getMessage());
            return;
        }
        byte[] byArray = new byte[65536];
        while ((n = fileInputStream.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        fileOutputStream.close();
    }

    public static void save(File file, Layer layer) {
        if (layer instanceof GpxLayer) {
            SaveActionBase.save(file, (GpxLayer)layer);
            ((GpxLayer)layer).data.storageFile = file;
        } else if (layer instanceof OsmDataLayer) {
            SaveActionBase.save(file, (OsmDataLayer)layer);
        }
    }

    public static void save(File file, OsmDataLayer osmDataLayer) {
        File file2 = null;
        try {
            GpxImporter gpxImporter = new GpxImporter();
            OsmImporter osmImporter = new OsmImporter();
            OsmGzipImporter osmGzipImporter = new OsmGzipImporter();
            OsmBzip2Importer osmBzip2Importer = new OsmBzip2Importer();
            if (gpxImporter.acceptFile(file)) {
                GpxExportAction.exportGpx(file, osmDataLayer);
            } else if (osmImporter.acceptFile(file) || osmGzipImporter.acceptFile(file) || osmBzip2Importer.acceptFile(file)) {
                if (file.exists()) {
                    file2 = new File(file.getPath() + "~");
                    SaveActionBase.copy(file, file2);
                }
                OutputStream outputStream = new FileOutputStream(file);
                if (osmGzipImporter.acceptFile(file)) {
                    outputStream = new GZIPOutputStream(outputStream);
                } else if (osmBzip2Importer.acceptFile(file)) {
                    outputStream.write(66);
                    outputStream.write(90);
                    outputStream = new CBZip2OutputStream(outputStream);
                }
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
                OsmWriter osmWriter = new OsmWriter(new PrintWriter(outputStreamWriter), false, osmDataLayer.data.version);
                osmWriter.header();
                osmWriter.writeDataSources(osmDataLayer.data);
                osmWriter.writeContent(osmDataLayer.data);
                osmWriter.footer();
                osmWriter.close();
                if (!Main.pref.getBoolean("save.keepbackup") && file2 != null) {
                    file2.delete();
                }
            } else {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Unknown file extension."));
                return;
            }
            osmDataLayer.cleanData(null, false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("An error occurred while saving.") + "\n" + iOException.getMessage());
            try {
                if (file2 != null && file2.exists()) {
                    SaveActionBase.copy(file2, file);
                }
            }
            catch (IOException iOException2) {
                iOException2.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("An error occurred while restoring backup file.") + "\n" + iOException2.getMessage());
            }
        }
    }

    public static void save(File file, GpxLayer gpxLayer) {
        File file2;
        block8: {
            file2 = null;
            try {
                GpxImporter gpxImporter = new GpxImporter();
                if (gpxImporter.acceptFile(file)) {
                    if (file.exists()) {
                        file2 = new File(file.getPath() + "~");
                        SaveActionBase.copy(file, file2);
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    new GpxWriter(fileOutputStream).write(gpxLayer.data);
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    if (!Main.pref.getBoolean("save.keepbackup") && file2 != null) {
                        file2.delete();
                    }
                    break block8;
                }
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Unknown file extension."));
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("An error occurred while saving.") + "\n" + iOException.getMessage());
            }
        }
        try {
            if (file2 != null && file2.exists()) {
                SaveActionBase.copy(file2, file);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("An error occurred while restoring backup file.") + "\n" + iOException.getMessage());
        }
    }

    private boolean isDataSetEmpty(OsmDataLayer osmDataLayer) {
        for (OsmPrimitive osmPrimitive : osmDataLayer.data.allNonDeletedPrimitives()) {
            if (osmPrimitive.deleted && osmPrimitive.id <= 0L) continue;
            return false;
        }
        return true;
    }
}

