/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.NameVisitor;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeCommand
extends Command {
    private final OsmPrimitive osm;
    private final OsmPrimitive newOsm;

    public ChangeCommand(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
        this.osm = osmPrimitive;
        this.newOsm = osmPrimitive2;
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        this.osm.cloneFrom(this.newOsm);
        this.osm.modified = true;
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.add(this.osm);
    }

    @Override
    public MutableTreeNode description() {
        NameVisitor nameVisitor = new NameVisitor();
        this.osm.visit(nameVisitor);
        return new DefaultMutableTreeNode(new JLabel(I18n.tr("Change {0} {1}", I18n.tr(nameVisitor.className), nameVisitor.name), nameVisitor.icon, 0));
    }
}

