/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.visitor.NameVisitor;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeRelationMemberRoleCommand
extends Command {
    private final Relation relation;
    private int position = -1;
    private final String newRole;
    private String oldRole;
    private Boolean oldModified;

    public ChangeRelationMemberRoleCommand(Relation relation, int n, String string) {
        this.relation = relation;
        this.position = n;
        this.newRole = string;
    }

    @Override
    public boolean executeCommand() {
        if (this.position < 0 || this.position >= this.relation.members.size()) {
            Main.debug("error changing the role");
            return false;
        }
        this.oldRole = this.relation.members.get((int)this.position).role;
        this.relation.members.get((int)this.position).role = this.newRole;
        this.oldModified = this.relation.modified;
        this.relation.modified = true;
        return true;
    }

    @Override
    public void undoCommand() {
        this.relation.members.get((int)this.position).role = this.oldRole;
        this.relation.modified = this.oldModified;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.add(this.relation);
    }

    @Override
    public MutableTreeNode description() {
        NameVisitor nameVisitor = new NameVisitor();
        this.relation.visit(nameVisitor);
        return new DefaultMutableTreeNode(new JLabel(I18n.tr("Change relation member role for {0} {1}", I18n.tr(nameVisitor.className), nameVisitor.name), nameVisitor.icon, 0));
    }
}

