/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ConflictResolveCommand;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PurgePrimitivesCommand
extends ConflictResolveCommand {
    private static final Logger logger = Logger.getLogger(PurgePrimitivesCommand.class.getName());
    private OsmPrimitive primitive;
    private ArrayList<OsmPrimitive> purgedPrimitives;
    private ArrayList<OsmParentChildPair> pairs;

    protected List<OsmParentChildPair> getParentChildPairs(List<OsmPrimitive> list, OsmPrimitive osmPrimitive) {
        ArrayList<OsmParentChildPair> arrayList = new ArrayList<OsmParentChildPair>();
        for (OsmPrimitive osmPrimitive2 : list) {
            OsmParentChildPair osmParentChildPair;
            OsmPrimitive osmPrimitive3;
            if (osmPrimitive2 instanceof Way) {
                osmPrimitive3 = (Way)osmPrimitive2;
                for (Node node : osmPrimitive3.nodes) {
                    if (node != osmPrimitive || arrayList.contains(osmParentChildPair = new OsmParentChildPair(osmPrimitive2, node))) continue;
                    arrayList.add(osmParentChildPair);
                }
                continue;
            }
            if (!(osmPrimitive2 instanceof Relation)) continue;
            osmPrimitive3 = (Relation)osmPrimitive2;
            for (RelationMember relationMember : ((Relation)osmPrimitive3).members) {
                if (relationMember.member != osmPrimitive || arrayList.contains(osmParentChildPair = new OsmParentChildPair(osmPrimitive2, relationMember.member))) continue;
                arrayList.add(osmParentChildPair);
            }
        }
        return arrayList;
    }

    public PurgePrimitivesCommand(OsmPrimitive osmPrimitive) {
        this.primitive = osmPrimitive;
        this.purgedPrimitives = new ArrayList();
        this.pairs = new ArrayList();
    }

    @Override
    public MutableTreeNode description() {
        return new DefaultMutableTreeNode(new JLabel(I18n.tr("Purging 1 primitive"), ImageProvider.get("data", "object"), 0));
    }

    protected void purge(OsmPrimitive osmPrimitive, DataSet dataSet, ArrayList<OsmPrimitive> arrayList) {
        ArrayList<OsmPrimitive> arrayList2 = new ArrayList<OsmPrimitive>();
        arrayList2.addAll(Main.ds.ways);
        arrayList2.addAll(Main.ds.relations);
        List<OsmParentChildPair> list = this.getParentChildPairs(arrayList2, this.primitive);
        arrayList.remove(osmPrimitive);
        for (OsmParentChildPair osmParentChildPair : list) {
            OsmPrimitive osmPrimitive2;
            if (osmParentChildPair.getParent() instanceof Way) {
                osmPrimitive2 = (Way)osmParentChildPair.getParent();
                System.out.println(I18n.tr("removing reference from way {0}", ((Way)osmPrimitive2).id));
                ((Way)osmPrimitive2).nodes.remove(this.primitive);
                if (((Way)osmPrimitive2).nodes.size() >= 2) continue;
                System.out.println(I18n.tr("Warning: Purging way {0} because number of nodes dropped below 2. Current is {1}", ((Way)osmPrimitive2).id, ((Way)osmPrimitive2).nodes.size()));
                if (arrayList.contains(osmPrimitive2)) continue;
                arrayList.add(osmPrimitive2);
                continue;
            }
            if (!(osmParentChildPair.getParent() instanceof Relation)) continue;
            osmPrimitive2 = (Relation)osmParentChildPair.getParent();
            System.out.println(I18n.tr("removing reference from relation {0}", ((Relation)osmPrimitive2).id));
            ((Relation)osmPrimitive2).removeMembersFor(this.primitive);
        }
    }

    @Override
    public boolean executeCommand() {
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        arrayList.add(this.primitive);
        while (!arrayList.isEmpty()) {
            OsmPrimitive osmPrimitive = (OsmPrimitive)arrayList.get(0);
            this.purge(osmPrimitive, Main.ds, arrayList);
            if (osmPrimitive instanceof Node) {
                this.getLayer().data.nodes.remove(osmPrimitive);
            } else if (this.primitive instanceof Way) {
                this.getLayer().data.ways.remove(osmPrimitive);
            } else if (this.primitive instanceof Relation) {
                this.getLayer().data.relations.remove(osmPrimitive);
            }
            this.purgedPrimitives.add(osmPrimitive);
            ConflictCollection conflictCollection = this.getLayer().getConflicts();
            if (!conflictCollection.hasConflictForMy(osmPrimitive)) continue;
            this.rememberConflict(conflictCollection.getConflictForMy(osmPrimitive));
            conflictCollection.remove(osmPrimitive);
        }
        return super.executeCommand();
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        for (OsmParentChildPair osmParentChildPair : this.pairs) {
            collection.add(osmParentChildPair.getParent());
        }
        this.pairs = null;
    }

    @Override
    public void undoCommand() {
        if (!Main.map.mapView.hasLayer(this.getLayer())) {
            logger.warning(I18n.tr("Can't undo command ''{0}'' because layer ''{1}'' is not present anymore", this.toString(), this.getLayer().toString()));
            return;
        }
        Main.map.mapView.setActiveLayer(this.getLayer());
        for (OsmPrimitive osmPrimitive : this.purgedPrimitives) {
            this.getLayer().data.addPrimitive(osmPrimitive);
        }
        this.reconstituteConflicts();
        super.undoCommand();
    }

    static class OsmParentChildPair {
        private OsmPrimitive parent;
        private OsmPrimitive child;

        public OsmParentChildPair(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
            this.parent = osmPrimitive;
            this.child = osmPrimitive2;
        }

        public OsmPrimitive getParent() {
            return this.parent;
        }

        public OsmPrimitive getChild() {
            return this.child;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.child == null ? 0 : this.child.hashCode());
            n = 31 * n + (this.parent == null ? 0 : this.parent.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            OsmParentChildPair osmParentChildPair = (OsmParentChildPair)object;
            if (this.child == null ? osmParentChildPair.child != null : this.child != osmParentChildPair.child) {
                return false;
            }
            return !(this.parent == null ? osmParentChildPair.parent != null : this.parent != osmParentChildPair.parent);
        }
    }
}

