/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.AllNodesVisitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RotateCommand
extends Command {
    private Collection<Node> nodes = new LinkedList<Node>();
    private EastNorth pivot;
    private double startAngle;
    private double rotationAngle;
    private Map<Node, OldState> oldState = new HashMap<Node, OldState>();

    public RotateCommand(Collection<OsmPrimitive> collection, EastNorth eastNorth, EastNorth eastNorth2) {
        this.nodes = AllNodesVisitor.getAllNodes(collection);
        this.pivot = new EastNorth(0.0, 0.0);
        for (Node node : this.nodes) {
            OldState oldState = new OldState();
            oldState.latlon = new LatLon(node.getCoor());
            oldState.eastNorth = node.getEastNorth();
            oldState.modified = node.modified;
            this.oldState.put(node, oldState);
            this.pivot = this.pivot.add(oldState.eastNorth.east(), oldState.eastNorth.north());
        }
        this.pivot = new EastNorth(this.pivot.east() / (double)this.nodes.size(), this.pivot.north() / (double)this.nodes.size());
        this.rotationAngle = 1.5707963267948966;
        this.rotateAgain(eastNorth, eastNorth2);
    }

    public void rotateAgain(EastNorth eastNorth, EastNorth eastNorth2) {
        this.startAngle = Math.atan2(eastNorth.east() - this.pivot.east(), eastNorth.north() - this.pivot.north());
        double d = Math.atan2(eastNorth2.east() - this.pivot.east(), eastNorth2.north() - this.pivot.north());
        this.rotationAngle += this.startAngle - d;
        this.rotateNodes(false);
    }

    private void rotateNodes(boolean bl) {
        for (Node node : this.nodes) {
            double d = Math.cos(this.rotationAngle);
            double d2 = Math.sin(this.rotationAngle);
            EastNorth eastNorth = this.oldState.get((Object)node).eastNorth;
            double d3 = eastNorth.east() - this.pivot.east();
            double d4 = eastNorth.north() - this.pivot.north();
            double d5 = d2 * d3 + d * d4 + this.pivot.east();
            double d6 = -d * d3 + d2 * d4 + this.pivot.north();
            node.setEastNorth(new EastNorth(d5, d6));
            if (!bl) continue;
            node.modified = true;
        }
    }

    @Override
    public boolean executeCommand() {
        this.rotateNodes(true);
        return true;
    }

    @Override
    public void undoCommand() {
        for (Node node : this.nodes) {
            OldState oldState = this.oldState.get(node);
            node.setCoor(oldState.latlon);
            node.modified = oldState.modified;
        }
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        for (Node node : this.nodes) {
            collection.add(node);
        }
    }

    @Override
    public MutableTreeNode description() {
        return new DefaultMutableTreeNode(new JLabel(I18n.tr("Rotate {0} {1}", this.nodes.size(), I18n.trn("node", "nodes", this.nodes.size())), ImageProvider.get("data", "node"), 0));
    }

    public Collection<Node> getRotatedNodes() {
        return this.nodes;
    }

    public static class OldState {
        LatLon latlon;
        EastNorth eastNorth;
        boolean modified;
    }
}

