/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.command.ConflictResolveCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionConflictResolveCommand
extends ConflictResolveCommand {
    private Conflict<OsmPrimitive> conflict;

    public VersionConflictResolveCommand(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
        this.conflict = new Conflict<OsmPrimitive>(osmPrimitive, osmPrimitive2);
    }

    @Override
    public MutableTreeNode description() {
        return new DefaultMutableTreeNode(new JLabel(I18n.tr("Resolve version conflicts for {0} {1}", OsmPrimitiveType.from(this.conflict.getMy()).getLocalizedDisplayNameSingular(), this.conflict.getMy().id), ImageProvider.get("data", "object"), 0));
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        this.conflict.getMy().version = Math.max(this.conflict.getMy().version, this.conflict.getTheir().version);
        this.getLayer().getConflicts().remove(this.conflict);
        this.rememberConflict(this.conflict);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.add(this.conflict.getMy());
    }
}

