/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.corrector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.corrector.RoleCorrection;
import org.openstreetmap.josm.corrector.TagCorrection;
import org.openstreetmap.josm.corrector.TagCorrector;
import org.openstreetmap.josm.corrector.UserCancelException;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReverseWayTagCorrector
extends TagCorrector<Way> {
    private static PrefixSuffixSwitcher[] prefixSuffixSwitchers = new PrefixSuffixSwitcher[]{new PrefixSuffixSwitcher("left", "right"), new PrefixSuffixSwitcher("forward", "backward"), new PrefixSuffixSwitcher("forwards", "backwards")};

    @Override
    public Collection<Command> execute(Way way, Way way2) throws UserCancelException {
        Object object;
        HashMap<OsmPrimitive, List<TagCorrection>> hashMap = new HashMap<OsmPrimitive, List<TagCorrection>>();
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        arrayList.add(way2);
        arrayList.addAll(way2.nodes);
        for (OsmPrimitive object2 : arrayList) {
            hashMap.put(object2, new ArrayList());
            for (String string : object2.keySet()) {
                String string2;
                String string3;
                Object object3;
                block10: {
                    Object object4;
                    block8: {
                        block9: {
                            object3 = string;
                            string2 = string3 = object2.get(string);
                            if (!string.equals("oneway")) break block8;
                            if (!string3.equals("-1")) break block9;
                            string2 = "yes";
                            break block10;
                        }
                        object = OsmUtils.getOsmBoolean(string3);
                        if (object == null || !((Boolean)object).booleanValue()) break block10;
                        string2 = "-1";
                        break block10;
                    }
                    object = prefixSuffixSwitchers;
                    int n = ((PrefixSuffixSwitcher[])object).length;
                    for (int i = 0; i < n && string.equals(object3 = ((PrefixSuffixSwitcher)(object4 = object[i])).apply(string)); ++i) {
                    }
                }
                if (string.equals(object3) && string3.equals(string2)) continue;
                ((List)hashMap.get(object2)).add(new TagCorrection(string, string3, (String)object3, string2));
            }
        }
        HashMap hashMap2 = new HashMap();
        hashMap2.put(way2, new ArrayList());
        for (Relation relation : Main.ds.relations) {
            int n = 0;
            for (RelationMember relationMember : relation.members) {
                if (!relationMember.member.hasEqualSemanticAttributes(way) || relationMember.role.length() == 0) {
                    ++n;
                    continue;
                }
                boolean bl = false;
                object = null;
                for (PrefixSuffixSwitcher prefixSuffixSwitcher : prefixSuffixSwitchers) {
                    object = prefixSuffixSwitcher.apply(relationMember.role);
                    if (((String)object).equals(relationMember.role)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    ((List)hashMap2.get(way2)).add(new RoleCorrection(relation, n, relationMember, (String)object));
                }
                ++n;
            }
        }
        return this.applyCorrections(hashMap, hashMap2, I18n.tr("When reversing this way, the following changes to properties of the way and its nodes are suggested in order to maintain data consistency."));
    }

    private static class PrefixSuffixSwitcher {
        private final String a;
        private final String b;
        private final Pattern startPattern;
        private final Pattern endPattern;
        private final String SEPARATOR = "[:_]?";

        public PrefixSuffixSwitcher(String string, String string2) {
            this.a = string;
            this.b = string2;
            this.startPattern = Pattern.compile("^(" + string + "|" + string2 + ")(" + "[:_]?" + "|$)", 2);
            this.endPattern = Pattern.compile("^.*[:_]?(" + string + "|" + string2 + ")$", 2);
        }

        public String apply(String string) {
            Matcher matcher = this.startPattern.matcher(string);
            if (!matcher.lookingAt()) {
                matcher = this.endPattern.matcher(string);
            }
            if (matcher.lookingAt()) {
                String string2 = matcher.group(1).toLowerCase();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string.substring(0, matcher.start(1)));
                stringBuilder.append(string2.equals(this.a) ? this.b : this.a);
                stringBuilder.append(string.substring(matcher.end(1)));
                return stringBuilder.toString();
            }
            return string;
        }
    }
}

