/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OsmPrimitive
implements Comparable<OsmPrimitive> {
    public Map<String, String> keys;
    public ElemStyle mappaintStyle = null;
    public Integer mappaintVisibleCode = 0;
    public Integer mappaintDrawnCode = 0;
    public Collection<String> errors;
    public long id = 0L;
    public boolean modified = false;
    public boolean deleted = false;
    public boolean visible = true;
    public User user = null;
    public volatile boolean selected = false;
    public volatile boolean highlighted = false;
    private int timestamp;
    public boolean incomplete = false;
    public int version = -1;
    private static Collection<String> uninteresting = null;
    private static Collection<String> directionKeys = null;

    public void putError(String string, Boolean bl) {
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        String string2 = bl != false ? I18n.tr("Error: {0}", string) : I18n.tr("Warning: {0}", string);
        this.errors.add(string2);
    }

    public void clearErrors() {
        this.errors = null;
    }

    protected void clearCached() {
        this.mappaintVisibleCode = 0;
        this.mappaintDrawnCode = 0;
        this.mappaintStyle = null;
    }

    public void setTimestamp(Date date) {
        this.timestamp = (int)(date.getTime() / 1000L);
    }

    public Date getTimestamp() {
        return new Date((long)this.timestamp * 1000L);
    }

    public boolean isTimestampEmpty() {
        return this.timestamp == 0;
    }

    public static Collection<String> getUninterestingKeys() {
        if (uninteresting == null) {
            uninteresting = Main.pref.getCollection("tags.uninteresting", Arrays.asList("source", "note", "comment", "converted_by", "created_by"));
        }
        return uninteresting;
    }

    public static Collection<String> getDirectionKeys() {
        if (directionKeys == null) {
            directionKeys = Main.pref.getCollection("tags.direction", Arrays.asList("oneway", "incline", "incline_steep", "aerialway"));
        }
        return directionKeys;
    }

    public abstract void visit(Visitor var1);

    public final void delete(boolean bl) {
        this.deleted = bl;
        this.selected = false;
        this.modified = true;
    }

    public boolean equals(Object object) {
        if (this.id == 0L) {
            return object == this;
        }
        if (object instanceof OsmPrimitive) {
            return ((OsmPrimitive)object).id == this.id && object.getClass() == this.getClass();
        }
        return false;
    }

    public final int hashCode() {
        if (this.id == 0L) {
            return super.hashCode();
        }
        final int[] nArray = new int[1];
        Visitor visitor = new Visitor(){

            public void visit(Node node) {
                nArray[0] = 0;
            }

            public void visit(Way way) {
                nArray[0] = 1;
            }

            public void visit(Relation relation) {
                nArray[0] = 2;
            }

            public void visit(Changeset changeset) {
                nArray[0] = 3;
            }
        };
        this.visit(visitor);
        return this.id == 0L ? super.hashCode() : (int)(this.id << 2) + nArray[0];
    }

    public final void put(String string, String string2) {
        if (string2 == null) {
            this.remove(string);
        } else {
            if (this.keys == null) {
                this.keys = new HashMap<String, String>();
            }
            this.keys.put(string, string2);
        }
        this.mappaintStyle = null;
    }

    public final void remove(String string) {
        if (this.keys != null) {
            this.keys.remove(string);
            if (this.keys.isEmpty()) {
                this.keys = null;
            }
        }
        this.mappaintStyle = null;
    }

    public String getName() {
        return null;
    }

    public final String get(String string) {
        return this.keys == null ? null : this.keys.get(string);
    }

    public final Collection<Map.Entry<String, String>> entrySet() {
        if (this.keys == null) {
            return Collections.emptyList();
        }
        return this.keys.entrySet();
    }

    public final Collection<String> keySet() {
        if (this.keys == null) {
            return Collections.emptyList();
        }
        return this.keys.keySet();
    }

    public void cloneFrom(OsmPrimitive osmPrimitive) {
        this.keys = osmPrimitive.keys == null ? null : new HashMap<String, String>(osmPrimitive.keys);
        this.id = osmPrimitive.id;
        this.modified = osmPrimitive.modified;
        this.deleted = osmPrimitive.deleted;
        this.selected = osmPrimitive.selected;
        this.timestamp = osmPrimitive.timestamp;
        this.version = osmPrimitive.version;
        this.incomplete = osmPrimitive.incomplete;
        this.visible = osmPrimitive.visible;
        this.clearCached();
        this.clearErrors();
    }

    public boolean hasEqualSemanticAttributes(OsmPrimitive osmPrimitive) {
        if (this.id != osmPrimitive.id) {
            return false;
        }
        if (this.incomplete && !osmPrimitive.incomplete || !this.incomplete && osmPrimitive.incomplete) {
            return false;
        }
        return this.keys == null ? osmPrimitive.keys == null : ((Object)this.keys).equals(osmPrimitive.keys);
    }

    public boolean hasEqualTechnicalAttributes(OsmPrimitive osmPrimitive) {
        if (osmPrimitive == null) {
            return false;
        }
        return this.deleted == osmPrimitive.deleted && this.modified == osmPrimitive.modified && this.timestamp == osmPrimitive.timestamp && this.version == osmPrimitive.version && this.visible == osmPrimitive.visible && (this.user == null ? osmPrimitive.user == null : this.user == osmPrimitive.user);
    }

    public boolean isTagged() {
        OsmPrimitive.getUninterestingKeys();
        if (this.keys != null) {
            for (Map.Entry<String, String> entry : this.keys.entrySet()) {
                if (uninteresting.contains(entry.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasDirectionKeys() {
        OsmPrimitive.getDirectionKeys();
        if (this.keys != null) {
            for (Map.Entry<String, String> entry : this.keys.entrySet()) {
                if (!directionKeys.contains(entry.getKey())) continue;
                return true;
            }
        }
        return false;
    }
}

