/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class History {
    private ArrayList<HistoryOsmPrimitive> versions;
    long id;

    private static History filter(History history, FilterPredicate filterPredicate) {
        ArrayList<HistoryOsmPrimitive> arrayList = new ArrayList<HistoryOsmPrimitive>();
        for (HistoryOsmPrimitive historyOsmPrimitive : history.versions) {
            if (!filterPredicate.matches(historyOsmPrimitive)) continue;
            arrayList.add(historyOsmPrimitive);
        }
        return new History(history.id, arrayList);
    }

    protected History(long l, List<HistoryOsmPrimitive> list) {
        this.id = l;
        this.versions = new ArrayList();
        this.versions.addAll(list);
    }

    public History sortAscending() {
        ArrayList<HistoryOsmPrimitive> arrayList = new ArrayList<HistoryOsmPrimitive>(this.versions);
        Collections.sort(arrayList, new Comparator<HistoryOsmPrimitive>(){

            @Override
            public int compare(HistoryOsmPrimitive historyOsmPrimitive, HistoryOsmPrimitive historyOsmPrimitive2) {
                return historyOsmPrimitive.compareTo(historyOsmPrimitive2);
            }
        });
        return new History(this.id, arrayList);
    }

    public History sortDescending() {
        ArrayList<HistoryOsmPrimitive> arrayList = new ArrayList<HistoryOsmPrimitive>(this.versions);
        Collections.sort(arrayList, new Comparator<HistoryOsmPrimitive>(){

            @Override
            public int compare(HistoryOsmPrimitive historyOsmPrimitive, HistoryOsmPrimitive historyOsmPrimitive2) {
                return historyOsmPrimitive2.compareTo(historyOsmPrimitive);
            }
        });
        return new History(this.id, arrayList);
    }

    public History from(final Date date) {
        return History.filter(this, new FilterPredicate(){

            public boolean matches(HistoryOsmPrimitive historyOsmPrimitive) {
                return historyOsmPrimitive.getTimestamp().compareTo(date) >= 0;
            }
        });
    }

    public History until(final Date date) {
        return History.filter(this, new FilterPredicate(){

            public boolean matches(HistoryOsmPrimitive historyOsmPrimitive) {
                return historyOsmPrimitive.getTimestamp().compareTo(date) <= 0;
            }
        });
    }

    public History between(Date date, Date date2) {
        return this.from(date).until(date2);
    }

    public History from(final long l) {
        return History.filter(this, new FilterPredicate(){

            public boolean matches(HistoryOsmPrimitive historyOsmPrimitive) {
                return historyOsmPrimitive.getVersion() >= l;
            }
        });
    }

    public History until(final long l) {
        return History.filter(this, new FilterPredicate(){

            public boolean matches(HistoryOsmPrimitive historyOsmPrimitive) {
                return historyOsmPrimitive.getVersion() <= l;
            }
        });
    }

    public History between(long l, long l2) {
        return this.from(l).until(l2);
    }

    public History forUser(final String string) {
        return History.filter(this, new FilterPredicate(){

            public boolean matches(HistoryOsmPrimitive historyOsmPrimitive) {
                return historyOsmPrimitive.getUser().equals(string);
            }
        });
    }

    public History forUserId(final long l) {
        return History.filter(this, new FilterPredicate(){

            public boolean matches(HistoryOsmPrimitive historyOsmPrimitive) {
                return historyOsmPrimitive.getUid() == l;
            }
        });
    }

    public long getId() {
        return this.id;
    }

    public boolean contains(long l) {
        for (HistoryOsmPrimitive historyOsmPrimitive : this.versions) {
            if (!historyOsmPrimitive.matches(this.id, l)) continue;
            return true;
        }
        return false;
    }

    public HistoryOsmPrimitive getByVersion(long l) {
        for (HistoryOsmPrimitive historyOsmPrimitive : this.versions) {
            if (!historyOsmPrimitive.matches(this.id, l)) continue;
            return historyOsmPrimitive;
        }
        throw new NoSuchElementException(I18n.tr("There's no primitive with version {0} in this history", l));
    }

    public HistoryOsmPrimitive getByDate(Date date) {
        this.sortAscending();
        if (this.versions.isEmpty()) {
            throw new NoSuchElementException(I18n.tr("There's no version valid at date ''{0}'' in this history", date));
        }
        if (this.get(0).getTimestamp().compareTo(date) > 0) {
            throw new NoSuchElementException(I18n.tr("There's no version valid at date ''{0}'' in this history", date));
        }
        for (int i = 1; i < this.versions.size(); ++i) {
            if (this.get(i - 1).getTimestamp().compareTo(date) > 0 || this.get(i).getTimestamp().compareTo(date) < 0) continue;
            return this.get(i);
        }
        return this.getLatest();
    }

    public HistoryOsmPrimitive get(int n) {
        if (n < 0 || n >= this.versions.size()) {
            throw new IndexOutOfBoundsException(I18n.tr("parameter ''{0}'' in range 0..{1} expected, got {2}", "idx", this.versions.size() - 1, n));
        }
        return this.versions.get(n);
    }

    public HistoryOsmPrimitive getEarliest() {
        if (this.isEmpty()) {
            throw new NoSuchElementException(I18n.tr("no earliest version found. History is empty."));
        }
        return this.sortAscending().versions.get(0);
    }

    public HistoryOsmPrimitive getLatest() {
        if (this.isEmpty()) {
            throw new NoSuchElementException(I18n.tr("no latest version found. History is empty."));
        }
        return this.sortDescending().versions.get(0);
    }

    public int getNumVersions() {
        return this.versions.size();
    }

    public boolean isEmpty() {
        return this.versions.isEmpty();
    }

    private static interface FilterPredicate {
        public boolean matches(HistoryOsmPrimitive var1);
    }
}

