/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.RelationMember;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryRelation
extends HistoryOsmPrimitive {
    private ArrayList<RelationMember> members = new ArrayList();

    public HistoryRelation(long l, long l2, boolean bl, String string, long l3, long l4, Date date) throws IllegalArgumentException {
        super(l, l2, bl, string, l3, l4, date);
    }

    public HistoryRelation(long l, long l2, boolean bl, String string, long l3, long l4, Date date, ArrayList<RelationMember> arrayList) {
        this(l, l2, bl, string, l3, l4, date);
        if (arrayList != null) {
            this.members.addAll(arrayList);
        }
    }

    public List<RelationMember> getMembers() {
        return Collections.unmodifiableList(this.members);
    }

    public int getNumMembers() {
        return this.members.size();
    }

    public RelationMember getRelationMember(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.members.size()) {
            throw new IndexOutOfBoundsException(I18n.tr("parameter {0} not in range 0..{1}, got {2}", "idx", this.members.size(), n));
        }
        return this.members.get(n);
    }

    @Override
    public OsmPrimitiveType getType() {
        return OsmPrimitiveType.RELATION;
    }

    public void addMember(RelationMember relationMember) throws IllegalArgumentException {
        if (relationMember == null) {
            throw new IllegalArgumentException(I18n.tr("parameter ''{0}'' must not be null", "member"));
        }
        this.members.add(relationMember);
    }
}

