/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;

public class BoundingXYVisitor
extends AbstractVisitor {
    private ProjectionBounds bounds = null;

    public void visit(Node node) {
        this.visit(node.getEastNorth());
    }

    public void visit(Way way) {
        way.visitNodes(this);
    }

    public void visit(Relation relation) {
        for (RelationMember relationMember : relation.members) {
            if (relationMember.member instanceof Relation) continue;
            relationMember.member.visit(this);
        }
    }

    public void visit(Bounds bounds) {
        if (bounds != null) {
            this.visit(bounds.min);
            this.visit(bounds.max);
        }
    }

    public void visit(ProjectionBounds projectionBounds) {
        if (projectionBounds != null) {
            this.visit(projectionBounds.min);
            this.visit(projectionBounds.max);
        }
    }

    public void visit(LatLon latLon) {
        if (latLon != null) {
            if (latLon instanceof CachedLatLon) {
                this.visit(((CachedLatLon)latLon).getEastNorth());
            } else {
                this.visit(Main.proj.latlon2eastNorth(latLon));
            }
        }
    }

    public void visit(EastNorth eastNorth) {
        if (eastNorth != null) {
            if (this.bounds == null) {
                this.bounds = new ProjectionBounds(eastNorth);
            } else {
                this.bounds.extend(eastNorth);
            }
        }
    }

    public boolean hasExtend() {
        return this.bounds != null && !this.bounds.min.equals(this.bounds.max);
    }

    public ProjectionBounds getBounds() {
        return this.bounds;
    }

    public void enlargeBoundingBox() {
        this.enlargeBoundingBox(0.002);
    }

    public void enlargeBoundingBox(double d) {
        if (this.bounds == null) {
            return;
        }
        LatLon latLon = Main.proj.eastNorth2latlon(this.bounds.min);
        LatLon latLon2 = Main.proj.eastNorth2latlon(this.bounds.max);
        this.bounds = new ProjectionBounds(Main.proj.latlon2eastNorth(new LatLon(latLon.lat() - d, latLon.lon() - d)), Main.proj.latlon2eastNorth(new LatLon(latLon2.lat() + d, latLon2.lon() + d)));
    }

    public String toString() {
        return "BoundingXYVisitor[" + this.bounds + "]";
    }
}

