/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public abstract class PleaseWaitRunnable
implements Runnable {
    public boolean silent = false;
    public String errorMessage;
    private boolean closeDialogCalled = false;
    private boolean cancelled = false;
    private boolean ignoreException;
    private final String title;
    private ActionListener cancelListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            if (!PleaseWaitRunnable.this.cancelled) {
                PleaseWaitRunnable.this.cancelled = true;
                PleaseWaitRunnable.this.cancel();
            }
        }
    };
    private WindowListener windowListener = new WindowAdapter(){

        public void windowClosing(WindowEvent windowEvent) {
            if (!PleaseWaitRunnable.this.closeDialogCalled) {
                if (!PleaseWaitRunnable.this.cancelled) {
                    PleaseWaitRunnable.this.cancelled = true;
                    PleaseWaitRunnable.this.cancel();
                }
                PleaseWaitRunnable.this.closeDialog();
            }
        }
    };

    public PleaseWaitRunnable(String string) {
        this(string, false);
    }

    public PleaseWaitRunnable(String string, boolean bl) {
        this.title = string;
        this.ignoreException = bl;
    }

    private void prepareDialog() {
        this.errorMessage = null;
        this.closeDialogCalled = false;
        Main.pleaseWaitDlg.setTitle(this.title);
        Main.pleaseWaitDlg.cancel.setEnabled(true);
        Main.pleaseWaitDlg.setCustomText("");
        Main.pleaseWaitDlg.cancel.addActionListener(this.cancelListener);
        Main.pleaseWaitDlg.addWindowListener(this.windowListener);
        Main.pleaseWaitDlg.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRealRun() {
        block13: {
            try {
                try {
                    this.realRun();
                }
                catch (SAXException sAXException) {
                    sAXException.printStackTrace();
                    this.errorMessage = I18n.tr("Error while parsing") + ": " + sAXException.getMessage();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                    this.errorMessage = I18n.tr("File not found") + ": " + fileNotFoundException.getMessage();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    this.errorMessage = iOException.getMessage();
                }
                catch (OsmTransferException osmTransferException) {
                    osmTransferException.printStackTrace();
                    this.errorMessage = osmTransferException.getCause() != null ? osmTransferException.getCause().getMessage() : osmTransferException.getMessage();
                }
                finally {
                    this.closeDialog();
                }
            }
            catch (Throwable throwable) {
                if (this.ignoreException) break block13;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        throw new RuntimeException(throwable);
                    }
                });
            }
        }
    }

    public final void run() {
        if (this.cancelled) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            new Thread(new Runnable(){

                public void run() {
                    PleaseWaitRunnable.this.doRealRun();
                }
            }).start();
            this.prepareDialog();
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    PleaseWaitRunnable.this.prepareDialog();
                }
            });
            this.doRealRun();
        }
    }

    protected abstract void cancel();

    protected abstract void realRun() throws SAXException, IOException, OsmTransferException;

    protected abstract void finish();

    public void closeDialog() {
        if (this.closeDialogCalled) {
            return;
        }
        this.closeDialogCalled = true;
        try {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        PleaseWaitRunnable.this.finish();
                    }
                    finally {
                        Main.pleaseWaitDlg.setVisible(false);
                        Main.pleaseWaitDlg.dispose();
                        Main.pleaseWaitDlg.removeWindowListener(PleaseWaitRunnable.this.windowListener);
                        Main.pleaseWaitDlg.cancel.removeActionListener(PleaseWaitRunnable.this.cancelListener);
                    }
                    if (PleaseWaitRunnable.this.errorMessage != null && !PleaseWaitRunnable.this.silent) {
                        JOptionPane.showMessageDialog(Main.parent, PleaseWaitRunnable.this.errorMessage);
                    }
                }
            };
            if (EventQueue.isDispatchThread()) {
                runnable.run();
            } else {
                EventQueue.invokeAndWait(runnable);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
    }
}

