/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.relation;

import java.awt.Color;
import java.awt.Component;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.conflict.ListMergeModel;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationMemberTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private static final DecimalFormat COORD_FORMATTER = new DecimalFormat("###0.0000");
    public static final Color BGCOLOR_SELECTED = new Color(143, 170, 255);
    public static final Color BGCOLOR_EMPTY_ROW = new Color(234, 234, 234);
    public static final Color BGCOLOR_NOT_IN_OPPOSITE = new Color(255, 197, 197);
    public static final Color BGCOLOR_IN_OPPOSITE = new Color(255, 234, 213);
    public static final Color BGCOLOR_SAME_POSITION_IN_OPPOSITE = new Color(217, 255, 217);
    public static final Color BGCOLOR_PARTICIPAING_IN_COMPARISON = Color.BLACK;
    public static final Color FGCOLOR_PARTICIPAING_IN_COMPARISON = Color.WHITE;
    public static final Color BGCOLOR_FROZEN = new Color(234, 234, 234);
    private ImageIcon nodeIcon;
    private ImageIcon wayIcon;
    private ImageIcon relationIcon;
    private Border rowNumberBorder = null;

    protected void loadIcons() {
        this.nodeIcon = ImageProvider.get("data", "node");
        this.wayIcon = ImageProvider.get("data", "way");
        this.relationIcon = ImageProvider.get("data", "relation");
    }

    public RelationMemberTableCellRenderer() {
        this.setIcon(null);
        this.setOpaque(true);
        this.loadIcons();
        this.rowNumberBorder = BorderFactory.createEmptyBorder(0, 4, 0, 0);
    }

    public String buildToolTipText(OsmPrimitive osmPrimitive) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("<strong>id</strong>=").append(osmPrimitive.id).append("<br>");
        ArrayList<String> arrayList = new ArrayList<String>(osmPrimitive.keySet());
        Collections.sort(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i > 0) {
                stringBuilder.append("<br>");
            }
            String string = arrayList.get(i);
            stringBuilder.append("<strong>").append(string).append("</strong>").append("=");
            String string2 = osmPrimitive.get(string);
            while (string2.length() != 0) {
                stringBuilder.append(string2.substring(0, Math.min(50, string2.length())));
                if (string2.length() > 50) {
                    stringBuilder.append("<br>");
                    string2 = string2.substring(50);
                    continue;
                }
                string2 = "";
            }
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    protected String getDisplayName(RelationMember relationMember) {
        StringBuilder stringBuilder = new StringBuilder();
        OsmPrimitive osmPrimitive = relationMember.member;
        if (osmPrimitive.get("name") != null) {
            stringBuilder.append(osmPrimitive.get("name"));
            stringBuilder.append("/");
            stringBuilder.append(osmPrimitive.id);
        } else {
            stringBuilder.append(osmPrimitive.id);
        }
        if (osmPrimitive instanceof Node) {
            Node node = (Node)osmPrimitive;
            stringBuilder.append(" (");
            if (node.getCoor() != null) {
                stringBuilder.append(COORD_FORMATTER.format(node.getCoor().lat()));
                stringBuilder.append(",");
                stringBuilder.append(COORD_FORMATTER.format(node.getCoor().lon()));
            } else {
                stringBuilder.append("?,?");
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    protected void reset() {
        this.setBackground(Color.WHITE);
        this.setForeground(Color.BLACK);
        this.setBorder(null);
        this.setIcon(null);
        this.setToolTipText(null);
    }

    protected void renderBackground(ListMergeModel.EntriesTableModel entriesTableModel, RelationMember relationMember, int n, int n2, boolean bl) {
        Color color = Color.WHITE;
        if (n2 == 0) {
            if (entriesTableModel.getListMergeModel().isFrozen()) {
                color = BGCOLOR_FROZEN;
            } else if (entriesTableModel.isParticipatingInCurrentComparePair()) {
                color = BGCOLOR_PARTICIPAING_IN_COMPARISON;
            } else if (bl) {
                color = BGCOLOR_SELECTED;
            }
        } else if (entriesTableModel.getListMergeModel().isFrozen()) {
            color = BGCOLOR_FROZEN;
        } else if (relationMember == null) {
            color = BGCOLOR_EMPTY_ROW;
        } else if (bl) {
            color = BGCOLOR_SELECTED;
        } else if (entriesTableModel.isParticipatingInCurrentComparePair()) {
            color = entriesTableModel.isSamePositionInOppositeList(n) ? BGCOLOR_SAME_POSITION_IN_OPPOSITE : (entriesTableModel.isIncludedInOppositeList(n) ? BGCOLOR_IN_OPPOSITE : BGCOLOR_NOT_IN_OPPOSITE);
        }
        this.setBackground(color);
    }

    protected void renderForeground(ListMergeModel.EntriesTableModel entriesTableModel, RelationMember relationMember, int n, int n2, boolean bl) {
        Color color = Color.BLACK;
        if (n2 == 0 && entriesTableModel.isParticipatingInCurrentComparePair() && !entriesTableModel.getListMergeModel().isFrozen()) {
            color = Color.WHITE;
        }
        this.setForeground(color);
    }

    protected void renderRole(RelationMember relationMember) {
        this.setText(relationMember.role == null ? "" : relationMember.role);
        this.setToolTipText(relationMember.role == null ? "" : relationMember.role);
    }

    protected void renderPrimitive(RelationMember relationMember) {
        String string = this.getDisplayName(relationMember);
        this.setText(string);
        this.setToolTipText(this.buildToolTipText(relationMember.member));
        if (relationMember.member instanceof Node) {
            this.setIcon(this.nodeIcon);
        } else if (relationMember.member instanceof Way) {
            this.setIcon(this.wayIcon);
        } else if (relationMember.member instanceof Relation) {
            this.setIcon(this.relationIcon);
        } else {
            this.setIcon(null);
        }
    }

    protected void renderRowId(int n) {
        this.setBorder(this.rowNumberBorder);
        this.setText(Integer.toString(n + 1));
    }

    protected void renderEmptyRow() {
        this.setIcon(null);
        this.setBackground(BGCOLOR_EMPTY_ROW);
        this.setText("");
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        RelationMember relationMember = (RelationMember)object;
        this.reset();
        this.renderBackground(this.getModel(jTable), relationMember, n, n2, bl);
        this.renderForeground(this.getModel(jTable), relationMember, n, n2, bl);
        switch (n2) {
            case 0: {
                this.renderRowId(n);
                break;
            }
            case 1: {
                if (relationMember == null) {
                    this.renderEmptyRow();
                    break;
                }
                this.renderRole(relationMember);
                break;
            }
            case 2: {
                if (relationMember == null) {
                    this.renderEmptyRow();
                    break;
                }
                this.renderPrimitive(relationMember);
                break;
            }
        }
        return this;
    }

    protected ListMergeModel.EntriesTableModel getModel(JTable jTable) {
        return (ListMergeModel.EntriesTableModel)jTable.getModel();
    }
}

