/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.DataChangeListener;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class RelationListDialog
extends ToggleDialog
implements Layer.LayerChangeListener,
DataChangeListener {
    private final DefaultListModel list = new DefaultListModel();
    private JList displaylist = new JList(this.list);
    private EditAction editAction;
    private DeleteAction deleteAction;

    public RelationListDialog() {
        super(I18n.tr("Relations"), "relationlist", I18n.tr("Open a list of all relations."), Shortcut.registerShortcut("subwindow:relations", I18n.tr("Toggle: {0}", I18n.tr("Relations")), 82, 4), 150);
        this.displaylist.setCellRenderer(new OsmPrimitivRenderer());
        this.displaylist.setSelectionMode(0);
        this.displaylist.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                    Main.ds.setSelected((Relation)RelationListDialog.this.displaylist.getSelectedValue());
                }
            }
        });
        this.add((Component)new JScrollPane(this.displaylist), "Center");
        JPanel jPanel = new JPanel(new GridLayout(1, 3));
        jPanel.add((Component)new SideButton(I18n.marktr("New"), "addrelation", "Selection", I18n.tr("Create a new relation"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RelationEditor.getEditor(Main.map.mapView.getEditLayer(), null, null).setVisible(true);
            }
        }), GBC.std());
        this.editAction = new EditAction();
        this.displaylist.addListSelectionListener(this.editAction);
        this.displaylist.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                    RelationListDialog.this.editAction.run();
                }
            }
        });
        jPanel.add((Component)new SideButton(this.editAction), GBC.std());
        this.deleteAction = new DeleteAction();
        this.displaylist.addListSelectionListener(this.deleteAction);
        jPanel.add((Component)new SideButton(this.deleteAction), GBC.eol());
        this.add((Component)jPanel, "South");
        Layer.listeners.add(this);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.updateList();
        }
    }

    public void updateList() {
        Relation relation = this.getSelected();
        this.list.setSize(Main.ds.relations.size());
        int n = 0;
        for (OsmPrimitive osmPrimitive : DataSet.sort(Main.ds.relations)) {
            if (osmPrimitive.deleted || osmPrimitive.incomplete) continue;
            this.list.setElementAt(osmPrimitive, n++);
        }
        this.list.setSize(n);
        if (Main.ds.relations.size() != 0) {
            this.setTitle(I18n.tr("Relations: {0}", Main.ds.relations.size()), true);
        } else {
            this.setTitle(I18n.tr("Relations"), false);
        }
        this.selectRelation(relation);
    }

    public void activeLayerChange(Layer layer, Layer layer2) {
        if ((layer == null || layer instanceof OsmDataLayer) && layer2 instanceof OsmDataLayer) {
            if (layer != null) {
                ((OsmDataLayer)layer).listenerDataChanged.remove(this);
            }
            ((OsmDataLayer)layer2).listenerDataChanged.add(this);
            this.updateList();
            this.repaint();
        }
    }

    public void layerRemoved(Layer layer) {
        if (layer instanceof OsmDataLayer) {
            ((OsmDataLayer)layer).listenerDataChanged.remove(this);
        }
    }

    public void layerAdded(Layer layer) {
        if (layer instanceof OsmDataLayer) {
            ((OsmDataLayer)layer).listenerDataChanged.add(this);
        }
    }

    public void dataChanged(OsmDataLayer osmDataLayer) {
        this.updateList();
        this.repaint();
    }

    public Relation getCurrentRelation() {
        return (Relation)this.displaylist.getSelectedValue();
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.displaylist.addListSelectionListener(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.displaylist.removeListSelectionListener(listSelectionListener);
    }

    private Relation getSelected() {
        if (this.list.size() == 1) {
            this.displaylist.setSelectedIndex(0);
        }
        return (Relation)this.displaylist.getSelectedValue();
    }

    public void selectRelation(Relation relation) {
        Relation relation2;
        if (relation == null) {
            this.displaylist.clearSelection();
            return;
        }
        int n = -1;
        for (n = 0; n < this.list.getSize() && (relation2 = (Relation)this.list.get(n)) != relation; ++n) {
        }
        if (n >= 0 && n < this.list.getSize()) {
            this.displaylist.setSelectedIndex(n);
            this.displaylist.ensureIndexIsVisible(n);
        } else {
            this.displaylist.clearSelection();
        }
    }

    class DeleteAction
    extends AbstractAction
    implements ListSelectionListener,
    Runnable {
        public DeleteAction() {
            this.putValue("ShortDescription", I18n.tr("Delete the selected relation"));
            this.putValue("Name", I18n.tr("Delete"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.setEnabled(false);
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            Relation relation = RelationListDialog.this.getSelected();
            if (relation == null) {
                return;
            }
            Main.main.undoRedo.add(new DeleteCommand(Collections.singleton(relation)));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.run();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(RelationListDialog.this.displaylist.getSelectedIndices() != null && RelationListDialog.this.displaylist.getSelectedIndices().length > 0);
        }
    }

    class EditAction
    extends AbstractAction
    implements ListSelectionListener,
    Runnable {
        public EditAction() {
            this.putValue("ShortDescription", I18n.tr("Open an editor for the selected relation"));
            this.putValue("Name", I18n.tr("Edit"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
            this.setEnabled(false);
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            Relation relation = RelationListDialog.this.getSelected();
            if (relation == null) {
                return;
            }
            RelationEditor.getEditor(Main.map.mapView.getEditLayer(), relation, null).setVisible(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.run();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(RelationListDialog.this.displaylist.getSelectedIndices() != null && RelationListDialog.this.displaylist.getSelectedIndices().length > 0);
        }
    }
}

