/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.MergeVisitor;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.RelationNodeMap;
import org.openstreetmap.josm.gui.dialogs.relation.TagCellEditor;
import org.openstreetmap.josm.gui.dialogs.relation.TagEditorModel;
import org.openstreetmap.josm.gui.dialogs.relation.TagTable;
import org.openstreetmap.josm.gui.dialogs.relation.WayConnectionType;
import org.openstreetmap.josm.gui.dialogs.relation.ac.AutoCompletionCache;
import org.openstreetmap.josm.gui.dialogs.relation.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmServerObjectReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericRelationEditor
extends RelationEditor {
    protected static final String applyChangesText = I18n.tr("Apply Changes");
    private JLabel status;
    private final DefaultTableModel memberData = new DefaultTableModel(){

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return n == 1 ? OsmPrimitive.class : String.class;
        }
    };
    private final JTable memberTable = new JTable(this.memberData);
    private TagEditorModel tagEditorModel;
    private TagTable tagTable;
    private AutoCompletionCache acCache;
    private AutoCompletionList acList;

    public GenericRelationEditor(OsmDataLayer osmDataLayer, Relation relation, Collection<RelationMember> collection) {
        super(osmDataLayer, relation, collection);
        this.acCache = AutoCompletionCache.getCacheForLayer(Main.map.mapView.getEditLayer());
        this.acList = new AutoCompletionList();
        JPanel jPanel = this.setupBasicLayout(collection);
        if (relation != null) {
            this.tagEditorModel.initFromPrimitive(relation);
        } else {
            this.tagEditorModel.clear();
        }
        this.tagEditorModel.ensureOneTag();
        this.addWindowListener(new WindowAdapter(){

            protected void requestFocusInTopLeftCell() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        GenericRelationEditor.this.tagEditorModel.ensureOneTag();
                        GenericRelationEditor.this.tagTable.requestFocusInCell(0, 0);
                    }
                });
            }

            public void windowDeiconified(WindowEvent windowEvent) {
                this.requestFocusInTopLeftCell();
            }

            public void windowOpened(WindowEvent windowEvent) {
                this.requestFocusInTopLeftCell();
            }
        });
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add((Component)jPanel, I18n.tr("Basic"));
        jTabbedPane.setPreferredSize(new Dimension(100, 100));
        this.contentConstraints = GBC.eol().fill().insets(5, 10, 5, 0);
        this.setupDialog(jTabbedPane, new String[]{"ok.png", "cancel.png"});
        this.setSize(this.findMaxDialogSize());
        try {
            this.setAlwaysOnTop(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.setVisible(true);
    }

    private JPanel setupBasicLayout(Collection<RelationMember> collection) {
        this.tagEditorModel = new TagEditorModel();
        this.tagTable = new TagTable(this.tagEditorModel);
        this.acCache.initFromJOSMDataset();
        TagCellEditor tagCellEditor = (TagCellEditor)this.tagTable.getColumnModel().getColumn(0).getCellEditor();
        tagCellEditor.setAutoCompletionCache(this.acCache);
        tagCellEditor.setAutoCompletionList(this.acList);
        tagCellEditor = (TagCellEditor)this.tagTable.getColumnModel().getColumn(1).getCellEditor();
        tagCellEditor.setAutoCompletionCache(this.acCache);
        tagCellEditor.setAutoCompletionList(this.acList);
        this.memberData.setColumnIdentifiers(new String[]{I18n.tr("Role"), I18n.tr("Occupied By"), I18n.tr("linked")});
        this.memberTable.setSelectionMode(2);
        this.memberTable.getColumnModel().getColumn(1).setCellRenderer(new OsmPrimitivRenderer());
        this.memberData.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getType() == 0 && tableModelEvent.getColumn() == 0) {
                    int n = tableModelEvent.getFirstRow();
                    GenericRelationEditor.this.getClone().members.get((int)n).role = GenericRelationEditor.this.memberData.getValueAt(n, 0).toString();
                }
            }
        });
        ListSelectionModel listSelectionModel = this.memberTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ArrayList<OsmPrimitive> arrayList;
                int n = GenericRelationEditor.this.memberTable.getSelectedRowCount();
                if (n > 0) {
                    arrayList = new ArrayList<OsmPrimitive>(n);
                    for (int n2 : GenericRelationEditor.this.memberTable.getSelectedRows()) {
                        arrayList.add((OsmPrimitive)GenericRelationEditor.this.memberTable.getValueAt(n2, 1));
                    }
                } else {
                    n = GenericRelationEditor.this.memberTable.getRowCount();
                    arrayList = new ArrayList(n);
                    for (int i = 0; i < n; ++i) {
                        arrayList.add((OsmPrimitive)GenericRelationEditor.this.memberTable.getValueAt(i, 1));
                    }
                }
                Main.ds.setSelected(arrayList);
            }
        });
        this.memberTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("Tags")), GBC.eol().fill(2));
        final JScrollPane jScrollPane = new JScrollPane(this.tagTable);
        jScrollPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                super.componentResized(componentEvent);
                Dimension dimension = jScrollPane.getViewport().getExtentSize();
                GenericRelationEditor.this.tagTable.adjustColumnWidth(dimension.width);
            }
        });
        jPanel.add((Component)jScrollPane, GBC.eop().fill(1));
        this.status = new JLabel(I18n.tr("Members"));
        jPanel.add((Component)this.status, GBC.eol().fill(2));
        JPanel jPanel2 = this.setupBasicButtons();
        jPanel.add((Component)new JScrollPane(this.memberTable), GBC.eol().fill(1));
        jPanel.add((Component)jPanel2, GBC.eop().fill(2));
        this.refreshTables();
        if (collection != null) {
            boolean bl = false;
            block0: for (int i = 0; i < this.memberData.getRowCount(); ++i) {
                for (RelationMember relationMember : collection) {
                    if (relationMember.member != this.memberData.getValueAt(i, 1) || !relationMember.role.equals(this.memberData.getValueAt(i, 0))) continue;
                    this.memberTable.addRowSelectionInterval(i, i);
                    if (bl) continue block0;
                    this.memberTable.scrollRectToVisible(this.memberTable.getCellRect(i, 0, true));
                    bl = true;
                    continue block0;
                }
            }
        }
        return jPanel;
    }

    private JPanel setupBasicButtons() {
        JPanel jPanel = new JPanel(new GridLayout(2, 4));
        jPanel.add(this.createButton(I18n.marktr("Move Up"), "moveup", I18n.tr("Move the currently selected members up"), 78, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenericRelationEditor.this.moveMembers(-1);
            }
        }));
        jPanel.add(this.createButton(I18n.marktr("Add Selected"), "addselected", I18n.tr("Add all currently selected objects as members"), 68, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenericRelationEditor.this.addSelected();
            }
        }));
        jPanel.add(this.createButton(I18n.marktr("Remove Selected"), "removeselected", I18n.tr("Remove all currently selected objects from relation"), 83, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenericRelationEditor.this.deleteSelected();
            }
        }));
        jPanel.add(this.createButton(I18n.marktr("Sort"), "sort", I18n.tr("Sort the selected relation members or the whole list"), 79, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenericRelationEditor.this.sort();
            }
        }));
        jPanel.add(this.createButton(I18n.marktr("Move Down"), "movedown", I18n.tr("Move the currently selected members down"), 74, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenericRelationEditor.this.moveMembers(1);
            }
        }));
        jPanel.add(this.createButton(I18n.marktr("Remove"), "remove", I18n.tr("Remove the member in the current table row from this relation"), 88, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = GenericRelationEditor.this.memberTable.getSelectedRows();
                RelationMember relationMember = new RelationMember();
                for (int n : nArray) {
                    relationMember.role = GenericRelationEditor.this.memberTable.getValueAt(n, 0).toString();
                    relationMember.member = (OsmPrimitive)GenericRelationEditor.this.memberTable.getValueAt(n, 1);
                    GenericRelationEditor.this.getClone().members.remove(relationMember);
                }
                GenericRelationEditor.this.refreshTables();
            }
        }));
        jPanel.add(this.createButton(I18n.marktr("Download Members"), "downloadincomplete", I18n.tr("Download all incomplete ways and nodes in relation"), 75, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenericRelationEditor.this.downloadRelationMembers();
                GenericRelationEditor.this.refreshTables();
            }
        }));
        return jPanel;
    }

    private void sort() {
        Object object2;
        LinkedList<Integer> linkedList;
        RelationNodeMap relationNodeMap = new RelationNodeMap(this.getClone());
        Vector vector = new Vector();
        if (relationNodeMap.remove(0, this.getClone().members.get(0))) {
            linkedList = new LinkedList<Integer>();
            linkedList.add(0);
            vector.add(linkedList);
        }
        while (!relationNodeMap.isEmpty()) {
            boolean bl;
            linkedList = (LinkedList<Integer>)vector.lastElement();
            do {
                Object object3;
                Object object4;
                block30: {
                    Object object6;
                    bl = false;
                    object4 = null;
                    object3 = null;
                    if (linkedList.size() == 1) {
                        object2 = this.getClone().members.get((Integer)linkedList.getFirst());
                        try {
                            object6 = (Way)((RelationMember)object2).member;
                            object3 = ((Way)object6).lastNode();
                            object4 = ((Way)object6).firstNode();
                        }
                        catch (ClassCastException classCastException) {
                            try {
                                Node classCastException2 = (Node)((RelationMember)object2).member;
                                object3 = classCastException2;
                            }
                            catch (ClassCastException classCastException2) {}
                        }
                    } else {
                        Comparable<Integer> comparable;
                        Object object;
                        block31: {
                            object2 = this.getClone().members.get((Integer)linkedList.getFirst());
                            object6 = this.getClone().members.get((Integer)linkedList.get(1));
                            try {
                                Way classCastException = (Way)((RelationMember)object2).member;
                                try {
                                    object = (Way)((RelationMember)object6).member;
                                    if (classCastException.firstNode() == ((Way)object).firstNode() || classCastException.firstNode() == ((Way)object).lastNode()) {
                                        object4 = classCastException.lastNode();
                                        break block31;
                                    }
                                    object4 = classCastException.firstNode();
                                }
                                catch (ClassCastException classCastException3) {
                                    try {
                                        comparable = (Node)((RelationMember)object6).member;
                                        object4 = classCastException.firstNode() == comparable ? classCastException.lastNode() : classCastException.firstNode();
                                    }
                                    catch (ClassCastException classCastException4) {}
                                }
                            }
                            catch (ClassCastException classCastException) {
                                try {
                                    object4 = object = (Node)((RelationMember)object2).member;
                                }
                                catch (ClassCastException classCastException5) {
                                    // empty catch block
                                }
                            }
                        }
                        object2 = this.getClone().members.get((Integer)linkedList.getLast());
                        object6 = this.getClone().members.get((Integer)linkedList.get(linkedList.size() - 2));
                        try {
                            Way way = (Way)((RelationMember)object2).member;
                            try {
                                object = (Way)((RelationMember)object6).member;
                                if (way.firstNode() == ((Way)object).firstNode() || way.firstNode() == ((Way)object).lastNode()) {
                                    object3 = way.lastNode();
                                    break block30;
                                }
                                object3 = way.firstNode();
                            }
                            catch (ClassCastException classCastException) {
                                try {
                                    comparable = (Node)((RelationMember)object6).member;
                                    object3 = way.firstNode() == comparable ? way.lastNode() : way.firstNode();
                                }
                                catch (ClassCastException classCastException6) {}
                            }
                        }
                        catch (ClassCastException classCastException) {
                            try {
                                object3 = object = (Node)((RelationMember)object2).member;
                            }
                            catch (ClassCastException classCastException7) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (object4 != null && (object2 = relationNodeMap.find((Node)object4, (Integer)linkedList.getFirst())) != null) {
                    linkedList.add(0, (Integer)object2);
                    relationNodeMap.remove((Integer)object2, this.getClone().members.get((Integer)object2));
                    bl = true;
                }
                if (object3 == null || (object2 = relationNodeMap.find((Node)object3, (Integer)linkedList.getLast())) == null) continue;
                linkedList.add(linkedList.size(), (Integer)object2);
                relationNodeMap.remove((Integer)object2, this.getClone().members.get((Integer)object2));
                bl = true;
            } while (bl);
            object2 = relationNodeMap.pop();
            if (object2 == null) break;
            linkedList = new LinkedList();
            linkedList.add((Integer)object2);
            vector.add(linkedList);
        }
        linkedList = new LinkedList<Integer>();
        linkedList.addAll(relationNodeMap.getRemaining());
        vector.add(linkedList);
        object2 = new ArrayList();
        for (LinkedList linkedList2 : vector) {
            for (Comparable<Integer> comparable : linkedList2) {
                ((ArrayList)object2).add(this.getClone().members.get((int)comparable));
            }
        }
        this.getClone().members.clear();
        this.getClone().members.addAll((Collection<RelationMember>)object2);
        this.refreshTables();
    }

    private void applyChanges() {
        if (this.getRelation() == null) {
            if (this.getClone().members.size() == 0 && this.tagEditorModel.getKeys().isEmpty()) {
                return;
            }
            this.tagEditorModel.applyToPrimitive(this.getClone());
            Main.main.undoRedo.add(new AddCommand(this.getClone()));
            DataSet.fireSelectionChanged(Main.ds.getSelected());
        } else if (!this.getRelation().hasEqualSemanticAttributes(this.getClone()) || this.tagEditorModel.isDirty()) {
            this.tagEditorModel.applyToPrimitive(this.getClone());
            Main.main.undoRedo.add(new ChangeCommand(this.getRelation(), this.getClone()));
            DataSet.fireSelectionChanged(Main.ds.getSelected());
        }
    }

    @Override
    protected void buttonAction(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (applyChangesText.equals(string)) {
            this.applyChanges();
        }
        this.setVisible(false);
    }

    @Override
    protected Dimension findMaxDialogSize() {
        return new Dimension(600, 500);
    }

    protected void updateMemberReferencesInClone() {
        DataSet dataSet = this.getLayer().data;
        for (RelationMember relationMember : this.getClone().members) {
            OsmPrimitive osmPrimitive;
            if (relationMember.member.id == 0L || (osmPrimitive = dataSet.getPrimitiveById(relationMember.member.id)) == null) continue;
            relationMember.member = osmPrimitive;
        }
    }

    private void refreshTables() {
        int n = 0;
        this.memberData.setRowCount(0);
        for (int i = 0; i < this.getClone().members.size(); ++i) {
            int n2;
            RelationMember relationMember = this.getClone().members.get(i);
            WayConnectionType wayConnectionType = WayConnectionType.none;
            RelationMember relationMember2 = relationMember;
            RelationMember relationMember3 = null;
            RelationMember relationMember4 = null;
            for (n2 = 0; relationMember2 != null && n2 < 10; ++n2) {
                if (relationMember2.member instanceof Way) {
                    relationMember3 = relationMember2;
                    break;
                }
                if (!(relationMember2.member instanceof Relation) || relationMember2.member == this.getRelation()) break;
                relationMember2 = ((Relation)relationMember2.member).lastMember();
            }
            if (relationMember3 != null) {
                int n3 = (i + 1) % this.getClone().members.size();
                while (n3 != i) {
                    relationMember2 = this.getClone().members.get(n3);
                    n3 = (n3 + 1) % this.getClone().members.size();
                    for (n2 = 0; relationMember2 != null && n2 < 10; ++n2) {
                        if (relationMember2.member instanceof Way) {
                            relationMember4 = relationMember2;
                            break;
                        }
                        if (!(relationMember2.member instanceof Relation) || relationMember2.member == this.getRelation()) break;
                        relationMember2 = ((Relation)relationMember2.member).firstMember();
                    }
                    if (relationMember4 == null) continue;
                }
            }
            if (relationMember4 != null) {
                Node node = ((Way)relationMember3.member).firstNode();
                Node node2 = ((Way)relationMember3.member).lastNode();
                Node node3 = ((Way)relationMember4.member).firstNode();
                Node node4 = ((Way)relationMember4.member).lastNode();
                if (node != null && node3 != null && node.equals(node3)) {
                    wayConnectionType = WayConnectionType.tail_to_tail;
                } else if (node != null && node4 != null && node.equals(node4)) {
                    wayConnectionType = WayConnectionType.tail_to_head;
                } else if (node2 != null && node3 != null && node2.equals(node3)) {
                    wayConnectionType = WayConnectionType.head_to_tail;
                } else if (node2 != null && node4 != null && node2.equals(node4)) {
                    wayConnectionType = WayConnectionType.head_to_head;
                }
                if (wayConnectionType != WayConnectionType.none) {
                    ++n;
                }
            }
            this.memberData.addRow(new Object[]{relationMember.role, relationMember.member, wayConnectionType});
        }
        this.status.setText(I18n.tr("Members: {0} (linked: {1})", this.getClone().members.size(), n));
    }

    private SideButton createButton(String string, String string2, String string3, int n, ActionListener actionListener) {
        return new SideButton(string, string2, "relationEditor", string3, Shortcut.registerShortcut("relationeditor:" + string2, I18n.tr("Relation Editor: {0}", string == null ? string3 : string), n, 6), actionListener);
    }

    private void addSelected() {
        for (OsmPrimitive osmPrimitive : Main.ds.getSelected()) {
            RelationMember relationMember = new RelationMember();
            relationMember.member = osmPrimitive;
            relationMember.role = "";
            int[] nArray = this.memberTable.getSelectedRows();
            if (nArray.length > 0) {
                this.getClone().members.add(nArray[0], relationMember);
                continue;
            }
            this.getClone().members.add(relationMember);
        }
        this.refreshTables();
    }

    private void deleteSelected() {
        for (OsmPrimitive osmPrimitive : Main.ds.getSelected()) {
            Relation relation = new Relation(this.getClone());
            for (RelationMember relationMember : relation.members) {
                if (relationMember.member != osmPrimitive) continue;
                RelationMember relationMember2 = new RelationMember();
                relationMember2.role = relationMember.role;
                relationMember2.member = relationMember.member;
                this.getClone().members.remove(relationMember2);
            }
        }
        this.refreshTables();
    }

    private void moveMembers(int n) {
        int[] nArray = this.memberTable.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        if (nArray[0] + n < 0) {
            return;
        }
        if (nArray[nArray.length - 1] + n >= this.getClone().members.size()) {
            return;
        }
        RelationMember[] relationMemberArray = new RelationMember[this.getClone().members.size()];
        int[] nArray2 = nArray;
        int n2 = nArray2.length;
        for (int i = 0; i < n2; ++i) {
            Integer n3 = nArray2[i];
            relationMemberArray[n3.intValue() + n] = this.getClone().members.get(n3);
            this.getClone().members.set(n3, null);
        }
        int n4 = 0;
        for (RelationMember relationMember : this.getClone().members) {
            if (relationMember == null) continue;
            while (relationMemberArray[n4] != null) {
                ++n4;
            }
            relationMemberArray[n4++] = relationMember;
        }
        this.getClone().members.clear();
        this.getClone().members.addAll(Arrays.asList(relationMemberArray));
        this.refreshTables();
        ListSelectionModel listSelectionModel = this.memberTable.getSelectionModel();
        listSelectionModel.setValueIsAdjusting(true);
        int[] nArray3 = nArray;
        int n5 = nArray3.length;
        for (int i = 0; i < n5; ++i) {
            Integer n6 = nArray3[i];
            listSelectionModel.addSelectionInterval(n6 + n, n6 + n);
        }
        listSelectionModel.setValueIsAdjusting(false);
    }

    private void downloadRelationMembers() {
        boolean bl = false;
        for (RelationMember relationMember : this.getClone().members) {
            if (!relationMember.member.incomplete) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        class DownloadTask
        extends PleaseWaitRunnable {
            private boolean cancelled;
            private Exception lastException;

            protected void setIndeterminateEnabled(final boolean bl) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        Main.pleaseWaitDlg.setIndeterminate(bl);
                    }
                });
            }

            public DownloadTask() {
                super(I18n.tr("Download relation members"), false);
            }

            protected void cancel() {
                this.cancelled = true;
                OsmApi.getOsmApi().cancel();
            }

            protected void showLastException() {
                String string = this.lastException.getMessage();
                if (string == null) {
                    string = this.lastException.toString();
                }
                JOptionPane.showMessageDialog(null, string, I18n.tr("Error"), 0);
            }

            protected void finish() {
                if (this.cancelled) {
                    return;
                }
                GenericRelationEditor.this.updateMemberReferencesInClone();
                GenericRelationEditor.this.refreshTables();
                if (this.lastException == null) {
                    return;
                }
                this.showLastException();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void realRun() throws SAXException, IOException, OsmTransferException {
                try {
                    Main.pleaseWaitDlg.setAlwaysOnTop(true);
                    Main.pleaseWaitDlg.toFront();
                    this.setIndeterminateEnabled(true);
                    OsmServerObjectReader osmServerObjectReader = new OsmServerObjectReader(GenericRelationEditor.this.getClone().id, OsmPrimitiveType.RELATION, true);
                    DataSet dataSet = osmServerObjectReader.parseOsm();
                    if (dataSet != null) {
                        MergeVisitor mergeVisitor = new MergeVisitor(GenericRelationEditor.this.getLayer().data, dataSet);
                        mergeVisitor.merge();
                        for (DataSource object2 : dataSet.dataSources) {
                            GenericRelationEditor.this.getLayer().data.dataSources.add(object2);
                        }
                        GenericRelationEditor.this.getLayer().fireDataChange();
                        if (mergeVisitor.getConflicts().isEmpty()) {
                            return;
                        }
                        GenericRelationEditor.this.getLayer().getConflicts().add(mergeVisitor.getConflicts());
                        JOptionPane jOptionPane = new JOptionPane(I18n.tr("There were {0} conflicts during import.", mergeVisitor.getConflicts().size()), 2);
                        JDialog jDialog = jOptionPane.createDialog(Main.pleaseWaitDlg, I18n.tr("Conflicts in data"));
                        jDialog.setAlwaysOnTop(true);
                        jDialog.setModal(true);
                        jDialog.setDefaultCloseOperation(2);
                        jDialog.setVisible(true);
                    }
                }
                catch (Exception exception) {
                    if (this.cancelled) {
                        System.out.println(I18n.tr("Warning: ignoring exception because task is cancelled. Exception: {0}", exception.toString()));
                        return;
                    }
                    this.lastException = exception;
                }
                finally {
                    Main.pleaseWaitDlg.setAlwaysOnTop(false);
                    this.setIndeterminateEnabled(false);
                }
            }
        }
        Main.worker.submit(new DownloadTask());
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl) {
            this.dispose();
        }
    }
}

