/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.dialogs.relation.TagModel;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagEditorModel
extends AbstractTableModel {
    private static final Logger logger = Logger.getLogger(TagEditorModel.class.getName());
    public static final String PROP_DIRTY = TagEditorModel.class.getName() + ".dirty";
    private ArrayList<TagModel> tags = new ArrayList();
    private boolean dirty = false;
    private PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removeProperyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    protected void fireDirtyStateChanged(boolean bl, boolean bl2) {
        this.propChangeSupport.firePropertyChange(PROP_DIRTY, bl, bl2);
    }

    protected void setDirty(boolean bl) {
        boolean bl2 = this.dirty;
        this.dirty = bl;
        if (bl2 != bl) {
            this.fireDirtyStateChanged(bl2, bl);
        }
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.tags.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n >= this.getRowCount()) {
            throw new IndexOutOfBoundsException("unexpected rowIndex: rowIndex=" + n);
        }
        TagModel tagModel = this.tags.get(n);
        switch (n2) {
            case 0: 
            case 1: {
                return tagModel;
            }
        }
        throw new IndexOutOfBoundsException("unexpected columnIndex: columnIndex=" + n2);
    }

    public void clear() {
        this.tags.clear();
        this.setDirty(true);
        this.fireTableDataChanged();
    }

    public void add(TagModel tagModel) {
        if (tagModel == null) {
            throw new IllegalArgumentException("argument 'tag' must not be null");
        }
        this.tags.add(tagModel);
        this.setDirty(true);
        this.fireTableDataChanged();
    }

    public void prepend(TagModel tagModel) {
        if (tagModel == null) {
            throw new IllegalArgumentException("argument 'tag' must not be null");
        }
        this.tags.add(0, tagModel);
        this.setDirty(true);
        this.fireTableDataChanged();
    }

    public void add(String string, String string2) {
        string = string == null ? "" : string;
        string2 = string2 == null ? "" : string2;
        TagModel tagModel = this.get(string);
        if (tagModel == null) {
            tagModel = new TagModel(string, string2);
            this.add(tagModel);
        } else {
            tagModel.addValue(string2);
        }
        this.setDirty(true);
    }

    public TagModel get(String string) {
        string = string == null ? "" : string;
        for (TagModel tagModel : this.tags) {
            if (!tagModel.getName().equals(string)) continue;
            return tagModel;
        }
        return null;
    }

    public TagModel get(int n) {
        TagModel tagModel = this.tags.get(n);
        return tagModel;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public void deleteTagNames(int[] nArray) {
        if (this.tags == null) {
            return;
        }
        for (int n : nArray) {
            TagModel tagModel = this.tags.get(n);
            if (tagModel == null) continue;
            tagModel.setName("");
        }
        this.fireTableDataChanged();
        this.setDirty(true);
    }

    public void deleteTagValues(int[] nArray) {
        if (this.tags == null) {
            return;
        }
        for (int n : nArray) {
            TagModel tagModel = this.tags.get(n);
            if (tagModel == null) continue;
            tagModel.setValue("");
        }
        this.fireTableDataChanged();
        this.setDirty(true);
    }

    public void deleteTags(int[] nArray) {
        if (this.tags == null) {
            return;
        }
        ArrayList<TagModel> arrayList = new ArrayList<TagModel>();
        for (int n : nArray) {
            TagModel tagModel = this.tags.get(n);
            if (tagModel == null) continue;
            arrayList.add(tagModel);
        }
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            TagModel tagModel = (TagModel)object.next();
            this.tags.remove(tagModel);
        }
        this.fireTableDataChanged();
        this.setDirty(true);
    }

    public void appendNewTag() {
        TagModel tagModel = new TagModel();
        this.tags.add(tagModel);
        this.fireTableDataChanged();
        this.setDirty(true);
    }

    public void ensureOneTag() {
        if (this.tags.size() == 0) {
            this.appendNewTag();
        }
    }

    public void initFromJOSMSelection() {
        Collection<OsmPrimitive> collection = Main.ds.getSelected();
        this.clear();
        for (OsmPrimitive osmPrimitive : collection) {
            for (String string : osmPrimitive.keySet()) {
                String string2 = osmPrimitive.get(string);
                this.add(string, string2);
            }
        }
        this.sort();
        this.setDirty(false);
    }

    public void initFromPrimitive(OsmPrimitive osmPrimitive) {
        this.clear();
        for (String string : osmPrimitive.keySet()) {
            String string2 = osmPrimitive.get(string);
            this.add(string, string2);
        }
        this.sort();
        this.setDirty(false);
    }

    public void applyToPrimitive(OsmPrimitive osmPrimitive) {
        for (TagModel tagModel : this.tags) {
            if (tagModel.getValueCount() > 1 || tagModel.getName().trim().equals("")) continue;
            osmPrimitive.put(tagModel.getName(), tagModel.getValue());
        }
    }

    public boolean includesTag(String string) {
        if (string == null) {
            return false;
        }
        for (TagModel tagModel : this.tags) {
            if (!tagModel.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    protected Command createUpdateTagCommand(Collection<OsmPrimitive> collection, TagModel tagModel) {
        if (tagModel.getValueCount() > 1) {
            return null;
        }
        if (tagModel.getName().trim().equals("")) {
            return null;
        }
        String string = tagModel.getName();
        String string2 = tagModel.getValue();
        ChangePropertyCommand changePropertyCommand = new ChangePropertyCommand(collection, string, string2);
        return changePropertyCommand;
    }

    protected Command createDeleteTagsCommand(Collection<OsmPrimitive> collection) {
        List<String> list = this.getKeys();
        ArrayList<Command> arrayList = new ArrayList<Command>();
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive.keys == null) continue;
            for (String string : osmPrimitive.keys.keySet()) {
                if (list.contains(string)) continue;
                ChangePropertyCommand changePropertyCommand = new ChangePropertyCommand(osmPrimitive, string, null);
                arrayList.add(changePropertyCommand);
            }
        }
        SequenceCommand sequenceCommand = new SequenceCommand(I18n.trn("Remove old keys from up to {0} object", "Remove old keys from up to {0} objects", collection.size(), collection.size()), arrayList);
        return sequenceCommand;
    }

    public void updateJOSMSelection() {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        Collection<OsmPrimitive> collection = Main.ds.getSelected();
        if (collection == null) {
            return;
        }
        for (TagModel object2 : this.tags) {
            Command command = this.createUpdateTagCommand(collection, object2);
            if (command == null) continue;
            arrayList.add(command);
        }
        Command command = this.createDeleteTagsCommand(collection);
        if (command != null) {
            arrayList.add(command);
        }
        SequenceCommand sequenceCommand = new SequenceCommand(I18n.trn("Updating properties of up to {0} object", "Updating properties of up to {0} objects", collection.size(), collection.size()), arrayList);
        Main.main.undoRedo.add(sequenceCommand);
    }

    public List<String> getKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TagModel tagModel : this.tags) {
            if (tagModel.getName().trim().equals("")) continue;
            arrayList.add(tagModel.getName());
        }
        return arrayList;
    }

    protected void sort() {
        Collections.sort(this.tags, new Comparator<TagModel>(){

            @Override
            public int compare(TagModel tagModel, TagModel tagModel2) {
                return tagModel.getName().compareTo(tagModel2.getName());
            }
        });
    }

    public void updateTagName(TagModel tagModel, String string) {
        String string2 = tagModel.getName();
        tagModel.setName(string);
        if (!string.equals(string2)) {
            this.setDirty(true);
        }
    }

    public void updateTagValue(TagModel tagModel, String string) {
        String string2 = tagModel.getValue();
        tagModel.setValue(string);
        if (!string.equals(string2)) {
            this.setDirty(true);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }
}

